/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.redis.base;

import com.peak.common.util.RedisService;
import com.peak.common.util.RedisStreamService;
import com.peak.common.util.SpringUtil;
import com.peak.prd.config.RedisConfig;
import com.peak.prd.listenner.base.BaseListener;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class BaseRedisStreamListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(BaseRedisStreamListener.class);
    @Autowired
    private RedisStreamService redisStreamService;
    @Autowired
    private RedisService redisService;
    @Autowired
    RedisConfig redisConfig;
    private StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer = null;
    private StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, String>> streamMessageListenerContainerOptions = null;

    String getKey(String key) {
        String prefix = this.redisConfig.getKeyPrefix();
        if (prefix == null) {
            return "MQ:" + key;
        }
        return prefix + "::MQ:" + key;
    }

    public StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, String>> listenerContainerOptions() {
        if (this.streamMessageListenerContainerOptions == null) {
            StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
            this.streamMessageListenerContainerOptions = StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().pollTimeout(Duration.ofSeconds(30L)).batchSize(10).serializer((RedisSerializer)stringRedisSerializer).build();
        }
        return this.streamMessageListenerContainerOptions;
    }

    public StreamMessageListenerContainer<String, MapRecord<String, String, String>> container(RedisConnectionFactory factory, StreamListener<String, MapRecord<String, String, String>> redisStreamListener, String topic, String groupId) {
        if (this.listenerContainer == null) {
            this.listenerContainer = StreamMessageListenerContainer.create((RedisConnectionFactory)factory, this.listenerContainerOptions());
        }
        String mqtopicKey = "peak:mqtopic:" + topicPrefix + topic + topicSuffix + ":" + groupId;
        this.redisService.set(mqtopicKey, "1", 86400000L);
        this.checkGroup(topicPrefix + topic + topicSuffix, groupId);
        this.listenerContainer.register(this.streamReadRequest(topic, groupId), redisStreamListener);
        this.listenerContainer.start();
        return this.listenerContainer;
    }

    private StreamMessageListenerContainer.StreamReadRequest<String> streamReadRequest(String topic, String groupId) {
        return StreamMessageListenerContainer.StreamReadRequest.builder((StreamOffset)StreamOffset.create((Object)this.getKey(topicPrefix + topic + topicSuffix), (ReadOffset)ReadOffset.lastConsumed())).consumer(Consumer.from((String)groupId, (String)UUID.randomUUID().toString())).cancelOnError(t -> false).build();
    }

    public void listen(MapRecord<String, String, String> message, String groupId, String hannlerPartName) {
        log.info("redis listen message getMessageQ > {}", (Object)(message + "  ==========  groupId:=== " + groupId + "  ==========  hannlerPartName:=== " + hannlerPartName));
        if (this.redisStreamService == null) {
            this.redisStreamService = (RedisStreamService)SpringUtil.getBean((String)"redisStreamService");
        }
        StreamOperations streamOperations = this.redisStreamService.opsForStream();
        streamOperations.acknowledge(message.getStream(), groupId, new RecordId[]{message.getId()});
        log.info("listen message acknowledge");
        String messagebody = (String)((Map)message.getValue()).get("payload");
        messagebody = messagebody.substring(messagebody.indexOf("{"));
        super.listen(messagebody, hannlerPartName);
    }

    private void checkGroup(String topic, String groupId) {
        boolean hasStream;
        if (this.redisStreamService == null) {
            this.redisStreamService = (RedisStreamService)SpringUtil.getBean((String)"redisStreamService");
        }
        if (!(hasStream = this.redisStreamService.hasStream(topic))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("field", "value");
            RecordId recordId = this.redisStreamService.send(topic, map);
            this.redisStreamService.createGroup(topic, groupId);
            this.redisStreamService.delRecord(topic, recordId.getValue());
            log.info("stream:{}-group:{} initialize success", (Object)topic, (Object)groupId);
        } else {
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(groupId);
            StreamInfo.XInfoGroups infoGroups = this.redisStreamService.getGroups(topic);
            for (String group : groups) {
                boolean groupExist = false;
                if (Objects.nonNull(infoGroups) && infoGroups.stream().anyMatch(t -> Objects.equals(group, t.groupName()))) {
                    groupExist = true;
                }
                if (groupExist) continue;
                this.redisStreamService.createGroup(topic, group);
            }
        }
    }
}

