/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.redis.base;

import com.peak.common.util.ListUtil;
import com.peak.common.util.RedisStreamService;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.config.PrimaryKeyConfig;
import com.peak.prd.config.RedisConfig;
import com.peak.prd.listenner.base.BaseListener;
import com.peak.prd.mq.sendlog.model.Sendlog;
import com.peak.prd.mq.sendlog.service.ISendlogPlusService;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineMiniVO;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerVO;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.StreamOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.stereotype.Component;

@Component
public class RedisStreamAutoListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(RedisStreamAutoListener.class);
    @Resource
    private RedisStreamService redisStreamService;
    @Resource
    RedisConfig redisConfig;
    @Resource
    PrimaryKeyConfig primaryKeyConfig;
    @Resource
    ISendlogPlusService sendlogPlusService;
    private boolean shouldExit = false;
    private StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, String>> streamMessageListenerContainerOptions = null;

    @Bean
    public void init() throws Exception {
        String appName = this.primaryKeyConfig.getApplication();
        ISysMqhandlerPlusService sysMqhandlerPlusService = (ISysMqhandlerPlusService)SpringUtil.getBean(ISysMqhandlerPlusService.class);
        List<SysMqhandlerVO> sysMqhandlerVOList = sysMqhandlerPlusService.getPublicHandlerList();
        if (!ListUtil.isNullorEmpty(sysMqhandlerVOList)) {
            this.shouldExit = true;
            for (int i = 0; i < sysMqhandlerVOList.size(); ++i) {
                String handlerName;
                SysMqhandlerVO sysMqhandlerVO = sysMqhandlerVOList.get(i);
                SysMqdefineMiniVO actionMqdefineVO = sysMqhandlerVO.getSysMqdefineMiniVO();
                AppdictVO svrappdict = sysMqhandlerVO.getSvrappdict();
                if (actionMqdefineVO == null || svrappdict == null || !svrappdict.getName().toLowerCase().equals(appName.toLowerCase()) || StringUtil.isNullorEmptyStr((String)(handlerName = sysMqhandlerVO.getClassname()))) continue;
                final String groupId = appName + sysMqhandlerVO.getGroupnum().toString();
                StreamListener<String, MapRecord<String, String, String>> redisStreamListener = new StreamListener<String, MapRecord<String, String, String>>(){

                    public void onMessage(MapRecord<String, String, String> message) {
                        log.info("redis listen message getMessageQ > {}", (Object)(message + "  ==========  groupId:=== " + groupId + "  ==========  hannlerPartName:=== " + handlerName));
                        RedisStreamAutoListener.this.consumeMessage((MapRecord<String, String, String>)message, groupId, handlerName);
                    }
                };
                this.addListener(actionMqdefineVO.getParentMqvalue(), groupId, actionMqdefineVO.getMqvalue(), handlerName, redisStreamListener);
            }
            this.shouldExit = false;
        }
        if (this.shouldExit) {
            System.exit(0);
        }
    }

    private void addListener(String topicNoPrefix, String groupId, String action, String handler, StreamListener<String, MapRecord<String, String, String>> redisStreamListener) {
        if (StringUtil.isNullorEmptyStr((String)topicNoPrefix) || StringUtil.isNullorEmptyStr((String)action)) {
            return;
        }
        String topic = topicPrefix + topicNoPrefix + "_" + action + topicSuffix;
        StreamMessageListenerContainer listenerContainer = null;
        try {
            listenerContainer = StreamMessageListenerContainer.create((RedisConnectionFactory)this.redisStreamService.getConnectionFactory(), this.listenerContainerOptions());
            this.checkGroup(topic, groupId, topicNoPrefix, action);
            listenerContainer.register(this.streamReadRequest(topic, groupId), redisStreamListener);
            listenerContainer.start();
            log.info("listen message consumer start topic=====groupId=====handler > {} ", (Object)(topic + "=====" + groupId + "=====" + handler));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private StreamMessageListenerContainer.StreamReadRequest<String> streamReadRequest(String topic, String groupId) {
        return StreamMessageListenerContainer.StreamReadRequest.builder((StreamOffset)StreamOffset.create((Object)this.getKey(topic), (ReadOffset)ReadOffset.lastConsumed())).consumer(Consumer.from((String)groupId, (String)UUID.randomUUID().toString())).cancelOnError(t -> false).build();
    }

    private StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, String>> listenerContainerOptions() {
        if (this.streamMessageListenerContainerOptions == null) {
            AtomicInteger index = new AtomicInteger(1);
            int processors = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(processors, processors, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), r -> {
                Thread thread = new Thread(r);
                thread.setName("async-stream-consumer-" + index.getAndIncrement());
                thread.setDaemon(true);
                return thread;
            });
            StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
            this.streamMessageListenerContainerOptions = StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().pollTimeout(Duration.ofSeconds(30L)).batchSize(10).serializer((RedisSerializer)stringRedisSerializer).errorHandler(throwable -> {
                log.error("[MQ handler exception]", throwable);
                throwable.printStackTrace();
            }).build();
        }
        return this.streamMessageListenerContainerOptions;
    }

    private void checkGroup(String topic, String groupId, String topicNoPrefix, String action) {
        boolean hasStream;
        if (this.redisStreamService == null) {
            this.redisStreamService = (RedisStreamService)SpringUtil.getBean((String)"redisStreamService");
        }
        if (!(hasStream = this.redisStreamService.hasStream(topic))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("field", "value");
            RecordId recordId = this.redisStreamService.send(topic, map);
            this.createGroup(topic, groupId, recordId.getValue(), topicNoPrefix, action);
            this.redisStreamService.delRecord(topic, recordId.getValue());
            log.info("stream:{}-group:{} initialize success", (Object)topic, (Object)groupId);
        } else {
            ArrayList<String> groups = new ArrayList<String>();
            groups.add(groupId);
            StreamInfo.XInfoGroups infoGroups = this.redisStreamService.getGroups(topic);
            boolean groupExist = false;
            if (Objects.nonNull(infoGroups) && infoGroups.stream().anyMatch(t -> Objects.equals(groupId, t.groupName()))) {
                groupExist = true;
            }
            if (!groupExist) {
                this.createGroup(topic, groupId, "", topicNoPrefix, action);
            }
        }
    }

    private void createGroup(String topic, String groupId, String maxRecordId, String topicNoPrefix, String action) {
        if (StringUtil.isNullorEmptyStr((String)maxRecordId)) {
            Sendlog sendlog = this.sendlogPlusService.getLastSendlog(topicNoPrefix, action);
            if (sendlog != null) {
                if (maxRecordId.startsWith("sendMessage_1_")) {
                    maxRecordId = sendlog.getSendutilmethod().replace("sendMessage_1_", "");
                }
            } else {
                maxRecordId = "";
            }
        }
        Boolean validGroup = false;
        if (!StringUtil.isNullorEmptyStr((String)maxRecordId)) {
            for (int n = 0; n < 10; ++n) {
                this.redisStreamService.createGroup(topic, groupId);
                StreamInfo.XInfoGroups infoGroups = this.redisStreamService.getGroups(topic);
                if (Objects.nonNull(infoGroups)) {
                    for (int i = 0; i < infoGroups.size(); ++i) {
                        StreamInfo.XInfoGroup infoGroup = infoGroups.get(i);
                        if (!infoGroup.groupName().equals(groupId)) continue;
                        String lastDeliveredId = infoGroup.lastDeliveredId().replace("-0", "");
                        maxRecordId = maxRecordId.replace("-0", "");
                        if (Long.valueOf(lastDeliveredId) < Long.valueOf(maxRecordId)) continue;
                        validGroup = true;
                        break;
                    }
                }
                if (validGroup.booleanValue()) break;
                this.redisStreamService.destroyGroup(topic, groupId);
            }
        }
        if (!validGroup.booleanValue()) {
            this.redisStreamService.createGroup(topic, groupId);
        }
    }

    private void consumeMessage(MapRecord<String, String, String> message, String groupId, String hannlerPartName) {
        if (this.redisStreamService == null) {
            this.redisStreamService = (RedisStreamService)SpringUtil.getBean((String)"redisStreamService");
        }
        StreamOperations streamOperations = this.redisStreamService.opsForStream();
        streamOperations.acknowledge(message.getStream(), groupId, new RecordId[]{message.getId()});
        log.info("listen message acknowledge");
        String messagebody = (String)((Map)message.getValue()).get("payload");
        messagebody = messagebody.substring(messagebody.indexOf("{"));
        super.autoListen(messagebody, hannlerPartName);
    }

    private String getKey(String key) {
        String prefix = this.redisConfig.getKeyPrefix();
        if (prefix == null) {
            return "MQ:" + key;
        }
        return prefix + "::MQ:" + key;
    }
}

