/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.redis4.base;

import com.peak.prd.listenner.base.BaseListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.stereotype.Component;

@Component
public class BaseRedisListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(BaseRedisListener.class);
    public static RedisMessageListenerContainer container = new RedisMessageListenerContainer();
    private AtomicInteger counter = new AtomicInteger();

    @Override
    public void listen(String message, String hannlerPartName) {
        super.listen(message, hannlerPartName);
        this.counter.incrementAndGet();
        log.debug("listen message commitAsync");
    }

    public MessageListenerAdapter listenerAdapter(Object redisListener, String defaultListenerMethod) {
        MessageListenerAdapter messageListenerAdapter = new MessageListenerAdapter(redisListener);
        messageListenerAdapter.setDefaultListenerMethod(defaultListenerMethod);
        return messageListenerAdapter;
    }

    public RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, List<MessageListenerAdapter> listenerAdapterList, String topic) {
        RedisConnectionFactory f = container.getConnectionFactory();
        if (f == null) {
            container.setConnectionFactory(connectionFactory);
        }
        for (MessageListenerAdapter listenerAdapter : listenerAdapterList) {
            listenerAdapter.afterPropertiesSet();
            container.addMessageListener((MessageListener)listenerAdapter, (Topic)new ChannelTopic(topicPrefix + topic + topicSuffix));
        }
        return container;
    }

    public RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter, String topic) {
        RedisMessageListenerContainer resisContainer = new RedisMessageListenerContainer();
        resisContainer.setConnectionFactory(connectionFactory);
        listenerAdapter.afterPropertiesSet();
        resisContainer.addMessageListener((MessageListener)listenerAdapter, (Topic)new ChannelTopic(topicPrefix + topic + topicSuffix));
        return resisContainer;
    }

    public int getCount() {
        return this.counter.get();
    }
}

