/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.listenner.rocketmq.base;

import com.peak.common.util.ListUtil;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.config.PrimaryKeyConfig;
import com.peak.prd.config.RocketMQConfig;
import com.peak.prd.listenner.base.BaseListener;
import com.peak.prd.sys.mqdefine.service.ISysMqdefinePlusService;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineVO;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerVO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragelyByCircle;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.consumer.ConsumeFromWhere;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class RocketMQAutoListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(RocketMQAutoListener.class);
    @Resource
    PrimaryKeyConfig primaryKeyConfig;
    private boolean shouldExit = false;

    @Bean
    public void init() throws Exception {
        String appName = this.primaryKeyConfig.getApplication();
        ISysMqdefinePlusService sysMqdefinePlusService = (ISysMqdefinePlusService)SpringUtil.getBean(ISysMqdefinePlusService.class);
        ISysMqhandlerPlusService sysMqhandlerPlusService = (ISysMqhandlerPlusService)SpringUtil.getBean(ISysMqhandlerPlusService.class);
        List<SysMqdefineVO> topicMqdefineVOList = sysMqdefinePlusService.getPublicSysMqdefineVOList();
        if (!ListUtil.isNullorEmpty(topicMqdefineVOList)) {
            this.shouldExit = true;
            for (SysMqdefineVO topicMqdefineVO : topicMqdefineVOList) {
                List<SysMqdefineVO> actionMqdefineVOList = topicMqdefineVO.getChildren();
                if (ListUtil.isNullorEmpty(actionMqdefineVOList)) continue;
                for (SysMqdefineVO actionMqdefineVO : actionMqdefineVOList) {
                    List<SysMqhandlerVO> sysMqhandlerVOList = sysMqhandlerPlusService.getPublicHandlerList(actionMqdefineVO.getMqdefineId());
                    if (ListUtil.isNullorEmpty(sysMqhandlerVOList)) continue;
                    for (int i = 0; i < sysMqhandlerVOList.size(); ++i) {
                        String handlerName;
                        SysMqhandlerVO sysMqhandlerVO = sysMqhandlerVOList.get(i);
                        AppdictVO svrappdict = sysMqhandlerVO.getSvrappdict();
                        if (svrappdict == null || !svrappdict.getName().toLowerCase().equals(appName.toLowerCase()) || StringUtil.isNullorEmptyStr((String)(handlerName = sysMqhandlerVO.getClassname()))) continue;
                        this.addListener(topicMqdefineVO.getMqvalue(), appName + sysMqhandlerVO.getGroupnum().toString(), actionMqdefineVO.getMqvalue(), handlerName);
                    }
                }
            }
            this.shouldExit = false;
        }
        if (this.shouldExit) {
            System.exit(0);
        }
    }

    private void addListener(String topicNoPrefix, String groupId, String action, String handler) throws MQClientException {
        log.info("rocketmq auto addListener =============> topicNoPrefix:{},action:{},groupId:{},handler:{}", new Object[]{topicNoPrefix, action, groupId, handler});
        RocketMQConfig rocketMQConfig = (RocketMQConfig)SpringUtil.getBean((String)"rocketMQConfig");
        DefaultMQPushConsumer defaultMQPushConsumer = new DefaultMQPushConsumer();
        log.info("rocketmq auto addListener =============> NamesrvAddr:{}", (Object)rocketMQConfig.getNamesrvAddr());
        defaultMQPushConsumer.setNamesrvAddr(rocketMQConfig.getNamesrvAddr());
        defaultMQPushConsumer.setConsumerGroup(topicNoPrefix + "_" + action + groupId);
        defaultMQPushConsumer.subscribe(topicPrefix + topicNoPrefix + "_" + action + topicSuffix, "*");
        defaultMQPushConsumer.setConsumeFromWhere(ConsumeFromWhere.CONSUME_FROM_FIRST_OFFSET);
        defaultMQPushConsumer.setAllocateMessageQueueStrategy((AllocateMessageQueueStrategy)new AllocateMessageQueueAveragelyByCircle());
        defaultMQPushConsumer.registerMessageListener((msgs, context) -> {
            for (MessageExt msg : msgs) {
                log.info("rocketmq auto Listener consumer=============> topicNoPrefix:{},action:{},groupId:{},handler:{}", new Object[]{topicNoPrefix, action, groupId, handler});
                String messagebody = new String(msg.getBody());
                super.autoListen(messagebody, handler);
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        });
        defaultMQPushConsumer.start();
    }
}

