/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.lms.common.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.DownloadFileUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.SignUtil;
import com.peak.common.util.UploadFileDBUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.model.ResponseStatusEnum;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.common.util.CorePathUtil;
import com.peak.prd.enums.CoreResponseStatusEnum;
import com.peak.prd.enums.FileTypeEnum;
import com.peak.prd.lms.common.bo.FilesQueryBO;
import com.peak.prd.lms.common.dao.IFilesPlusDao;
import com.peak.prd.lms.common.model.Files;
import com.peak.prd.lms.common.service.IFilesPlusService;
import com.peak.prd.lms.common.vo.FilesProVO;
import com.peak.prd.lms.common.vo.FilesQuery;
import com.peak.prd.lms.common.vo.FilesVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FilesPlusService
extends PrdBaseService<Files, Long, FilesQuery>
implements IFilesPlusService {
    private IFilesPlusDao filesPlusDao;

    public void setFilesPlusDao(IFilesPlusDao dao) {
        this.filesPlusDao = dao;
    }

    public IFilesPlusDao getFilesPlusDao() {
        return this.filesPlusDao;
    }

    public IEntityDao<Files, Long, FilesQuery> getEntityDao() {
        return this.filesPlusDao;
    }

    @Override
    public Files insert(String filename, String srcfilename, String filenameext, String filepath, Long filesize, Integer type) throws Exception {
        Files file = new Files();
        file.setFileId(IPrimaryKey.DEFAULT.getSequence("LMS_FILES"));
        file.setFilename(filename);
        file.setFilepath(filepath);
        file.setFilesize(filesize);
        file.setFilenameext(filenameext.replace(".", ""));
        file.setSrcfilename(srcfilename);
        file.setDomainId(9002L);
        file.setGkey(UUID.randomUUID().toString());
        file.setType(type);
        file.setDeleted(0);
        file.setCreatedate(new Date());
        this.filesPlusDao.insert((BaseEntity)file);
        return file;
    }

    @Override
    public Files insert(@NotBlank String filename, @NotBlank String srcfilename, @NotBlank String filenameext, @NotBlank String filepath, @NotNull Long filesize, @NotNull Integer type, @NotNull Long srcobjectId) throws Exception {
        Files file = new Files();
        file.setFileId(IPrimaryKey.DEFAULT.getSequence("LMS_FILES"));
        file.setFilename(filename);
        file.setFilepath(filepath);
        file.setFilesize(filesize);
        file.setFilenameext(filenameext.replace(".", ""));
        file.setSrcfilename(srcfilename);
        file.setSrcobjectId(srcobjectId);
        file.setDomainId(9002L);
        file.setGkey(UUID.randomUUID().toString());
        file.setType(type);
        file.setDeleted(0);
        file.setCreatedate(new Date());
        this.filesPlusDao.insert((BaseEntity)file);
        return file;
    }

    @Override
    public Files insert(@NotBlank String filename, @NotBlank String srcfilename, @NotBlank String filenameext, @NotBlank String filepath, @NotNull Long filesize, @NotNull Integer type, @NotNull Long srcobjectId, @NotNull Integer subtype) throws Exception {
        Files file = new Files();
        file.setFileId(IPrimaryKey.DEFAULT.getSequence("LMS_FILES"));
        file.setFilename(filename);
        file.setFilepath(filepath);
        file.setFilesize(filesize);
        file.setFilenameext(filenameext.replace(".", ""));
        file.setSrcfilename(srcfilename);
        file.setSrcobjectId(srcobjectId);
        file.setDomainId(9002L);
        file.setGkey(UUID.randomUUID().toString());
        file.setType(type);
        file.setDeleted(0);
        file.setCreatedate(new Date());
        file.setSubtype(subtype);
        this.filesPlusDao.insert((BaseEntity)file);
        return file;
    }

    @Override
    public List<FilesVO> getVOList(@NotNull Long srcobjectId, @NotNull Integer type) {
        FilesQuery filesQuery = new FilesQuery();
        filesQuery.setSrcobjectId(srcobjectId);
        filesQuery.setType(type);
        filesQuery.setDeleted(0);
        filesQuery.getPage().setSortColumns("CREATEDATE DESC");
        List filesList = this.filesPlusDao.findList(filesQuery);
        if (filesList == null || filesList.size() == 0) {
            return new ArrayList<FilesVO>();
        }
        ArrayList<FilesVO> filesVOList = new ArrayList<FilesVO>();
        for (Files files : filesList) {
            FilesVO filesVO = (FilesVO)ConvertUtil.convert((Object)files, FilesVO.class);
            String filePath = CorePathUtil.getFilePath(files.getFilepath(), files.getFilename());
            filesVO.setFilePath(filePath);
            filesVOList.add(filesVO);
        }
        return filesVOList;
    }

    @Override
    public List<FilesVO> findVOList(@NotNull Long srcobjectId, @NotNull Integer type) {
        FilesQuery filesQuery = new FilesQuery();
        filesQuery.setSrcobjectId(srcobjectId);
        filesQuery.setType(type);
        filesQuery.setDeleted(0);
        filesQuery.setColumns("FILE_ID");
        filesQuery.getPage().setSortColumns("CREATEDATE DESC");
        List filesList = this.filesPlusDao.findList(filesQuery);
        if (filesList == null || filesList.size() == 0) {
            return new ArrayList<FilesVO>();
        }
        return this.findVOsByIds(IdUtil.getIds((List)filesList, e -> e.getFileId()), FilesVO.class);
    }

    @Override
    public int deleteBySidAndSubtype(@NotNull Long srcobjectId, @NotNull Integer subtype) {
        return this.filesPlusDao.deleteBySidAndSubtype(srcobjectId, subtype);
    }

    @Override
    public void validBySignAnddownloadByFileId(Long fileId, HttpServletResponse response, Long timestamp, Long userId, String sign) throws Exception {
        if (!SignUtil.validFileDownloadSign(userId, timestamp, sign)) {
            ExceptionUtil.handle((IRespStatusEnum)ResponseStatusEnum.UNAUTHORIZED_ERROR);
        }
        Files files = (Files)this.findById(fileId);
        DownloadFileUtil.openResourceFileStream((String)(files.getFilepath() + "/" + files.getFilename()), (HttpServletResponse)response);
    }

    @Override
    public FilesProVO upload(MultipartFile file, Integer filetype) throws Exception {
        FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByIndex(filetype);
        if (fileTypeEnum == null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.NO_FILETYPEENUM);
        }
        UploadFile uploadFile = UploadFileDBUtil.upload(file, "files", fileTypeEnum);
        return this.getVOById(uploadFile.getFileId(), FilesProVO.class);
    }

    @Override
    public Paging<FilesProVO> getMngVOList(FilesQueryBO filesQueryBO) {
        FilesQuery query = (FilesQuery)ConvertUtil.convert((Object)((Object)filesQueryBO), FilesQuery.class);
        query.getPage().setSortColumns("f.CREATEDATE DESC");
        Paging filesVOPaging = this.filesPlusDao.findPaging(query, FilesProVO.class);
        return filesVOPaging;
    }

    public <VO> VO getVOById(Long filesId, Class<VO> clazz) {
        Files files = (Files)this.findById(filesId);
        Object vo = ConvertUtil.convert((Object)files, clazz);
        if (clazz.equals(FilesVO.class)) {
            String filePath = CorePathUtil.getFilePath(files.getFilepath(), files.getFilename());
            ((FilesVO)vo).setFilePath(filePath);
        }
        return (VO)vo;
    }
}

