/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.messageq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.DateUtil;
import java.util.Date;
import java.util.UUID;

public class MessageQ {
    private String topic;
    private String gkey;
    private String groupId;
    private Long id;
    private String action;
    private Date sendTime;
    private Object data;

    public MessageQ() {
    }

    public MessageQ(String topic, Long id, String action) {
        this.gkey = UUID.randomUUID().toString();
        this.topic = topic;
        this.id = id;
        this.action = action;
        this.sendTime = new Date();
    }

    public MessageQ(String topic, Long id, String action, Object data) {
        this.gkey = UUID.randomUUID().toString();
        this.topic = topic;
        this.id = id;
        this.action = action;
        this.data = data;
        this.sendTime = new Date();
    }

    public MessageQ(String gkey, String topic, Long id, String action, Object data, Date sendTime) {
        this.gkey = gkey;
        this.topic = topic;
        this.id = id;
        this.action = action;
        this.data = data;
        this.sendTime = sendTime == null ? new Date() : sendTime;
    }

    public MessageQ(String gkey, String topic, String groupId, Long id, String action, Object data, Date sendTime) {
        this.gkey = gkey;
        this.topic = topic;
        this.groupId = groupId;
        this.id = id;
        this.action = action;
        this.data = data;
        this.sendTime = sendTime == null ? new Date() : sendTime;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public String getGkey() {
        return this.gkey;
    }

    public void setGkey(String gkey) {
        this.gkey = gkey;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String toJson(String topicPrefix, String topicSuffix) {
        JSONObject jObj = new JSONObject();
        jObj.put("topic", (Object)(topicPrefix + this.topic + topicSuffix));
        jObj.put("groupId", (Object)this.groupId);
        jObj.put("gkey", (Object)this.gkey);
        jObj.put("id", (Object)this.id);
        jObj.put("action", (Object)this.action);
        jObj.put("data", this.data);
        jObj.put("sendTime", (Object)DateUtil.getFullString((Date)this.sendTime));
        return jObj.toString();
    }

    public static MessageQ analysisBody(String body, String topicSuffix, String topicPrefix) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            String action = jsonObject.getString("action");
            String realtopic = jsonObject.getString("topic");
            String gkey = jsonObject.getString("gkey");
            String topic = realtopic.replace("retry_", "").replace("_" + action, "").replace(topicSuffix, "").replace(topicPrefix, "");
            String id = jsonObject.getString("id");
            Object data = jsonObject.get((Object)"data");
            String strDate = jsonObject.getString("date");
            Date date = null;
            if (null != strDate) {
                date = DateUtil.toDate((String)strDate);
            }
            String groupId = "";
            Object oGroupId = jsonObject.get((Object)"groupId");
            if (null != oGroupId) {
                groupId = String.valueOf(oGroupId);
            }
            return new MessageQ(gkey, topic, groupId, Long.valueOf(id), action, data, date);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

