/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.messageq.util;

import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.config.MessageQConfig;
import com.peak.prd.enums.AppconfigEnum;
import com.peak.prd.messageq.MessageQ;
import com.peak.prd.mq.faillog.service.IFaillogPlusService;
import com.peak.prd.mq.sendlog.service.ISendlogPlusService;
import com.peak.prd.sys.mqdefine.model.SysMqdefine;
import com.peak.prd.sys.mqdefine.service.ISysMqdefinePlusService;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Date;

public class MessageQHelper {
    public static String topicSuffix = "";
    public static String topicPrefix = "";
    public static String mqProducerUtil = "";
    public static String mqProducerUtilMethod = "";
    public static final int defaultMaxFailCount = 5;
    public static MessageQConfig messageQConfig = (MessageQConfig)SpringUtil.getBean((String)"messageQConfig");

    public static void send(MessageQ msgQ) throws RuntimeException {
        MessageQHelper.mqPrepare(msgQ);
    }

    public static void send(String topic, Long Id, String action, Object data) throws RuntimeException {
        MessageQ msgQ = new MessageQ(topic, Id, action, data);
        MessageQHelper.send(msgQ);
    }

    private static void mqPrepare(MessageQ msgQ) throws RuntimeException {
        if (msgQ == null) {
            MessageQHelper.saveSendLog("", "", "", "", null, 0, "\u6240\u53d1\u9001\u6d88\u606fmsgQ\u5bf9\u8c61\u4e3a\u7a7a", "");
            return;
        }
        String msg = "";
        String sendRecordId = "";
        try {
            ISysMqdefinePlusService sysMqdefinePlusService = (ISysMqdefinePlusService)SpringUtil.getBean(ISysMqdefinePlusService.class);
            SysMqdefine sysMqdefineTopic = sysMqdefinePlusService.findByMqvalue(0L, 1, msgQ.getTopic());
            if (sysMqdefineTopic == null) {
                return;
            }
            if (sysMqdefineTopic.getStatus() == 0) {
                return;
            }
            SysMqdefine sysMqdefineAction = sysMqdefinePlusService.findByMqvalue(sysMqdefineTopic.getMqdefineId(), 2, msgQ.getAction());
            if (sysMqdefineAction == null) {
                return;
            }
            if (sysMqdefineAction.getStatus() == 0) {
                return;
            }
            msg = msgQ.toJson(topicPrefix, topicSuffix);
            String topic = topicPrefix + msgQ.getTopic() + "_" + msgQ.getAction() + topicSuffix;
            sendRecordId = MessageQHelper.msgPrepare(topic, msg, mqProducerUtil, mqProducerUtilMethod);
        }
        catch (Exception ex) {
            MessageQHelper.saveSendLog(msgQ.getTopic(), msgQ.getAction(), msgQ.getGkey(), msg, msgQ.getSendTime(), 0, "\u53d1\u9001\u6d88\u606f\u5931\u8d25: " + ex.getMessage(), sendRecordId);
            throw new RuntimeException(ex);
        }
        MessageQHelper.saveSendLog(msgQ.getTopic(), msgQ.getAction(), msgQ.getGkey(), msg, msgQ.getSendTime(), 1, "", sendRecordId);
    }

    private static String msgPrepare(String topic, String msg, String producerUtil, String producerUtilMethod) throws Exception {
        Class<?> utilClz = Class.forName(producerUtil);
        Object utilObj = utilClz.newInstance();
        Method utilMethod = utilClz.getMethod(producerUtilMethod, String.class, String.class);
        Object resultObj = utilMethod.invoke(utilObj, topic, msg);
        String sendResult = resultObj.toString();
        if (!"1".equals(sendResult) && !sendResult.startsWith("1_")) {
            throw new Exception(sendResult);
        }
        return sendResult;
    }

    private static void saveSendLog(String topic, String action, String gkey, String msgbody, Date sendTime, Integer status, String failMsg, String sendRecordId) {
        try {
            if ("1".equals(AppconfigUtil.getIsMqSaveSendLog().toString())) {
                ISendlogPlusService sendlogPlusService = (ISendlogPlusService)SpringUtil.getBean(ISendlogPlusService.class);
                sendlogPlusService.saveSendLog(topic, action, gkey, msgbody, sendTime, mqProducerUtil, mqProducerUtilMethod + "_" + sendRecordId, status, failMsg);
                if (status == 0) {
                    MessageQHelper.saveFaillog(gkey, topic, action, msgbody, failMsg, "", 1, sendTime, sendTime, "", 0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void saveFaillog(String gkey, String topic, String action, String messageBody, String failMsg, String handlerName, Integer handlerEnable, Date beginDate, Date endDate, String groupId, Integer errorStep) {
        try {
            int maxFailCount = StringUtil.isNullorEmptyStr((String)AppconfigUtil.getValueByConfigkey(AppconfigEnum.KEY_MESSAGEHANDMAXFAILCOUNT.getValue())) ? 5 : Integer.valueOf(AppconfigUtil.getValueByConfigkey(AppconfigEnum.KEY_MESSAGEHANDMAXFAILCOUNT.getValue()));
            IFaillogPlusService faillogPlusService = (IFaillogPlusService)SpringUtil.getBean(IFaillogPlusService.class);
            faillogPlusService.txInsert(gkey, topic, action, messageBody, failMsg, handlerName, handlerEnable, beginDate, endDate, groupId, errorStep, maxFailCount);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static {
        topicSuffix = messageQConfig.getCustomTopicSuffix();
        topicPrefix = messageQConfig.getCustomTopicPrefix();
        mqProducerUtil = StringUtil.isNullorEmptyStr((String)messageQConfig.getCustomProducerUtil()) ? "com.peak.prd.messageq.util.kafka.KafkaProducerUtil" : messageQConfig.getCustomProducerUtil();
        mqProducerUtilMethod = StringUtil.isNullorEmptyStr((String)messageQConfig.getCustomProducerUtilMethod()) ? "sendMessage" : messageQConfig.getCustomProducerUtilMethod();
    }
}

