/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.messageq.util.kafka;

import com.alibaba.fastjson.JSONObject;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.config.KafkaConfig;
import com.peak.prd.messageq.MessageQ;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerUtil {
    private static Producer<String, String> producer = null;
    public static Properties props = new Properties();

    public static void setProducer(Producer<String, String> producer) {
        KafkaProducerUtil.producer = producer;
    }

    public static void reBulidProducer() {
        if (producer == null) {
            try {
                producer = new KafkaProducer(props);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static String sendMessage(ProducerRecord message) {
        String ret = "";
        try {
            if (producer == null) {
                KafkaProducerUtil.reBulidProducer();
            }
            producer.send(message);
            ret = "1";
        }
        catch (Exception e) {
            e.printStackTrace();
            producer = null;
            ret = "" + e.getMessage();
        }
        finally {
            producer.flush();
        }
        return ret;
    }

    public static String sendMessage(String topic, String value) {
        return KafkaProducerUtil.sendMessage(new ProducerRecord(topic, (Object)value));
    }

    private static String sendMessage(String topic, String key, String value) {
        return KafkaProducerUtil.sendMessage(new ProducerRecord(topic, (Object)key, (Object)value));
    }

    private static String sendMessage(String topic, Integer partition, String key, String value) {
        return KafkaProducerUtil.sendMessage(new ProducerRecord(topic, partition, (Object)key, (Object)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        KafkaProducer producer = null;
        Properties props = new Properties();
        props.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=admin password=admin ;");
        props.put("security.protocol", "SASL_PLAINTEXT");
        props.put("sasl.mechanism", "PLAIN");
        props.put("bootstrap.servers", "39.103.224.3:2909");
        props.put("acks", "all");
        props.put("retries", "0");
        props.put("batch.size", "16384");
        props.put("linger.ms", "1");
        props.put("buffer.memory", "33554432");
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        Object a = null;
        try {
            producer = new KafkaProducer(props);
            ArrayList<Long> issueCertUserList = new ArrayList<Long>();
            issueCertUserList.add(1L);
            issueCertUserList.add(2L);
            JSONObject jObj = new JSONObject();
            jObj.put("certUserList", issueCertUserList);
            MessageQ msgQ = new MessageQ("cert", 111L, "issue", jObj);
            String msg = msgQ.toJson("", "");
            String topic = msgQ.getTopic() + "_" + msgQ.getAction();
            String ret = "";
            try {
                ProducerRecord message = new ProducerRecord(topic, (Object)msg);
                producer.send(message);
                ret = "1";
            }
            catch (Exception e) {
                e.printStackTrace();
                producer = null;
                ret = "" + e.getMessage();
            }
            finally {
                producer.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        KafkaConfig kafkaConfig = (KafkaConfig)SpringUtil.getBean((String)"kafkaConfig");
        String authLoginConfig = kafkaConfig.getSecurityAuthLoginConfig();
        if (!StringUtil.isNullorEmptyStr((String)authLoginConfig)) {
            System.setProperty("java.security.auth.login.config", kafkaConfig.getSecurityAuthLoginConfig());
            if (!StringUtil.isNullorEmptyStr((String)kafkaConfig.getProducerSaslJaasConfig())) {
                props.put("sasl.jaas.config", kafkaConfig.getProducerSaslJaasConfig());
            }
            props.put("security.protocol", kafkaConfig.getProducerSecurityProtocol());
            props.put("sasl.mechanism", kafkaConfig.getProducerSaslMechanism());
        }
        props.put("bootstrap.servers", kafkaConfig.getBootstrapServers());
        props.put("acks", kafkaConfig.getProducerAcks());
        props.put("retries", kafkaConfig.getProducerRetries());
        props.put("batch.size", kafkaConfig.getProducerBatchSize());
        props.put("linger.ms", kafkaConfig.getProducerLingerMs());
        props.put("buffer.memory", kafkaConfig.getProducerBufferMemory());
        props.put("key.serializer", kafkaConfig.getProducerKeyDeserializer());
        props.put("value.serializer", kafkaConfig.getProducerValueDeserializer());
    }
}

