/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.messageq.util.rocketmq;

import com.peak.common.util.SpringUtil;
import com.peak.prd.config.RocketMQConfig;
import java.nio.charset.StandardCharsets;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQProducerUtil {
    private static final Logger log = LoggerFactory.getLogger(RocketMQProducerUtil.class);
    private static DefaultMQProducer producer = null;

    public static void reBulidProducer() {
        if (producer == null) {
            try {
                RocketMQConfig rocketMQConfig = (RocketMQConfig)SpringUtil.getBean((String)"rocketMQConfig");
                producer = new DefaultMQProducer(rocketMQConfig.getProducerGroup());
                producer.setNamesrvAddr(rocketMQConfig.getNamesrvAddr());
                producer.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendMessage(String topic, String value) {
        String[] ret = new String[]{"1"};
        try {
            if (producer == null) {
                RocketMQProducerUtil.reBulidProducer();
            }
            Message message = new Message(topic, "TagA", (value + "").getBytes(StandardCharsets.UTF_8));
            log.info("MQ\u540c\u6b65\u53d1\u9001:{},\u6d88\u606f\u4f53:{}", (Object)topic, (Object)value);
            producer.sendOneway(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret[0] = "0";
        }
        finally {
            producer.shutdown();
            producer = null;
        }
        return ret[0];
    }

    static {
        RocketMQProducerUtil.reBulidProducer();
    }
}

