/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.mq.faillog.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.DateUtil;
import com.peak.common.util.RedisStreamService;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.config.MessageQConfig;
import com.peak.prd.enums.ServerNameEnum;
import com.peak.prd.messageq.MessageQ;
import com.peak.prd.messageq.handler.MessageQBaseHandler;
import com.peak.prd.messageq.util.MessageQHelper;
import com.peak.prd.mq.faillog.bo.FaillogQueryBO;
import com.peak.prd.mq.faillog.dao.IFaillogPlusDao;
import com.peak.prd.mq.faillog.model.Faillog;
import com.peak.prd.mq.faillog.service.IFaillogPlusService;
import com.peak.prd.mq.faillog.vo.FaillogMngVO;
import com.peak.prd.mq.faillog.vo.FaillogQuery;
import com.peak.prd.mq.sendlog.model.Sendlog;
import com.peak.prd.mq.sendlog.service.ISendlogPlusService;
import com.peak.prd.remote.ai.controller.AiServiceController;
import com.peak.prd.remote.community.controller.CommunityServiceController;
import com.peak.prd.remote.exam.controller.ExamServiceController;
import com.peak.prd.remote.rescom.controller.RescomServiceController;
import com.peak.prd.remote.spz.controller.SpecialzoneServiceController;
import com.peak.prd.remote.tms.controller.TmsServiceController;
import com.peak.prd.remote.trainproject.controller.TrainprojectServiceController;
import com.peak.prd.remote.transform.controller.TransformServiceController;
import com.peak.prd.sys.mqhandler.model.SysMqhandler;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.stereotype.Service;

@Service
public class FaillogPlusService
extends PrdBaseService<Faillog, Long, FaillogQuery>
implements IFaillogPlusService {
    private IFaillogPlusDao faillogPlusDao;
    @Resource
    private ISendlogPlusService sendlogPlusService;
    @Resource
    TmsServiceController tmsServiceController;
    @Resource
    TrainprojectServiceController trainprojectServiceController;
    @Resource
    CommunityServiceController communityServiceController;
    @Resource
    AiServiceController aiServiceController;
    @Resource
    RescomServiceController rescomServiceController;
    @Resource
    ExamServiceController examServiceController;
    @Resource
    SpecialzoneServiceController specialzoneServiceController;
    @Resource
    TransformServiceController transformServiceController;
    @Resource
    ISysMqhandlerPlusService sysMqhandlerPlusService;
    @Autowired
    private static RedisStreamService redisStreamService;
    public static String topicSuffix;
    public static String topicPrefix;
    public static String mqServer;
    private static final int defaultMaxFailCount = 5;

    public void setFaillogPlusDao(IFaillogPlusDao dao) {
        this.faillogPlusDao = dao;
    }

    public IFaillogPlusDao getFaillogPlusDao() {
        return this.faillogPlusDao;
    }

    public IEntityDao<Faillog, Long, FaillogQuery> getEntityDao() {
        return this.faillogPlusDao;
    }

    @Override
    public int txInsert(String gkey, String topic, String action, String msgBody, String failMsg, String handlerName, Integer handlerEnable, Date beginDate, Date endDate, String groupId, Integer errorStep, Integer maxFailCount) throws SQLException {
        int errornum = 1;
        this.faillogPlusDao.deleteByGkeyGroup(gkey, groupId);
        Date now = new Date();
        Faillog faillog = new Faillog();
        faillog.setFaillogId(IPrimaryKey.DEFAULT.getSequence("MQ_FAILLOG"));
        faillog.setGkey(gkey);
        faillog.setTopic(topic);
        faillog.setAction(action);
        faillog.setBody(this.trim(msgBody, 3000));
        faillog.setFailmsg(failMsg);
        faillog.setHandlername(handlerName);
        faillog.setHandlerenable(handlerEnable);
        faillog.setBegindate(beginDate);
        faillog.setEnddate(endDate);
        faillog.setErrorstep(errorStep);
        faillog.setErrornum(errornum);
        faillog.setRetrycount(0);
        faillog.setRetrystatus(0);
        faillog.setGroupId(groupId);
        faillog.setCreatedate(now);
        if (!StringUtil.isNullorEmptyStr((String)groupId)) {
            Random random = new Random();
            int r = random.nextInt(5);
            int addMinute = 5 + r;
            faillog.setNextdeliverytime(DateUtil.minuteAddNum((Date)now, (Integer)addMinute));
        }
        this.insert((BaseEntity)faillog);
        return errornum;
    }

    @Override
    public Faillog getFaillogByGkey(String gkey) {
        FaillogQuery query = new FaillogQuery();
        query.setGkey(gkey);
        List faillogList = this.findAll(query);
        if (faillogList != null && faillogList.size() > 0) {
            return (Faillog)faillogList.get(0);
        }
        return null;
    }

    @Override
    public int deleteByGkeyGroup(String gkey, String groupId) {
        return this.faillogPlusDao.deleteByGkeyGroup(gkey, groupId);
    }

    private Faillog getFaillogByGkeyAndStep(String gkey, String groupId, int errorStep) {
        FaillogQuery query = new FaillogQuery();
        query.setGkey(gkey);
        query.setGroupId(groupId);
        query.setErrorstep(errorStep);
        List faillogList = this.faillogPlusDao.findList(query, "getByGkeyGroupErrorstep");
        if (faillogList != null && faillogList.size() > 0) {
            return (Faillog)faillogList.get(0);
        }
        return null;
    }

    @Override
    public List<Faillog> getRetryList(@NotNull Date beginTime, @NotNull Date endTime, @NotNull int maxErrornum) {
        return this.faillogPlusDao.getRetryList(beginTime, endTime, maxErrornum);
    }

    @Override
    public void archiveFaillog() {
        Date archiveDate = DateUtil.minus((Date)new Date(), (double)AppconfigUtil.getMessageQLogReserveDays().intValue());
        this.faillogPlusDao.archiveFaillog(archiveDate);
        this.faillogPlusDao.deleteFaillog(archiveDate);
    }

    @Override
    public void reSendFailMessage(Long faillogId) throws Exception {
        Faillog faillog = (Faillog)this.getById(faillogId);
        if (faillog != null) {
            faillog.setRetrycount(faillog.getRetrycount() == null ? 1 : faillog.getRetrycount() + 1);
            faillog.setRetrystatus(1);
            this.faillogPlusDao.update(faillog);
            if (faillog.getErrorstep() == 0) {
                String msgBody = faillog.getBody();
                MessageQ messageQ = MessageQ.analysisBody(msgBody, topicSuffix, topicPrefix);
                if (null != messageQ) {
                    MessageQHelper.send(messageQ);
                    faillog.setRetrystatus(2);
                    faillog.setFailmsg("\u6d88\u606f\u91cd\u65b0\u53d1\u9001\u6210\u529f");
                } else {
                    faillog.setRetrystatus(0);
                    faillog.setFailmsg("\u6d88\u606f\u91cd\u65b0\u53d1\u9001\u5931\u8d25,\u6d88\u606f\u4f53\u5185\u5bb9\u65e0\u6cd5\u89e3\u6790\u6210MessageQ");
                }
                this.faillogPlusDao.update(faillog);
            } else {
                try {
                    String handlerName = faillog.getHandlername();
                    if (handlerName.indexOf(":") > -1) {
                        String serverName = handlerName.split(":")[0];
                        if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_TMS.getValue().toLowerCase())) {
                            this.tmsServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_COMMUNITY.getValue().toLowerCase())) {
                            this.communityServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_AI.getValue().toLowerCase())) {
                            this.aiServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_CORE.getValue().toLowerCase())) {
                            this.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_RESCOM.getValue().toLowerCase())) {
                            this.rescomServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_TP.getValue().toLowerCase())) {
                            this.trainprojectServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_EXAM.getValue().toLowerCase())) {
                            this.examServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_SPZ.getValue().toLowerCase())) {
                            this.specialzoneServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_TRANSFORM.getValue().toLowerCase())) {
                            this.transformServiceController.retryFailMessage(faillogId);
                        } else if (serverName.toLowerCase().equals(ServerNameEnum.SVR_NAME_TP.getValue().toLowerCase())) {
                            this.trainprojectServiceController.retryFailMessage(faillogId);
                        } else {
                            faillog.setRetrystatus(0);
                            this.faillogPlusDao.update(faillog);
                        }
                    }
                }
                catch (Exception e) {
                    faillog.setRetrystatus(0);
                    this.faillogPlusDao.update(faillog);
                }
            }
        }
    }

    @Override
    public void reprocessFailMessage(List<Long> faillogIds) throws Exception {
        for (Long faillogId : faillogIds) {
            this.reSendFailMessage(faillogId);
        }
    }

    @Override
    public Paging<FaillogMngVO> getMngVOList(FaillogQueryBO faillogQueryBO) {
        FaillogQuery query = new FaillogQuery(faillogQueryBO.getPageNumber(), faillogQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)faillogQueryBO), (Object)query);
        query.getPage().setSortColumns("mqfl.CREATEDATE DESC");
        Paging faillogMngVOPaging = this.faillogPlusDao.findPaging(query, FaillogMngVO.class);
        List faillogMngVOList = faillogMngVOPaging.getList();
        if (faillogMngVOList == null || faillogMngVOList.isEmpty()) {
            return faillogMngVOPaging;
        }
        for (FaillogMngVO faillogMngVO : faillogMngVOList) {
            SysMqhandler sysMqhandler;
            String handLerClassName = faillogMngVO.getHandlername();
            if (faillogMngVO.getHandlername().indexOf(":") > -1) {
                handLerClassName = faillogMngVO.getHandlername().split(":")[1];
            }
            if ((sysMqhandler = this.sysMqhandlerPlusService.findByClassname(handLerClassName)) != null) {
                faillogMngVO.setConsumername(sysMqhandler.getName());
            }
            if (faillogMngVO.getErrorstep() == 0) {
                faillogMngVO.setSendstatus(0);
                continue;
            }
            faillogMngVO.setSendstatus(1);
        }
        return faillogMngVOPaging;
    }

    @Override
    public void updateRetryStatus(String gkey, String handlerName, Integer retryStatus) {
        this.faillogPlusDao.updateRetryStatus(gkey, handlerName, retryStatus);
    }

    @Override
    public void retryFailMessage(Long faillogId) throws Exception {
        Sendlog sendlog;
        Faillog faillog = (Faillog)this.getById(faillogId);
        if (faillog != null && (sendlog = this.sendlogPlusService.getByGkey(faillog.getGkey())) != null) {
            MapRecord mapRecord;
            String recordId;
            String sendTopic = topicPrefix + sendlog.getTopic() + "_" + sendlog.getAction() + topicSuffix;
            String msgBody = sendlog.getBody();
            MessageQ messageQ = MessageQ.analysisBody(msgBody, topicSuffix, topicPrefix);
            if (null == messageQ && "redis".equals(mqServer) && StringUtil.isNullorEmptyStr((String)(recordId = sendlog.getSendutilmethod().replace("sendMessage_1_", ""))) && (mapRecord = redisStreamService.getRecord(sendTopic, recordId)) != null) {
                String messagebody = (String)((Map)mapRecord.getValue()).get("payload");
                messagebody = messagebody.substring(messagebody.indexOf("{"));
                messageQ = this.getMessageQ(messagebody);
            }
            if (messageQ != null) {
                String handlerName = faillog.getHandlername();
                if (faillog.getHandlername().indexOf(":") > -1) {
                    handlerName = faillog.getHandlername().split(":")[1];
                }
                try {
                    handlerName = StringUtil.lowerFirstLetter((String)handlerName);
                    MessageQBaseHandler messageHandler = (MessageQBaseHandler)SpringUtil.getBean((String)handlerName);
                    messageHandler.handle(messageQ);
                    faillog.setRetrystatus(2);
                    this.faillogPlusDao.update(faillog);
                }
                catch (Exception e) {
                    String failMsg = this.trim(e.getMessage(), 2000);
                    if (StringUtil.isNullorEmptyStr((String)failMsg)) {
                        failMsg = this.getStackTraceString(e, 2000);
                    }
                    faillog.setFailmsg("\u6d88\u606f\u5904\u7406\u51fa\u9519:" + failMsg);
                    faillog.setRetrystatus(0);
                    this.faillogPlusDao.update(faillog);
                }
            }
        }
    }

    @Override
    public void deleteSuccessLog(Date beginDate, Date endDate) {
        this.faillogPlusDao.deleteSuccessLog(beginDate, endDate);
    }

    private String trim(String str, int maxLength) {
        int utf8_max_length = maxLength / 3;
        if (str == null || str.length() <= utf8_max_length) {
            return str;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length <= maxLength) {
            return str;
        }
        return new String(bytes, 0, utf8_max_length * 3, StandardCharsets.UTF_8);
    }

    private MessageQ getMessageQ(String message) {
        if (message.startsWith("{{")) {
            message = message.substring(1);
        }
        MessageQ messageQ = MessageQ.analysisBody(message, topicSuffix, topicPrefix);
        return messageQ;
    }

    /*
     * Exception decompiling
     */
    private String getStackTraceString(Exception ex, int maxLength) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        topicSuffix = "";
        topicPrefix = "";
        mqServer = "";
        MessageQConfig messageQConfig = (MessageQConfig)SpringUtil.getBean((String)"messageQConfig");
        topicSuffix = messageQConfig.getCustomTopicSuffix();
        topicPrefix = messageQConfig.getCustomTopicPrefix();
        mqServer = messageQConfig.getServer();
    }
}

