/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.mq.sendlog.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.DateUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.RedisService;
import com.peak.common.util.RedisStreamService;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.config.MessageQConfig;
import com.peak.prd.messageq.MessageQ;
import com.peak.prd.messageq.util.MessageQHelper;
import com.peak.prd.mq.faillog.service.IFaillogPlusService;
import com.peak.prd.mq.sendlog.bo.MqSendFaillogQueryBO;
import com.peak.prd.mq.sendlog.bo.MqSendlogDeleteBO;
import com.peak.prd.mq.sendlog.bo.MqSendlogQueryBO;
import com.peak.prd.mq.sendlog.dao.ISendlogPlusDao;
import com.peak.prd.mq.sendlog.model.Sendlog;
import com.peak.prd.mq.sendlog.service.ISendlogPlusService;
import com.peak.prd.mq.sendlog.vo.MqSendlogMngVO;
import com.peak.prd.mq.sendlog.vo.SendlogQuery;
import com.peak.prd.mq.successlog.service.ISuccesslogPlusService;
import com.peak.prd.sys.mqdefine.service.ISysMqdefinePlusService;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineVO;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class SendlogPlusService
extends PrdBaseService<Sendlog, Long, SendlogQuery>
implements ISendlogPlusService {
    private static final Logger log = LoggerFactory.getLogger(SendlogPlusService.class);
    private ISendlogPlusDao sendlogPlusDao;
    @Resource
    private RedisService redisService;
    @Resource
    private RedisStreamService redisStreamService;
    @Resource
    private ISuccesslogPlusService successlogPlusService;
    @Resource
    private ISysMqdefinePlusService sysMqdefinePlusService;
    @Lazy
    @Resource
    private IFaillogPlusService faillogPlusService;
    public static String MQ_TOPICNAMELSIT = "MQ_TOPICNAMELSIT";
    public static String topicSuffix = "";
    public static String topicPrefix = "";
    public static final int defaultMaxFailCount = 5;

    public void setSendlogPlusDao(ISendlogPlusDao dao) {
        this.sendlogPlusDao = dao;
    }

    public ISendlogPlusDao getSendlogPlusDao() {
        return this.sendlogPlusDao;
    }

    public IEntityDao<Sendlog, Long, SendlogQuery> getEntityDao() {
        return this.sendlogPlusDao;
    }

    @Override
    public int saveSendLog(String topic, String action, String gkey, String msgbody, Date sendTime, String producerUtil, String producerUtilMethod, Integer status, String failMsg) throws SQLException {
        Sendlog sendlog = new Sendlog();
        sendlog.setSendlogId(IPrimaryKey.DEFAULT.getSequence("MQ_SENDLOG"));
        sendlog.setTopic(topic);
        sendlog.setAction(action);
        sendlog.setGkey(gkey);
        sendlog.setBody(this.trim(msgbody, 3000));
        sendlog.setSenddate(new Date());
        sendlog.setSendutil(producerUtil);
        sendlog.setSendutilmethod(producerUtilMethod);
        sendlog.setSendstatus(status);
        sendlog.setFailmsg(failMsg);
        return this.insert((BaseEntity)sendlog);
    }

    @Override
    public Sendlog getLastSendlog(String topic, String action) {
        SendlogQuery sendlogQuery = new SendlogQuery(1, 1);
        sendlogQuery.setTopic(topic);
        sendlogQuery.setAction(action);
        sendlogQuery.getPage().setSortColumns("msl.SENDDATE desc");
        return (Sendlog)this.sendlogPlusDao.findOne(sendlogQuery);
    }

    @Override
    public Paging<MqSendlogMngVO> getMngVOList(@NotNull MqSendlogQueryBO sendlogQueryBO) {
        SendlogQuery sendlogQuery = new SendlogQuery(sendlogQueryBO.getPageNumber(), sendlogQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)sendlogQueryBO), (Object)sendlogQuery);
        sendlogQuery.getPage().setSortColumns("msl.SENDDATE desc");
        Paging searchlogMngVOPaging = this.getSendlogPlusDao().findPaging(sendlogQuery, "getList", MqSendlogMngVO.class);
        return searchlogMngVOPaging;
    }

    @Override
    public void resendFailMessage(@NotNull MqSendFaillogQueryBO sendFaillogQueryBO) {
        int loop = 0;
        int pagesize = 100;
        SendlogQuery query = new SendlogQuery(1, pagesize);
        query.setSendstatus(0);
        ConvertUtil.copyProperties((Object)((Object)sendFaillogQueryBO), (Object)query);
        query.getPage().setSortColumns("msl.SENDDATE");
        while (loop < 10000) {
            query.getPage().setPageNumber(++loop);
            Paging searchlogPaging = this.getSendlogPlusDao().findPaging(query);
            if (searchlogPaging == null || searchlogPaging.getList() == null || searchlogPaging.getList().size() <= 0) break;
            List sendlogList = searchlogPaging.getList();
            for (Sendlog sendlog : sendlogList) {
                MessageQ messageQ = MessageQ.analysisBody(sendlog.getBody(), topicSuffix, topicPrefix);
                MessageQHelper.send(messageQ);
            }
            List ids = IdUtil.getIds((List)sendlogList, e -> e.getSendlogId());
            this.getSendlogPlusDao().updateSendStatus(ids, 2);
            if (sendlogList.size() >= pagesize) continue;
            break;
        }
    }

    @Override
    public Paging<Sendlog> getClearPaging(@NotNull SendlogQuery sendlogQuery) {
        Paging searchlogPaging = this.getSendlogPlusDao().findPaging(sendlogQuery, "getClearList", Sendlog.class);
        return searchlogPaging;
    }

    @Override
    public String redisTopicMessageClear() {
        String topicNames;
        Integer reserveStreamCount = -1;
        int topicNameListLen = 0;
        int def_ReserveStreamCount = 100000;
        reserveStreamCount = AppconfigUtil.getRedisTopicReserveStreamCount();
        if (reserveStreamCount <= 0) {
            return "======\u4efb\u52a1\u5f00\u5173\u672a\u5f00\u542f======";
        }
        if (reserveStreamCount < def_ReserveStreamCount) {
            reserveStreamCount = def_ReserveStreamCount;
        }
        if (StringUtil.isNullorEmptyStr((String)(topicNames = AppconfigUtil.getValueByConfigkey(MQ_TOPICNAMELSIT, true)))) {
            return "======\u672a\u627e\u5230\u9700\u8981\u5904\u7406\u7684\u4e3b\u9898\u5217\u8868\u914d\u7f6e\u4fe1\u606f======";
        }
        List<SysMqdefineVO> topicMqdefineVOList = this.sysMqdefinePlusService.getPublicSysMqdefineVOList();
        if (!ListUtil.isNullorEmpty(topicMqdefineVOList)) {
            for (SysMqdefineVO topicMqdefineVO : topicMqdefineVOList) {
                List<SysMqdefineVO> actionMqdefineVOList = topicMqdefineVO.getChildren();
                if (ListUtil.isNullorEmpty(actionMqdefineVOList)) continue;
                String topic = topicMqdefineVO.getMqvalue();
                for (SysMqdefineVO actionMqdefineVO : actionMqdefineVOList) {
                    String action = actionMqdefineVO.getMqvalue();
                    String topicName = topic + "_" + action;
                    this.clearMessage(topicPrefix + topicName + topicSuffix, reserveStreamCount);
                    ++topicNameListLen;
                }
            }
        }
        return "=======\u5904\u7406\u4e3b\u9898\u6570\u91cf\uff1a" + topicNameListLen + "=======\u6bcf\u4e2a\u4e3b\u9898\u4fdd\u7559\u6700\u5927\u6d88\u606f\u6761\u6570: " + reserveStreamCount;
    }

    @Override
    public void deletelog() {
        Date reserveDate = DateUtil.minus((Date)new Date(), (double)AppconfigUtil.getMessageQLogReserveDays().intValue());
        this.sendlogPlusDao.deletelog(reserveDate);
    }

    @Override
    public Sendlog getByGkey(String gkey) {
        SendlogQuery query = new SendlogQuery(1, 1);
        query.setGkey(gkey);
        return (Sendlog)this.sendlogPlusDao.findOne(query);
    }

    @Override
    public void deleteSuccessLog(MqSendlogDeleteBO mqSendlogDeleteBO) {
        this.sendlogPlusDao.deleteSuccessLog(mqSendlogDeleteBO.getCreatedateBegin(), mqSendlogDeleteBO.getCreatedateEnd());
        this.successlogPlusService.deletelog(mqSendlogDeleteBO.getCreatedateBegin(), mqSendlogDeleteBO.getCreatedateEnd());
    }

    private void clearMessage(String topicName, int reserveStreamCount) {
        long streamCurrLen;
        int loopCount;
        log.info("===========clearMessage===========topicName: " + topicName);
        long startms = System.currentTimeMillis();
        long oldSize = this.redisStreamService.getStreamSize(topicName);
        String oldMem = this.safeRedisMemoryUsage(topicName);
        long run0 = System.currentTimeMillis();
        for (loopCount = 0; loopCount < 1000000 && (streamCurrLen = this.redisStreamService.getStreamSize(topicName).longValue()) > (long)reserveStreamCount; ++loopCount) {
            this.redisStreamService.trim(topicName, Math.max(streamCurrLen - 100L, (long)reserveStreamCount));
            if (System.currentTimeMillis() - run0 <= 20000L) continue;
            run0 = System.currentTimeMillis();
            log.info("redis stream [" + topicName + "][currSize:" + streamCurrLen + "] by trim");
        }
        long newSize = this.redisStreamService.getStreamSize(topicName);
        String newMem = this.safeRedisMemoryUsage(topicName);
        long spentms = System.currentTimeMillis() - startms;
        String msg = "redis stream [topicName:" + topicName + "][old-size:" + oldSize + "][new-size:" + newSize + "][old-memory:" + oldMem + "][new-memory:" + newMem + "][spent-ms:" + spentms + "][loop-count:" + loopCount + "]";
        log.info(msg);
    }

    private String safeRedisMemoryUsage(String topicName) {
        try {
            return this.redisService.redisMemoryUsage(this.redisService.getKey(topicName));
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    private String trim(String str, int maxLength) {
        int utf8_max_length = maxLength / 3;
        if (str == null || str.length() <= utf8_max_length) {
            return str;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length <= maxLength) {
            return str;
        }
        return new String(bytes, 0, utf8_max_length * 3, StandardCharsets.UTF_8);
    }

    static {
        MessageQConfig messageQConfig = (MessageQConfig)SpringUtil.getBean((String)"messageQConfig");
        topicSuffix = messageQConfig.getCustomTopicSuffix();
        topicPrefix = messageQConfig.getCustomTopicPrefix();
    }
}

