/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.mq.successlog.service.imple;

import com.peak.common.util.DateUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.jdbc.IPrimaryKey;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.mq.sendlog.vo.MqHandlelogMngVO;
import com.peak.prd.mq.successlog.dao.ISuccesslogPlusDao;
import com.peak.prd.mq.successlog.model.Successlog;
import com.peak.prd.mq.successlog.service.ISuccesslogPlusService;
import com.peak.prd.mq.successlog.vo.SuccesslogQuery;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Service;

@Service
public class SuccesslogPlusService
extends PrdBaseService<Successlog, Long, SuccesslogQuery>
implements ISuccesslogPlusService {
    private ISuccesslogPlusDao successlogPlusDao;

    public void setSuccesslogPlusDao(ISuccesslogPlusDao dao) {
        this.successlogPlusDao = dao;
    }

    public ISuccesslogPlusDao getSuccesslogPlusDao() {
        return this.successlogPlusDao;
    }

    public IEntityDao<Successlog, Long, SuccesslogQuery> getEntityDao() {
        return this.successlogPlusDao;
    }

    @Override
    public int insert(String gkey, String topic, String action, String msgBody, String handlerName, Integer handlerEnable, Date beginDate, Date endDate) throws SQLException {
        Date now = new Date();
        Successlog successlog = new Successlog();
        successlog.setSuccesslogId(IPrimaryKey.DEFAULT.getSequence("MQ_SUCCESSLOG"));
        successlog.setGkey(gkey);
        successlog.setTopic(topic);
        successlog.setAction(action);
        successlog.setBody(this.trim(msgBody, 3000));
        successlog.setHandlername(handlerName);
        successlog.setHandlerenable(handlerEnable);
        successlog.setBegindate(beginDate);
        successlog.setEnddate(endDate);
        successlog.setCreatedate(now);
        return this.insert((BaseEntity)successlog);
    }

    @Override
    public List<MqHandlelogMngVO> getHandleMngVOList(@NotNull String mqGkey) {
        return this.successlogPlusDao.getHandleMngVOList(mqGkey);
    }

    @Override
    public void deletelog() {
        Date reserveDate = DateUtil.minus((Date)new Date(), (double)AppconfigUtil.getMessageQLogReserveDays().intValue());
        this.successlogPlusDao.deletelog(reserveDate);
    }

    @Override
    public void deletelog(Date beginDate, Date endDate) {
        this.successlogPlusDao.deletelog(beginDate, endDate);
    }

    private String trim(String str, int maxLength) {
        int utf8_max_length = maxLength / 3;
        if (str == null || str.length() <= utf8_max_length) {
            return str;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length <= maxLength) {
            return str;
        }
        return new String(bytes, 0, utf8_max_length * 3, StandardCharsets.UTF_8);
    }
}

