/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.quartz.advise;

import com.peak.common.util.IdUtil;
import com.peak.prd.common.appdict.model.Appdict;
import com.peak.prd.common.appdict.util.AppdictUtil;
import com.peak.prd.quartz.INoLockJob;
import com.peak.prd.quartz.health.HealthJob;
import com.peak.prd.quartz.lock.JobLockUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ScheduledAspect {
    private static final Logger log = LoggerFactory.getLogger(ScheduledAspect.class);
    @Autowired
    private HealthJob healthJob;

    @Pointcut(value="@annotation(org.springframework.scheduling.annotation.Scheduled)")
    public void proxyAspect() {
    }

    @Around(value="proxyAspect()")
    public Object doInvoke(ProceedingJoinPoint pjp) throws Throwable {
        String methodName = pjp.getSignature().getDeclaringTypeName() + "." + pjp.getSignature().getName();
        Appdict appdict = AppdictUtil.getByCode(methodName.toLowerCase());
        if (appdict != null && appdict.getIsvalId() == 0) {
            return null;
        }
        Scheduled scheduledAnno = ((MethodSignature)pjp.getSignature()).getMethod().getAnnotation(Scheduled.class);
        String uuid = IdUtil.getGkey();
        long beginMs = System.currentTimeMillis();
        boolean isHealthJob = pjp.getTarget() instanceof HealthJob;
        boolean needLock = !(pjp.getTarget() instanceof INoLockJob);
        boolean locked = false;
        try {
            if (needLock && !(locked = JobLockUtil.lock((String)methodName))) {
                Object var11_10 = null;
                return var11_10;
            }
            if (!isHealthJob && (needLock || log.isDebugEnabled())) {
                log.info(methodName + "\u8fd0\u884c... " + uuid + "[needLock:" + needLock + "]");
            }
            Object o = pjp.proceed();
            long spentMs = System.currentTimeMillis() - beginMs;
            if (!isHealthJob && (needLock || log.isDebugEnabled())) {
                log.info(methodName + "\u6210\u529f\u5b8c\u6210\uff0c\u8017\u65f6" + spentMs + "ms " + uuid);
            }
            Object object = o;
            return object;
        }
        catch (Throwable e) {
            long spentMs = System.currentTimeMillis() - beginMs;
            log.error(methodName + "\u5f02\u5e38\uff0c\u8017\u65f6" + spentMs + "ms " + uuid, e);
            throw e;
        }
        finally {
            if (needLock && locked) {
                JobLockUtil.unlock((String)methodName);
            }
        }
    }
}

