/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.sys.feedback.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.common.util.UploadFileUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.model.UploadFile;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.base.util.ExceptionUtil;
import com.peak.prd.enums.CoreResponseStatusEnum;
import com.peak.prd.sys.feedback.bo.FeedbackBO;
import com.peak.prd.sys.feedback.bo.FeedbackHandleBO;
import com.peak.prd.sys.feedback.bo.FeedbackPicBO;
import com.peak.prd.sys.feedback.bo.FeedbackQueryBO;
import com.peak.prd.sys.feedback.dao.IFeedbackPlusDao;
import com.peak.prd.sys.feedback.model.Feedback;
import com.peak.prd.sys.feedback.service.IFeedbackPlusService;
import com.peak.prd.sys.feedback.vo.FeedbackDetailVO;
import com.peak.prd.sys.feedback.vo.FeedbackQuery;
import com.peak.prd.sys.feedback.vo.FeedbackVO;
import java.util.Arrays;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FeedbackPlusService
extends PrdBaseService<Feedback, Long, FeedbackQuery>
implements IFeedbackPlusService {
    @Resource
    private IFeedbackPlusDao feedbackPlusDao;

    public IEntityDao<Feedback, Long, FeedbackQuery> getEntityDao() {
        return this.feedbackPlusDao;
    }

    @Override
    public Long insert(Long userId, FeedbackBO feedbackBO) throws Exception {
        Feedback feedback = (Feedback)ConvertUtil.convert((Object)feedbackBO, Feedback.class);
        Long feedbackId = IdUtil.getSequence((String)"SYS_FEEDBACK");
        feedback.setFeedbackId(feedbackId);
        feedback.setStatus(0);
        feedback.setCreatorId(userId);
        feedback.setCreatedate(new Date());
        this.setPicpaths(feedbackBO, feedback);
        this.insert((BaseEntity)feedback);
        return feedbackId;
    }

    @Override
    public Integer updateStu(Long userId, FeedbackBO feedbackBO) throws Exception {
        Feedback feedback;
        if (feedbackBO.getFeedbackId() == null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_IDISNULL_ERROR);
        }
        if ((feedback = (Feedback)this.getById(feedbackBO.getFeedbackId())) == null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_NOT_EXIST_ERROR);
        }
        if (feedback.getCreatorId().longValue() != userId.longValue()) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_NOT_YOURS_ERROR);
        }
        return this.update(feedbackBO);
    }

    @Override
    public Integer update(FeedbackBO feedbackBO) throws Exception {
        Feedback feedback = (Feedback)ConvertUtil.convert((Object)feedbackBO, Feedback.class);
        this.setPicpaths(feedbackBO, feedback);
        return this.updateSelective(feedback);
    }

    @Override
    public FeedbackDetailVO getInfo(Long feedbackId) {
        FeedbackDetailVO feedbackDetailVO;
        Feedback feedback = (Feedback)this.getById(feedbackId);
        if (feedback == null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_NOT_EXIST_ERROR);
        }
        if ((feedbackDetailVO = (FeedbackDetailVO)ConvertUtil.convert((Object)feedback, FeedbackDetailVO.class)).getPicpaths() != null && feedbackDetailVO.getPicpaths().trim().length() > 0) {
            feedbackDetailVO.setPicpathList(Arrays.asList(feedbackDetailVO.getPicpaths().split(";")));
        }
        return feedbackDetailVO;
    }

    @Override
    public FeedbackDetailVO getStuInfo(Long userId, Long feedbackId) {
        FeedbackDetailVO feedbackDetailVO;
        Feedback feedback = (Feedback)this.getById(feedbackId);
        if (feedback == null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_NOT_EXIST_ERROR);
        }
        if (feedback.getCreatorId().longValue() != userId.longValue()) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_NOT_YOURS_ERROR);
        }
        if ((feedbackDetailVO = (FeedbackDetailVO)ConvertUtil.convert((Object)feedback, FeedbackDetailVO.class)).getPicpaths() != null && feedbackDetailVO.getPicpaths().trim().length() > 0) {
            feedbackDetailVO.setPicpathList(Arrays.asList(feedbackDetailVO.getPicpaths().split(";")));
        }
        return feedbackDetailVO;
    }

    @Override
    public Paging<FeedbackVO> getMngVOList(FeedbackQueryBO feedbackQueryBO) {
        FeedbackQuery feedbackQuery = new FeedbackQuery(feedbackQueryBO.getPageNumber(), feedbackQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)feedbackQueryBO), (Object)feedbackQuery);
        if (feedbackQueryBO.getStatus() == null || feedbackQueryBO.getStatus() == 2) {
            feedbackQuery.setStatus(null);
        }
        feedbackQuery.getPage().setSortColumns("syfb.CREATEDATE DESC");
        Paging feedbackVOPaging = this.feedbackPlusDao.findPaging(feedbackQuery, "getMngList", FeedbackVO.class);
        if (feedbackVOPaging.isListNullOrEmpty()) {
            return feedbackVOPaging;
        }
        UserCoreUtil.setUserVO(feedbackVOPaging.getList(), FeedbackVO::getCreatorId, FeedbackVO::setUserVO);
        for (FeedbackVO feedbackVO : feedbackVOPaging.getList()) {
            if (feedbackVO.getPicpaths() == null || feedbackVO.getPicpaths().trim().length() <= 0) continue;
            feedbackVO.setPicpathList(Arrays.asList(feedbackVO.getPicpaths().split(";")));
        }
        return feedbackVOPaging;
    }

    @Override
    public Integer handleFeedback(Long userId, FeedbackHandleBO feedbackHandleBO) {
        Feedback feedback = (Feedback)this.getById(feedbackHandleBO.getFeedbackId());
        if (feedback == null) {
            ExceptionUtil.handle((IRespStatusEnum)CoreResponseStatusEnum.FEEDBACK_NOT_EXIST_ERROR);
        }
        feedback = (Feedback)ConvertUtil.convert((Object)feedbackHandleBO, Feedback.class);
        feedback.setHandleuserId(userId);
        feedback.setHandledate(new Date());
        return this.updateSelective(feedback);
    }

    private void setPicpaths(FeedbackBO feedbackBO, Feedback feedback) throws Exception {
        if (ListUtil.notNullorEmpty(feedbackBO.getFeedbackPicBOList())) {
            String picpaths = new String();
            for (FeedbackPicBO feedbackPicBO : feedbackBO.getFeedbackPicBOList()) {
                UploadFile uploadFile = UploadFileUtil.upload((String)feedbackPicBO.getBase64codefile(), (String)feedbackPicBO.getFilename(), (String)"feedbackpic/");
                picpaths = picpaths + uploadFile.getFullpath() + ";";
            }
            feedback.setPicpaths(picpaths.substring(0, picpaths.length() - 1));
        } else {
            feedback.setPicpaths("");
        }
    }
}

