/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.sys.mqdefine.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.ListUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.sys.mqdefine.bo.SysMqdefineBO;
import com.peak.prd.sys.mqdefine.bo.SysMqdefineQueryBO;
import com.peak.prd.sys.mqdefine.dao.ISysMqdefinePlusDao;
import com.peak.prd.sys.mqdefine.model.SysMqdefine;
import com.peak.prd.sys.mqdefine.service.ISysMqdefinePlusService;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineMiniVO;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineMngVO;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineQuery;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineVO;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class SysMqdefinePlusService
extends PrdBaseService<SysMqdefine, Long, SysMqdefineQuery>
implements ISysMqdefinePlusService {
    @Resource
    private ISysMqdefinePlusDao sysMqdefinePlusDao;
    @Resource
    @Lazy
    private ISysMqhandlerPlusService sysMqhandlerPlusService;

    public IEntityDao<SysMqdefine, Long, SysMqdefineQuery> getEntityDao() {
        return this.sysMqdefinePlusDao;
    }

    @Override
    public Paging<SysMqdefineMngVO> getMngVOPage(SysMqdefineQueryBO sysMqdefineQueryBO) {
        SysMqdefineQuery query = new SysMqdefineQuery(sysMqdefineQueryBO.getPageNumber(), sysMqdefineQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)sysMqdefineQueryBO), (Object)query);
        query.getPage().setSortColumns("mqd.CREATEDATE DESC");
        Paging mqVOPaging = this.sysMqdefinePlusDao.findPaging(query, SysMqdefineMngVO.class);
        List sysMqdefineVOList = mqVOPaging.getList();
        if (sysMqdefineVOList == null || sysMqdefineVOList.isEmpty()) {
            return mqVOPaging;
        }
        for (SysMqdefineMngVO sysMqdefineMngVO : sysMqdefineVOList) {
            sysMqdefineMngVO.setHaschild(this.hasChildren(sysMqdefineMngVO.getMqdefineId()));
        }
        UserCoreUtil.setUserVO(sysMqdefineVOList, SysMqdefineMngVO::getCreatorId, SysMqdefineMngVO::setUserVO);
        return mqVOPaging;
    }

    @Override
    public List<SysMqdefineMngVO> getMngVOList(SysMqdefineQueryBO sysMqdefineQueryBO) {
        SysMqdefineQuery query = new SysMqdefineQuery();
        ConvertUtil.copyProperties((Object)((Object)sysMqdefineQueryBO), (Object)query);
        query.getPage().setPageNumber(1);
        query.getPage().setPageSize(5000);
        query.getPage().setSortColumns("mqd.CREATEDATE DESC");
        List sysMqdefineList = this.sysMqdefinePlusDao.findList(query);
        List sysMqdefineVOList = ConvertUtil.convert((List)sysMqdefineList, SysMqdefineMngVO.class);
        if (sysMqdefineVOList == null || sysMqdefineVOList.isEmpty()) {
            return sysMqdefineVOList;
        }
        for (SysMqdefineMngVO sysMqdefineMngVO : sysMqdefineVOList) {
            sysMqdefineMngVO.setHaschild(this.hasChildren(sysMqdefineMngVO.getMqdefineId()));
        }
        UserCoreUtil.setUserVO(sysMqdefineVOList, SysMqdefineMngVO::getCreatorId, SysMqdefineMngVO::setUserVO);
        return sysMqdefineVOList;
    }

    @Override
    public void insert(Long userId, SysMqdefineBO sysMqdefineBO) throws Exception {
        SysMqdefine sysMqdefine = (SysMqdefine)ConvertUtil.convert((Object)sysMqdefineBO, SysMqdefine.class);
        Long mqdefineId = IdUtil.getSequence((String)"SYS_MQDEFINE");
        sysMqdefine.setMqdefineId(mqdefineId);
        sysMqdefine.setCreatorId(userId);
        sysMqdefine.setCreatedate(new Date());
        sysMqdefine.setUpdatedate(sysMqdefine.getCreatedate());
        this.sysMqdefinePlusDao.insertSelective((BaseEntity)sysMqdefine);
    }

    @Override
    @ClearCache(value="#sysMqdefineBO.mqdefineId")
    public Integer update(SysMqdefineBO sysMqdefineBO) throws Exception {
        SysMqdefine oldSysMqdefine = (SysMqdefine)this.getById(sysMqdefineBO.getMqdefineId());
        if (oldSysMqdefine == null) {
            return 0;
        }
        SysMqdefine sysMqdefine = (SysMqdefine)ConvertUtil.convert((Object)oldSysMqdefine, SysMqdefine.class);
        ConvertUtil.copyProperties((Object)sysMqdefineBO, (Object)sysMqdefine);
        sysMqdefine.setUpdatedate(new Date());
        int ret = this.sysMqdefinePlusDao.update(sysMqdefine);
        if (sysMqdefine.getStatus() == 0) {
            if (sysMqdefine.getMqlevel() == 1) {
                this.enabledTopicMqdefine(sysMqdefine.getMqdefineId());
            }
            if (sysMqdefine.getMqlevel() == 2) {
                this.enabledActionMqdefine(sysMqdefine.getMqdefineId());
            }
        }
        return ret;
    }

    @Override
    @ClearCache(value="#mqdefineId")
    public void changeStatus(Long mqdefineId, Integer status) {
        SysMqdefine sysMqdefine = new SysMqdefine(mqdefineId);
        sysMqdefine.setStatus(status);
        sysMqdefine.setUpdatedate(new Date());
        this.updateSelective(sysMqdefine);
        if (status == 0) {
            SysMqdefine oldSysMqdefine = (SysMqdefine)this.getById(mqdefineId);
            if (oldSysMqdefine == null) {
                return;
            }
            if (oldSysMqdefine.getMqlevel() == 1) {
                this.enabledTopicMqdefine(oldSysMqdefine.getMqdefineId());
            }
            if (oldSysMqdefine.getMqlevel() == 2) {
                this.enabledActionMqdefine(oldSysMqdefine.getMqdefineId());
            }
        }
    }

    @Override
    @ClearCache(value="#mqdefineId")
    public Integer delete(Long mqdefineId) throws Exception {
        return this.deleteById(mqdefineId);
    }

    @Override
    @Cacheable
    public SysMqdefine findByMqvalue(Long parentId, Integer mqlevel, String mqvalue) throws Exception {
        return this.sysMqdefinePlusDao.getByMqvalue(parentId, mqlevel, mqvalue);
    }

    @Override
    public List<SysMqdefineVO> getPublicSysMqdefineVOList() {
        List<SysMqdefineVO> sysMqdefineVOList = this.getPublicSysMqdefineVOList(0L);
        if (sysMqdefineVOList == null || sysMqdefineVOList.isEmpty()) {
            return sysMqdefineVOList;
        }
        for (SysMqdefineVO sysMqdefineVO : sysMqdefineVOList) {
            sysMqdefineVO.setChildren(this.getPublicSysMqdefineVOList(sysMqdefineVO.getMqdefineId()));
        }
        return sysMqdefineVOList;
    }

    private List<SysMqdefineVO> getPublicSysMqdefineVOList(Long parentId) {
        SysMqdefineQuery query = new SysMqdefineQuery();
        query.setParentId(parentId);
        query.setStatus(1);
        query.getPage().setPageNumber(1);
        query.getPage().setPageSize(5000);
        query.getPage().setSortColumns("mqd.CREATEDATE DESC");
        List sysMqdefineList = this.sysMqdefinePlusDao.findList(query);
        List sysMqdefineVOList = ConvertUtil.convert((List)sysMqdefineList, SysMqdefineVO.class);
        if (sysMqdefineVOList == null || sysMqdefineVOList.isEmpty()) {
            return sysMqdefineVOList;
        }
        return sysMqdefineVOList;
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':' + #id")})
    public void clearCache(Long id) {
    }

    private int hasChildren(Long mqdefineId) {
        SysMqdefineQuery query = new SysMqdefineQuery();
        query.setParentId(mqdefineId);
        long count = this.sysMqdefinePlusDao.count(query);
        return count > 0L ? 1 : 0;
    }

    public <VO> VO getVOById(Long mqdefineId, Class<VO> clazz) {
        SysMqdefine topicMqdefine;
        SysMqdefine sysMqdefine = (SysMqdefine)this.findById(mqdefineId);
        if (sysMqdefine == null) {
            return null;
        }
        Object vo = ConvertUtil.convert((Object)sysMqdefine, clazz);
        if (clazz.equals(SysMqdefineMiniVO.class) && sysMqdefine.getMqlevel() == 2 && (topicMqdefine = (SysMqdefine)this.findById(sysMqdefine.getParentId())) != null) {
            ((SysMqdefineMiniVO)vo).setParentMqvalue(topicMqdefine.getMqvalue());
        }
        return (VO)vo;
    }

    private void enabledTopicMqdefine(Long topicMqdefineId) {
        SysMqdefine oldSysMqdefine = (SysMqdefine)this.getById(topicMqdefineId);
        if (oldSysMqdefine == null) {
            return;
        }
        SysMqdefineQuery query = new SysMqdefineQuery();
        query.setParentId(topicMqdefineId);
        query.setStatus(1);
        query.getPage().setPageNumber(1);
        query.getPage().setPageSize(5000);
        query.getPage().setSortColumns("mqd.CREATEDATE DESC");
        List sysMqdefineList = this.sysMqdefinePlusDao.findList(query);
        if (ListUtil.isNullorEmpty((List)sysMqdefineList)) {
            return;
        }
        List sysMqdefineIds = IdUtil.getIds((List)sysMqdefineList, e -> e.getMqdefineId());
        if (ListUtil.isNullorEmpty((List)sysMqdefineIds)) {
            return;
        }
        this.sysMqdefinePlusDao.enabledActionMqdefine(topicMqdefineId);
        this.sysMqhandlerPlusService.enabledHandler(sysMqdefineIds);
    }

    private void enabledActionMqdefine(Long actionMqdefineId) {
        SysMqdefine oldSysMqdefine = (SysMqdefine)this.getById(actionMqdefineId);
        if (oldSysMqdefine == null) {
            return;
        }
        ArrayList<Long> sysMqdefineIds = new ArrayList<Long>();
        sysMqdefineIds.add(actionMqdefineId);
        this.sysMqhandlerPlusService.enabledHandler(sysMqdefineIds);
    }
}

