/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.sys.mqhandler.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.RedisStreamService;
import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.appsecurity.user.util.UserCoreUtil;
import com.peak.prd.base.annotation.ClearCache;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appdict.model.Appdict;
import com.peak.prd.common.appdict.service.IAppdictPlusService;
import com.peak.prd.common.appdict.util.AppdictUtil;
import com.peak.prd.common.appdict.vo.AppdictVO;
import com.peak.prd.config.MessageQConfig;
import com.peak.prd.config.PrimaryKeyConfig;
import com.peak.prd.config.RedisConfig;
import com.peak.prd.mq.sendlog.model.Sendlog;
import com.peak.prd.mq.sendlog.service.ISendlogPlusService;
import com.peak.prd.sys.mqdefine.service.imple.SysMqdefinePlusService;
import com.peak.prd.sys.mqdefine.vo.SysMqdefineMiniVO;
import com.peak.prd.sys.mqhandler.bo.SysMqhandlerBO;
import com.peak.prd.sys.mqhandler.bo.SysMqhandlerQueryBO;
import com.peak.prd.sys.mqhandler.dao.ISysMqhandlerPlusDao;
import com.peak.prd.sys.mqhandler.model.SysMqhandler;
import com.peak.prd.sys.mqhandler.service.ISysMqhandlerPlusService;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerMngVO;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerQuery;
import com.peak.prd.sys.mqhandler.vo.SysMqhandlerVO;
import java.time.Duration;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamInfo;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.stereotype.Service;

@Service
@CacheConfig(cacheNames={"prd"})
public class SysMqhandlerPlusService
extends PrdBaseService<SysMqhandler, Long, SysMqhandlerQuery>
implements ISysMqhandlerPlusService {
    private static final Logger log = LoggerFactory.getLogger(SysMqhandlerPlusService.class);
    @Resource
    private ISysMqhandlerPlusDao sysMqhandlerPlusDao;
    @Resource
    private IAppdictPlusService appdictPlusService;
    @Resource
    private SysMqdefinePlusService sysMqdefinePlusService;
    @Resource
    private RedisStreamService redisStreamService;
    @Resource
    PrimaryKeyConfig primaryKeyConfig;
    @Resource
    ISendlogPlusService sendlogPlusService;
    @Resource
    RedisConfig redisConfig;

    public IEntityDao<SysMqhandler, Long, SysMqhandlerQuery> getEntityDao() {
        return this.sysMqhandlerPlusDao;
    }

    @Override
    public Paging<SysMqhandlerMngVO> getMngVOList(SysMqhandlerQueryBO sysMqhandlerQueryBO) {
        SysMqhandlerQuery query = new SysMqhandlerQuery(sysMqhandlerQueryBO.getPageNumber(), sysMqhandlerQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)sysMqhandlerQueryBO), (Object)query);
        query.getPage().setSortColumns("mqh.CREATEDATE DESC");
        Paging mqhandlerMngVOPaging = this.sysMqhandlerPlusDao.findPaging(query, SysMqhandlerMngVO.class);
        List mqhandlerMngVOList = mqhandlerMngVOPaging.getList();
        if (mqhandlerMngVOList == null || mqhandlerMngVOList.isEmpty()) {
            return mqhandlerMngVOPaging;
        }
        UserCoreUtil.setUserVO(mqhandlerMngVOList, SysMqhandlerMngVO::getCreatorId, SysMqhandlerMngVO::setUserVO);
        AppdictUtil.setAppdictMiniVO(mqhandlerMngVOList, SysMqhandlerMngVO::getSvrappdictId, SysMqhandlerMngVO::setSvrappdict);
        return mqhandlerMngVOPaging;
    }

    @Override
    public void insert(Long userId, SysMqhandlerBO sysMqhandlerBO) throws Exception {
        SysMqhandler sysMqhandler = (SysMqhandler)ConvertUtil.convert((Object)sysMqhandlerBO, SysMqhandler.class);
        Long mqhandlerId = IdUtil.getSequence((String)"SYS_MQHANDLER");
        sysMqhandler.setMqhandlerId(mqhandlerId);
        sysMqhandler.setCreatorId(userId);
        sysMqhandler.setCreatedate(new Date());
        sysMqhandler.setUpdatedate(sysMqhandler.getCreatedate());
        sysMqhandler.setGroupnum(this.getNextGroupNum(sysMqhandlerBO.getMqdefineId()));
        this.sysMqhandlerPlusDao.insertSelective((BaseEntity)sysMqhandler);
    }

    @Override
    @ClearCache(value="#sysMqhandlerBO.mqhandlerId")
    public Integer update(SysMqhandlerBO sysMqhandlerBO) throws Exception {
        SysMqhandler oldSysMqhandler = (SysMqhandler)this.getById(sysMqhandlerBO.getMqhandlerId());
        if (oldSysMqhandler == null) {
            return 0;
        }
        SysMqhandler sysMqhandler = (SysMqhandler)ConvertUtil.convert((Object)oldSysMqhandler, SysMqhandler.class);
        ConvertUtil.copyProperties((Object)sysMqhandlerBO, (Object)sysMqhandler);
        sysMqhandler.setUpdatedate(new Date());
        return this.sysMqhandlerPlusDao.update(sysMqhandler);
    }

    @Override
    @ClearCache(value="#mqhandlerId")
    public void changeStatus(Long mqhandlerId, Integer status) {
        SysMqhandler sysMqhandler = new SysMqhandler(mqhandlerId);
        sysMqhandler.setStatus(status);
        sysMqhandler.setUpdatedate(new Date());
        this.updateSelective(sysMqhandler);
    }

    @Override
    @ClearCache(value="#mqhandlerId")
    public Integer delete(Long mqhandlerId) throws Exception {
        return this.deleteById(mqhandlerId);
    }

    @Override
    public List<SysMqhandlerVO> getPublicHandlerList(Long mqdefineId) {
        SysMqhandlerQuery query = new SysMqhandlerQuery();
        query.setMqdefineId(mqdefineId);
        query.setStatus(1);
        query.getPage().setPageNumber(1);
        query.getPage().setPageSize(5000);
        query.getPage().setSortColumns("mqh.CREATEDATE DESC");
        List sysMqhandlerList = this.sysMqhandlerPlusDao.findList(query);
        List sysMqhandlerVOList = ConvertUtil.convert((List)sysMqhandlerList, SysMqhandlerVO.class);
        if (sysMqhandlerVOList == null || sysMqhandlerVOList.isEmpty()) {
            return sysMqhandlerVOList;
        }
        for (SysMqhandlerVO sysMqhandlerVO : sysMqhandlerVOList) {
            sysMqhandlerVO.setSvrappdict((AppdictVO)this.appdictPlusService.findVOById(sysMqhandlerVO.getSvrappdictId(), AppdictVO.class));
        }
        return sysMqhandlerVOList;
    }

    @Override
    public List<SysMqhandlerVO> getPublicHandlerList() {
        SysMqhandlerQuery query = new SysMqhandlerQuery();
        query.setStatus(1);
        query.getPage().setPageNumber(1);
        query.getPage().setPageSize(5000);
        query.getPage().setSortColumns("mqh.MQDEFINE_ID , mqh.CREATEDATE DESC");
        List sysMqhandlerList = this.sysMqhandlerPlusDao.findList(query);
        List sysMqhandlerVOList = ConvertUtil.convert((List)sysMqhandlerList, SysMqhandlerVO.class);
        if (sysMqhandlerVOList == null || sysMqhandlerVOList.isEmpty()) {
            return sysMqhandlerVOList;
        }
        for (SysMqhandlerVO sysMqhandlerVO : sysMqhandlerVOList) {
            sysMqhandlerVO.setSvrappdict((AppdictVO)this.appdictPlusService.findVOById(sysMqhandlerVO.getSvrappdictId(), AppdictVO.class));
            sysMqhandlerVO.setSysMqdefineMiniVO((SysMqdefineMiniVO)this.sysMqdefinePlusService.findVOById(sysMqhandlerVO.getMqdefineId(), SysMqdefineMiniVO.class));
        }
        return sysMqhandlerVOList;
    }

    @Override
    public SysMqhandlerVO getHandler(Long mqdefineId, Integer groupnum) {
        SysMqhandlerQuery query = new SysMqhandlerQuery();
        query.setMqdefineId(mqdefineId);
        query.setGroupnum(groupnum);
        SysMqhandler sysMqhandler = (SysMqhandler)this.sysMqhandlerPlusDao.findOne(query);
        if (sysMqhandler == null) {
            return null;
        }
        return (SysMqhandlerVO)ConvertUtil.convert((Object)sysMqhandler, SysMqhandlerVO.class);
    }

    @Override
    @Cacheable
    public SysMqhandler findByClassname(String classname) {
        SysMqhandlerQuery query = new SysMqhandlerQuery();
        query.setClassname(classname);
        return (SysMqhandler)this.sysMqhandlerPlusDao.findOne(query);
    }

    @Override
    public Integer addListener(Long mqhandlerId) throws Exception {
        SysMqhandler sysMqhandler = (SysMqhandler)this.sysMqhandlerPlusDao.getById(mqhandlerId);
        if (sysMqhandler == null) {
            return 0;
        }
        String appName = this.primaryKeyConfig.getApplication();
        Appdict svrappdict = (Appdict)this.appdictPlusService.getById(sysMqhandler.getSvrappdictId());
        SysMqdefineMiniVO actionMqdefineVO = (SysMqdefineMiniVO)this.sysMqdefinePlusService.findVOById(sysMqhandler.getMqdefineId(), SysMqdefineMiniVO.class);
        if (svrappdict == null || actionMqdefineVO == null) {
            return 0;
        }
        if (svrappdict.getName().toLowerCase().equals(appName.toLowerCase())) {
            final String handlerName = sysMqhandler.getClassname();
            if (StringUtil.isNullorEmptyStr((String)handlerName)) {
                return 0;
            }
            final String groupId = appName + sysMqhandler.getGroupnum().toString();
            StreamListener<String, MapRecord<String, String, String>> redisStreamListener = new StreamListener<String, MapRecord<String, String, String>>(){

                public void onMessage(MapRecord<String, String, String> message) {
                    log.info("redis listen message getMessageQ > {}", (Object)(message + "  ==========  groupId:=== " + groupId + "  ==========  hannlerPartName:=== " + handlerName));
                }
            };
            this.addListener(actionMqdefineVO.getParentMqvalue(), groupId, actionMqdefineVO.getMqvalue(), handlerName, redisStreamListener);
        }
        return 1;
    }

    @Override
    public Integer enabledHandler(List<Long> sysMqdefineIds) {
        return this.sysMqhandlerPlusDao.enabledHandler(sysMqdefineIds);
    }

    private void addListener(String topicNoPrefix, String groupId, String action, String handler, StreamListener<String, MapRecord<String, String, String>> redisStreamListener) {
        if (StringUtil.isNullorEmptyStr((String)topicNoPrefix) || StringUtil.isNullorEmptyStr((String)action)) {
            return;
        }
        MessageQConfig messageQConfig = (MessageQConfig)SpringUtil.getBean((String)"messageQConfig");
        String topicSuffix = messageQConfig.getCustomTopicSuffix();
        String topicPrefix = messageQConfig.getCustomTopicPrefix();
        String topic = topicPrefix + topicNoPrefix + "_" + action + topicSuffix;
        StreamMessageListenerContainer listenerContainer = null;
        try {
            listenerContainer = StreamMessageListenerContainer.create((RedisConnectionFactory)this.redisStreamService.getConnectionFactory(), this.listenerContainerOptions());
            this.checkGroup(topic, groupId, topicNoPrefix, action);
            listenerContainer.register(this.streamReadRequest(topic, groupId), redisStreamListener);
            listenerContainer.start();
            log.info("listen message consumer start topic=====groupId=====handler > {} ", (Object)(topic + "=====" + groupId + "=====" + handler));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private StreamMessageListenerContainer.StreamReadRequest<String> streamReadRequest(String topic, String groupId) {
        return StreamMessageListenerContainer.StreamReadRequest.builder((StreamOffset)StreamOffset.create((Object)this.getKey(topic), (ReadOffset)ReadOffset.lastConsumed())).consumer(Consumer.from((String)groupId, (String)UUID.randomUUID().toString())).cancelOnError(t -> false).build();
    }

    private StreamMessageListenerContainer.StreamMessageListenerContainerOptions<String, MapRecord<String, String, String>> listenerContainerOptions() {
        StreamMessageListenerContainer.StreamMessageListenerContainerOptions streamMessageListenerContainerOptions = null;
        AtomicInteger index = new AtomicInteger(1);
        int processors = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor executor1 = new ThreadPoolExecutor(processors, processors, 0L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), r -> {
            Thread thread = new Thread(r);
            thread.setName("async-stream-consumer-" + index.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        });
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        streamMessageListenerContainerOptions = StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().pollTimeout(Duration.ofSeconds(30L)).batchSize(10).serializer((RedisSerializer)stringRedisSerializer).errorHandler(throwable -> {
            log.error("[MQ handler exception]", throwable);
            throwable.printStackTrace();
        }).build();
        return streamMessageListenerContainerOptions;
    }

    private void checkGroup(String topic, String groupId, String topicNoPrefix, String action) {
        boolean hasStream;
        if (this.redisStreamService == null) {
            this.redisStreamService = (RedisStreamService)SpringUtil.getBean((String)"redisStreamService");
        }
        if (!(hasStream = this.redisStreamService.hasStream(topic))) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("field", "value");
            RecordId recordId = this.redisStreamService.send(topic, map);
            this.createGroup(topic, groupId, recordId.getValue(), topicNoPrefix, action);
            this.redisStreamService.delRecord(topic, recordId.getValue());
            log.info("stream:{}-group:{} initialize success", (Object)topic, (Object)groupId);
        } else {
            this.createGroup(topic, groupId, "", topicNoPrefix, action);
        }
    }

    private void createGroup(String topic, String groupId, String maxRecordId, String topicNoPrefix, String action) {
        if (StringUtil.isNullorEmptyStr((String)maxRecordId)) {
            Sendlog sendlog = this.sendlogPlusService.getLastSendlog(topicNoPrefix, action);
            if (sendlog != null) {
                if (maxRecordId.startsWith("sendMessage_1_")) {
                    maxRecordId = sendlog.getSendutilmethod().replace("sendMessage_1_", "");
                }
            } else {
                maxRecordId = "";
            }
        }
        Boolean validGroup = false;
        this.redisStreamService.destroyGroup(topic, groupId);
        if (!StringUtil.isNullorEmptyStr((String)maxRecordId)) {
            for (int n = 0; n < 10; ++n) {
                this.redisStreamService.createGroup(topic, groupId);
                StreamInfo.XInfoGroups infoGroups = this.redisStreamService.getGroups(topic);
                if (Objects.nonNull(infoGroups)) {
                    for (int i = 0; i < infoGroups.size(); ++i) {
                        StreamInfo.XInfoGroup infoGroup = infoGroups.get(i);
                        if (!infoGroup.groupName().equals(groupId)) continue;
                        String lastDeliveredId = infoGroup.lastDeliveredId().replace("-0", "");
                        maxRecordId = maxRecordId.replace("-0", "");
                        if (Long.valueOf(lastDeliveredId) < Long.valueOf(maxRecordId)) continue;
                        validGroup = true;
                        break;
                    }
                }
                if (validGroup.booleanValue()) break;
                this.redisStreamService.destroyGroup(topic, groupId);
            }
        }
        if (!validGroup.booleanValue()) {
            this.redisStreamService.createGroup(topic, groupId);
        }
    }

    private String getKey(String key) {
        String prefix = this.redisConfig.getKeyPrefix();
        if (prefix == null) {
            return "MQ:" + key;
        }
        return prefix + "::MQ:" + key;
    }

    @Caching(evict={@CacheEvict(cacheNames={"prd"}, key="#root.targetClass.simpleName + ':' + #id")})
    public void clearCache(Long id) {
    }

    private Integer getNextGroupNum(Long mqdefineId) {
        SysMqhandlerQuery query = new SysMqhandlerQuery();
        query.setMqdefineId(mqdefineId);
        query.getPage().setPageNumber(1);
        query.getPage().setPageSize(5000);
        query.getPage().setSortColumns("mqh.GROUPNUM DESC");
        List sysMqhandlerList = this.sysMqhandlerPlusDao.findList(query);
        if (sysMqhandlerList == null || sysMqhandlerList.isEmpty()) {
            return 1;
        }
        return ((SysMqhandler)sysMqhandlerList.get(0)).getGroupnum() + 1;
    }
}

