/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.sys.syscode.util;

import com.peak.common.util.DateUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.enums.BusinessOrigin;
import com.peak.prd.sys.syscode.model.Syscode;
import com.peak.prd.sys.syscode.service.ISyscodePlusService;
import com.peak.prd.sys.syscode.service.imple.SyscodePlusService;
import java.util.Date;

public class SyscodeUtil {
    public static String getSyscodeByBusinessOrigin(BusinessOrigin businessOriginType) {
        return SyscodeUtil.getSyscodeByBusinessType(businessOriginType.getIndex());
    }

    public static String getSyscodeByBusinessType(Integer businessType) {
        int maxnum;
        if (businessType == null) {
            return null;
        }
        ISyscodePlusService syscodePlusService = (ISyscodePlusService)SpringUtil.getBean(SyscodePlusService.class);
        Syscode syscode = syscodePlusService.getSyscodeByBusinessType(businessType);
        if (syscode == null || syscode.getCoderule() == null) {
            return null;
        }
        String coderule = syscode.getCoderule();
        Date now = new Date();
        String year = DateUtil.getYear((Date)now) + "";
        String month = DateUtil.getMonth((Date)now) + "";
        String day = DateUtil.getDay((Date)now) + "";
        coderule = coderule.replace("{{YYYY}}", year).replace("{{MM}}", month).replace("{{DD}}", day);
        int n = maxnum = syscode.getMaxnum() != null ? syscode.getMaxnum() + 1 : 1;
        coderule = coderule.indexOf("{{3SN}}") > -1 ? coderule.replace("{{3SN}}", String.format("%03d", maxnum)) : (coderule.indexOf("{{4SN}}") > -1 ? coderule.replace("{{4SN}}", String.format("%04d", maxnum)) : (coderule.indexOf("{{5SN}}") > -1 ? coderule.replace("{{5SN}}", String.format("%05d", maxnum)) : coderule + "-" + String.format("%05d", maxnum)));
        syscode.setMaxnum(maxnum);
        syscodePlusService.updateSelective(syscode);
        return coderule;
    }
}

