/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.sys.syserrorlog.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.common.util.NetworkUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appconfig.service.IAppconfigPlusService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.sys.syserrorlog.bo.SyserrorlogDeleteBO;
import com.peak.prd.sys.syserrorlog.bo.SyserrorlogQueryBO;
import com.peak.prd.sys.syserrorlog.dao.ISyserrorlogPlusDao;
import com.peak.prd.sys.syserrorlog.model.Syserrorlog;
import com.peak.prd.sys.syserrorlog.service.ISyserrorlogPlusService;
import com.peak.prd.sys.syserrorlog.vo.SyserrorlogQuery;
import com.peak.prd.sys.syserrorlog.vo.SyserrorlogVO;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SyserrorlogPlusService
extends PrdBaseService<Syserrorlog, Long, SyserrorlogQuery>
implements ISyserrorlogPlusService,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SyserrorlogPlusService.class);
    private static int MAX_TITLE_LENGTH = 600;
    private static int MAX_STACKTRACE_LENGTH = 65535;
    private static int MAX_SERVERINFO_LENGTH = 200;
    private static int MAX_CLIENTINFO_LENGTH = 200;
    private long appstartdate;
    private String serverInfo;
    private String serverUuid;
    private AtomicLong errorTotalNum = new AtomicLong();
    @Value(value="${spring.application.name:}")
    private String appName;
    static final String CONFIGKEY = "Syserrorlog_insert";
    private static ExecutorService persistThreadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(0x7FFFFFFE));
    @Resource
    private ISyserrorlogPlusDao syserrorlogPlusDao;
    @Resource
    private IAppconfigPlusService appconfigPlusService;

    @Override
    public void insertExceptionLog(Exception ex, HttpServletRequest request) {
        long now = System.currentTimeMillis();
        long totalErrorNum = this.errorTotalNum.incrementAndGet();
        String msg = "[totalErrorNum:" + totalErrorNum + "][server started:" + (now - this.appstartdate) / 1000L + "s]";
        log.error(msg, (Throwable)ex);
        String configValue = AppconfigUtil.getValueByConfigkey(CONFIGKEY);
        boolean bPersist = "1".equals(configValue);
        if (!bPersist) {
            if (log.isDebugEnabled()) {
                log.debug("\u5f02\u5e38\u65e5\u5fd7persist false");
            }
            return;
        }
        final Syserrorlog syserrorlog = new Syserrorlog(IdUtil.getSequence((String)"SYS_SYSERRORLOG"));
        String errTitle = this.trim(ex.getMessage(), MAX_TITLE_LENGTH);
        if (errTitle == null || errTitle.isEmpty()) {
            errTitle = ex.getClass().getName();
        }
        syserrorlog.setTitle(errTitle);
        syserrorlog.setStacktrace(this.getStackTraceString(ex, MAX_STACKTRACE_LENGTH));
        syserrorlog.setAppname(this.appName);
        syserrorlog.setServeruuId(this.serverUuid);
        syserrorlog.setServerinfo(this.serverInfo);
        syserrorlog.setCreatedate(new Date());
        if (request != null) {
            syserrorlog.setClientinfo(this.trim(NetworkUtil.getClientIp((HttpServletRequest)request), MAX_CLIENTINFO_LENGTH));
        }
        persistThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SyserrorlogPlusService.this.syserrorlogPlusDao.insert((BaseEntity)syserrorlog);
                }
                catch (Exception ex) {
                    log.error("syserrorlogPlusDao.insert fail:", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public int deleteLog(Date createdateBegin, Date createdateEnd) {
        if (createdateBegin == null && createdateEnd == null) {
            return -1;
        }
        if (createdateBegin == null) {
            createdateBegin = new Date(0L);
        } else if (createdateEnd == null) {
            createdateEnd = new Date(System.currentTimeMillis());
        }
        int affectNum = this.syserrorlogPlusDao.deleteLog(createdateBegin, createdateEnd);
        log.info("deleteLog: from {} to {}, affectNum: {}", new Object[]{createdateBegin, createdateEnd, affectNum});
        return affectNum;
    }

    @Override
    public int deleteBatch(SyserrorlogDeleteBO deleteBO) {
        int affectNum = !CollectionUtils.isEmpty(deleteBO.getSyserrorlogIds()) ? this.deleteByIds(deleteBO.getSyserrorlogIds()) : this.deleteLog(deleteBO.getCreatedateBegin(), deleteBO.getCreatedateEnd());
        if (affectNum > 0) {
            log.info("deleteLog affectNum: {}", (Object)affectNum);
        }
        return affectNum;
    }

    @Override
    public Paging<SyserrorlogVO> getPage(SyserrorlogQueryBO queryBO) {
        SyserrorlogQuery query = (SyserrorlogQuery)ConvertUtil.convert((Object)((Object)queryBO), SyserrorlogQuery.class);
        query.setColumns("elog.SYSERRORLOG_ID, elog.TITLE, elog.appname, elog.CREATEDATE");
        query.getPage().setSortColumns("elog.CREATEDATE desc, elog.SYSERRORLOG_ID desc");
        return this.syserrorlogPlusDao.findPaging(query, SyserrorlogVO.class);
    }

    @Override
    public SyserrorlogVO getInfo(Long syserrorlogId) {
        Syserrorlog model = (Syserrorlog)this.getById(syserrorlogId);
        return (SyserrorlogVO)ConvertUtil.convert((Object)model, SyserrorlogVO.class);
    }

    /*
     * Exception decompiling
     */
    private String getStackTraceString(Exception ex, int maxLength) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String trim(String str, int maxLength) {
        int utf8_max_length = maxLength / 3;
        if (str == null || str.length() <= utf8_max_length) {
            return str;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length <= maxLength) {
            return str;
        }
        return new String(bytes, 0, utf8_max_length * 3, StandardCharsets.UTF_8);
    }

    public IEntityDao<Syserrorlog, Long, SyserrorlogQuery> getEntityDao() {
        return this.syserrorlogPlusDao;
    }

    public void afterPropertiesSet() throws Exception {
        this.appstartdate = System.currentTimeMillis();
        this.serverUuid = IdUtil.getGkey();
        this.serverInfo = this.trim(InetAddress.getLocalHost().getHostAddress(), MAX_SERVERINFO_LENGTH);
    }
}

