/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.sys.tracelog.service.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.common.util.IdUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.prd.base.model.Paging;
import com.peak.prd.base.service.imple.PrdBaseService;
import com.peak.prd.common.appconfig.util.AppconfigUtil;
import com.peak.prd.enums.TracelogLevelEnum;
import com.peak.prd.sys.tracelog.bo.TracelogQueryBO;
import com.peak.prd.sys.tracelog.dao.ITracelogPlusDao;
import com.peak.prd.sys.tracelog.model.Tracelog;
import com.peak.prd.sys.tracelog.service.ITracelogPlusService;
import com.peak.prd.sys.tracelog.vo.TracelogQuery;
import com.peak.prd.sys.tracelog.vo.TracelogVO;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TracelogPlusService
extends PrdBaseService<Tracelog, Long, TracelogQuery>
implements ITracelogPlusService {
    @Resource
    private ITracelogPlusDao tracelogPlusDao;
    @Value(value="${spring.application.name:}")
    private String appName;

    public IEntityDao<Tracelog, Long, TracelogQuery> getEntityDao() {
        return this.tracelogPlusDao;
    }

    @Override
    public Long insert(String logtitle, String logcontent, TracelogLevelEnum tracelogLevel) {
        try {
            String systraceloglevel = AppconfigUtil.getValueByConfigkey("Systracelog_level");
            if (systraceloglevel == null || tracelogLevel.getValue() < Integer.parseInt(systraceloglevel)) {
                return null;
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        int datamaxnum = 166;
        if (logtitle.length() > datamaxnum) {
            logtitle = logtitle.substring(0, datamaxnum);
        }
        if (logcontent.length() > datamaxnum) {
            logcontent = logcontent.substring(0, datamaxnum);
        }
        Tracelog tracelog = new Tracelog();
        Long tracelogId = IdUtil.getSequence((String)"SYS_TRACELOG");
        tracelog.setTracelogId(tracelogId);
        tracelog.setLogtitle(logtitle);
        tracelog.setLogcontent(logcontent);
        tracelog.setServicename(this.appName);
        tracelog.setLoglevel(tracelogLevel.getValue());
        tracelog.setCreatedate(new Date());
        int insertnum = this.tracelogPlusDao.insertSelective((BaseEntity)tracelog);
        return insertnum > 0 ? tracelogId : null;
    }

    @Override
    public Paging<TracelogVO> getVOList(TracelogQueryBO tracelogQueryBO) {
        TracelogQuery query = new TracelogQuery(tracelogQueryBO.getPageNumber(), tracelogQueryBO.getPageSize());
        ConvertUtil.copyProperties((Object)((Object)tracelogQueryBO), (Object)query);
        query.getPage().setSortColumns("sytl.CREATEDATE DESC");
        return this.tracelogPlusDao.findPaging(query, TracelogVO.class);
    }

    @Override
    public Integer deleteBatch(List<Long> tracelogIds) {
        return this.tracelogPlusDao.deleteBatch(tracelogIds);
    }

    @Override
    public Integer deleteBatch(Date createdateBegin, Date createdateEnd) {
        return this.tracelogPlusDao.deleteBatch(createdateBegin, createdateEnd);
    }
}

