/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.thread;

import com.peak.common.util.SpringUtil;
import com.peak.common.util.StringUtil;
import com.peak.prd.enums.AsynImpExpEnum;
import com.peak.prd.sys.impexpinfo.model.Impexpinfo;
import com.peak.prd.sys.impexpinfo.service.IImpexpinfoPlusService;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import java.lang.reflect.Method;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExportThread.class);
    ProceedingJoinPoint proceedingJoinPoint;
    Object[] args;
    String methodName;
    Long impexpId;

    public ExportThread(ProceedingJoinPoint proceedingJoinPoint, Object[] args, Long impexpId, String methodName) {
        this.proceedingJoinPoint = proceedingJoinPoint;
        this.args = args;
        this.methodName = methodName;
        this.impexpId = impexpId;
    }

    @Override
    public void run() {
        if (StringUtil.isNullorEmptyStr((String)this.methodName)) {
            this.exeProceedMethod();
        } else {
            this.exeSpecificMethod();
        }
    }

    private void exeSpecificMethod() {
        IImpexpinfoPlusService impexpinfoPlusService = (IImpexpinfoPlusService)SpringUtil.getBean(IImpexpinfoPlusService.class);
        Impexpinfo impexpinfo = new Impexpinfo();
        impexpinfo.setSysieiId(this.impexpId);
        Class<?> clazz = this.proceedingJoinPoint.getTarget().getClass();
        Object service = SpringUtil.getBean(clazz);
        Method impexpMethod = null;
        try {
            Class[] clazzes = new Class[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                clazzes[i] = this.args[i].getClass();
            }
            impexpMethod = clazz.getDeclaredMethod(this.methodName, clazzes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_FAIL.getValue());
            impexpinfo.setErrorinfo(e.getMessage());
            impexpinfoPlusService.updateSelective(impexpinfo);
            return;
        }
        if (impexpMethod == null) {
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_FAIL.getValue());
            impexpinfo.setErrorinfo("\u6ce8\u89e3\u6240\u5728\u7c7b\u6ca1\u6709\u5b9e\u73b0" + this.methodName + "\u65b9\u6cd5");
            impexpinfoPlusService.updateSelective(impexpinfo);
            return;
        }
        try {
            ExportInfoVO exportInfoVO = (ExportInfoVO)impexpMethod.invoke(service, this.args);
            impexpinfo.setFilepath(exportInfoVO.getFilepath());
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_SUCCESS.getValue());
            impexpinfo.setCompletedate(new Date());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_FAIL.getValue());
            impexpinfo.setErrorinfo(e.getMessage());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
    }

    private void exeProceedMethod() {
        IImpexpinfoPlusService impexpinfoPlusService = (IImpexpinfoPlusService)SpringUtil.getBean(IImpexpinfoPlusService.class);
        Impexpinfo impexpinfo = new Impexpinfo();
        impexpinfo.setSysieiId(this.impexpId);
        try {
            ExportInfoVO exportInfoVO = (ExportInfoVO)this.proceedingJoinPoint.proceed(this.args);
            impexpinfo.setFilepath(exportInfoVO.getFilepath());
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_SUCCESS.getValue());
            impexpinfo.setCompletedate(new Date());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_FAIL.getValue());
            impexpinfo.setErrorinfo(e.getMessage());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
    }
}

