/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.thread;

import com.peak.common.util.SpringUtil;
import com.peak.prd.enums.AsynImpExpEnum;
import com.peak.prd.sys.impexpinfo.model.Impexpinfo;
import com.peak.prd.sys.impexpinfo.service.IImpexpinfoPlusService;
import com.peak.prd.sys.impexpinfo.vo.ExportInfoVO;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendExportThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ExtendExportThread.class);
    ProceedingJoinPoint proceedingJoinPoint;
    Object[] args;
    Long impexpId;

    public ExtendExportThread(ProceedingJoinPoint proceedingJoinPoint, Object[] args, Long impexpId) {
        this.proceedingJoinPoint = proceedingJoinPoint;
        this.args = args;
        this.impexpId = impexpId;
    }

    @Override
    public void run() {
        this.exeProceedMethod();
    }

    private void exeProceedMethod() {
        IImpexpinfoPlusService impexpinfoPlusService = (IImpexpinfoPlusService)SpringUtil.getBean(IImpexpinfoPlusService.class);
        Impexpinfo impexpinfo = new Impexpinfo();
        impexpinfo.setSysieiId(this.impexpId);
        try {
            ExportInfoVO exportInfoVO = (ExportInfoVO)this.proceedingJoinPoint.proceed(this.args);
            impexpinfo.setFilepath(exportInfoVO.getFilepath());
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_SUCCESS.getValue());
            impexpinfo.setCompletedate(new Date());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_FAIL.getValue());
            impexpinfo.setErrorinfo(e.getMessage());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
    }
}

