/*
 * Decompiled with CFR 0.152.
 */
package com.peak.prd.thread;

import com.peak.common.util.SpringUtil;
import com.peak.prd.enums.AsynImpExpEnum;
import com.peak.prd.sys.impexpinfo.model.Impexpinfo;
import com.peak.prd.sys.impexpinfo.service.IImpexpinfoPlusService;
import com.peak.prd.sys.impexpinfo.vo.ImportInfoVO;
import java.util.Date;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportThread.class);
    ProceedingJoinPoint proceedingJoinPoint;
    Object[] args;
    Long impexpId;

    public ImportThread(ProceedingJoinPoint proceedingJoinPoint, Object[] args, Long impexpId) {
        this.proceedingJoinPoint = proceedingJoinPoint;
        this.args = args;
        this.impexpId = impexpId;
    }

    @Override
    public void run() {
        IImpexpinfoPlusService impexpinfoPlusService = (IImpexpinfoPlusService)SpringUtil.getBean(IImpexpinfoPlusService.class);
        Impexpinfo impexpinfo = new Impexpinfo();
        impexpinfo.setSysieiId(this.impexpId);
        try {
            ImportInfoVO importInfoVO = (ImportInfoVO)this.proceedingJoinPoint.proceed(this.args);
            impexpinfo.setFilepath(importInfoVO.getFilepath());
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_SUCCESS.getValue());
            impexpinfo.setImporttotalnum(importInfoVO.getImporttotalnum());
            impexpinfo.setImportsuccessnum(importInfoVO.getImportsuccessnum());
            impexpinfo.setImporterrornum(importInfoVO.getImporterrornum());
            impexpinfo.setCompletedate(new Date());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            impexpinfo.setStatus(AsynImpExpEnum.STATUS_FAIL.getValue());
            impexpinfo.setErrorinfo(e.getMessage());
            impexpinfoPlusService.updateSelective(impexpinfo);
        }
    }
}

