/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import toolgood.words.internals.BasePinyinMatch;
import toolgood.words.internals.PinyinDict;
import toolgood.words.internals.TwoTuple;

public class PinyinMatch
extends BasePinyinMatch {
    private String[] _keywords;
    private String[] _keywordsFirstPinyin;
    private String[][] _keywordsPinyin;
    private int[] _indexs;

    public void SetKeywords(List<String> keywords) throws NumberFormatException, IOException {
        this._keywords = keywords.toArray(new String[0]);
        this._keywordsFirstPinyin = new String[this._keywords.length];
        this._keywordsPinyin = new String[this._keywords.length][];
        int i = 0;
        while (i < this._keywords.length) {
            String text = this._keywords[i];
            String[] pys = PinyinDict.GetPinyinList(text, 0);
            String fpy = "";
            int j = 0;
            while (j < pys.length) {
                pys[j] = pys[j].toUpperCase();
                fpy = String.valueOf(fpy) + pys[j].charAt(0);
                ++j;
            }
            this._keywordsPinyin[i] = pys;
            this._keywordsFirstPinyin[i] = fpy;
            ++i;
        }
        this._indexs = null;
    }

    public void SetKeywords(List<String> keywords, List<String> pinyin) {
        this.SetKeywords(keywords, pinyin, ',');
    }

    public void SetKeywords(List<String> keywords, List<String> pinyin, char splitChar) {
        this._keywords = keywords.toArray(new String[0]);
        this._keywordsFirstPinyin = new String[this._keywords.length];
        this._keywordsPinyin = new String[this._keywords.length][];
        int i = 0;
        while (i < this._keywords.length) {
            String text = pinyin.get(i);
            String[] pys = text.split(Character.valueOf(splitChar).toString());
            String fpy = "";
            int j = 0;
            while (j < pys.length) {
                pys[j] = pys[j].toUpperCase();
                fpy = String.valueOf(fpy) + pys[j].charAt(0);
                ++j;
            }
            this._keywordsPinyin[i] = pys;
            this._keywordsFirstPinyin[i] = fpy;
            ++i;
        }
        this._indexs = null;
    }

    public void SetIndexs(List<Integer> indexs) throws Exception {
        if (this._keywords == null) {
            throw new Exception("\u8bf7\u5148\u4f7f\u7528 SetKeywords \u65b9\u6cd5");
        }
        if (indexs.size() < this._keywords.length) {
            throw new Exception("indexs \u6570\u7ec4\u957f\u5ea6\u5927\u4e8e keywords");
        }
        this._indexs = new int[indexs.size()];
        int i = 0;
        while (i < indexs.size()) {
            this._indexs[i] = indexs.get(i);
            ++i;
        }
    }

    public List<String> Find(String key) throws NumberFormatException, IOException {
        if ((key = key.toUpperCase().trim()) == null || key.equals("")) {
            return null;
        }
        boolean hasPinyin = key.matches("^.*?[A-Z]+.*$");
        if (!hasPinyin) {
            ArrayList<String> rs = new ArrayList<String>();
            int i = 0;
            while (i < this._keywords.length) {
                String keyword = this._keywords[i];
                if (keyword.contains(key)) {
                    rs.add(keyword);
                }
                ++i;
            }
            return rs;
        }
        List<String> pykeys = this.SplitKeywords(key);
        int minLength = Integer.MAX_VALUE;
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        for (String pykey : pykeys) {
            String[] keys = pykey.split(Character.valueOf('\u0000').toString());
            if (minLength > keys.length) {
                minLength = keys.length;
            }
            this.MergeKeywords(keys, 0, "", list);
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this._keywords.length) {
            String[] pylist;
            String fpy;
            String keywords = this._keywords[i];
            if (keywords.length() >= minLength && search.Find(fpy = this._keywordsFirstPinyin[i], keywords, pylist = this._keywordsPinyin[i])) {
                result.add(keywords);
            }
            ++i;
        }
        return result;
    }

    public List<Integer> FindIndex(String key) throws NumberFormatException, IOException {
        if ((key = key.toUpperCase().trim()) == null || key.equals("")) {
            return null;
        }
        boolean hasPinyin = key.matches("^.*?[A-Z]+.*$");
        if (!hasPinyin) {
            ArrayList<Integer> rs = new ArrayList<Integer>();
            int i = 0;
            while (i < this._keywords.length) {
                String keyword = this._keywords[i];
                if (keyword.contains(key)) {
                    if (this._indexs == null) {
                        rs.add(i);
                    } else {
                        rs.add(this._indexs[i]);
                    }
                }
                ++i;
            }
            return rs;
        }
        List<String> pykeys = this.SplitKeywords(key);
        int minLength = Integer.MAX_VALUE;
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        for (String pykey : pykeys) {
            String[] keys = pykey.split(Character.valueOf('\u0000').toString());
            if (minLength > keys.length) {
                minLength = keys.length;
            }
            this.MergeKeywords(keys, 0, "", list);
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < this._keywords.length) {
            String[] pylist;
            String fpy;
            String keywords = this._keywords[i];
            if (keywords.length() >= minLength && search.Find(fpy = this._keywordsFirstPinyin[i], keywords, pylist = this._keywordsPinyin[i])) {
                if (this._indexs == null) {
                    result.add(i);
                } else {
                    result.add(this._indexs[i]);
                }
            }
            ++i;
        }
        return result;
    }

    public List<String> FindWithSpace(String keywords) throws NumberFormatException, IOException {
        if ((keywords = keywords.toUpperCase().trim()) == null || keywords.equals("")) {
            return null;
        }
        if (!keywords.contains(" ")) {
            return this.Find(keywords);
        }
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int minLength = 0;
        String[] keys = keywords.split(" ");
        int keysCount = keys.length;
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            List<String> pykeys = this.SplitKeywords(key);
            int min = Integer.MAX_VALUE;
            for (String pykey : pykeys) {
                String[] keys2 = pykey.split(Character.valueOf('\u0000').toString());
                if (min > keys2.length) {
                    min = keys2.length;
                }
                this.MergeKeywords(keys2, 0, "", list, i, indexs);
            }
            minLength += min;
            ++i;
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        search.SetIndexs(indexs);
        ArrayList<String> result = new ArrayList<String>();
        int i2 = 0;
        while (i2 < this._keywords.length) {
            String[] pylist;
            String fpy;
            String keywords2 = this._keywords[i2];
            if (keywords2.length() >= minLength && search.Find2(fpy = this._keywordsFirstPinyin[i2], keywords2, pylist = this._keywordsPinyin[i2], keysCount)) {
                result.add(keywords2);
            }
            ++i2;
        }
        return result;
    }

    public List<Integer> FindIndexWithSpace(String keywords) throws NumberFormatException, IOException {
        if ((keywords = keywords.toUpperCase().trim()) == null || keywords.equals("")) {
            return null;
        }
        if (!keywords.contains(" ")) {
            return this.FindIndex(keywords);
        }
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int minLength = 0;
        String[] keys = keywords.split(" ");
        int keysCount = keys.length;
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            List<String> pykeys = this.SplitKeywords(key);
            int min = Integer.MAX_VALUE;
            for (String pykey : pykeys) {
                String[] keys2 = pykey.split(Character.valueOf('\u0000').toString());
                if (min > keys2.length) {
                    min = keys2.length;
                }
                this.MergeKeywords(keys2, 0, "", list, i, indexs);
            }
            minLength += min;
            ++i;
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        search.SetIndexs(indexs);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < this._keywords.length) {
            String[] pylist;
            String fpy;
            String keywords2 = this._keywords[i2];
            if (keywords2.length() >= minLength && search.Find2(fpy = this._keywordsFirstPinyin[i2], keywords2, pylist = this._keywordsPinyin[i2], keysCount)) {
                if (this._indexs == null) {
                    result.add(i2);
                } else {
                    result.add(this._indexs[i2]);
                }
            }
            ++i2;
        }
        return result;
    }
}

