/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import toolgood.words.internals.BasePinyinMatch;
import toolgood.words.internals.PinyinDict;
import toolgood.words.internals.TwoTuple;

public class PinyinMatch2<T>
extends BasePinyinMatch {
    private final List<T> _list;
    private Function<T, String> _keywordsFunc;
    private Function<T, String> _pinyinFunc;
    private char _splitChar = (char)44;

    public PinyinMatch2(List<T> list) {
        this._list = list;
        this._keywordsFunc = null;
        this._pinyinFunc = null;
    }

    public void SetKeywordsFunc(Function<T, String> keywordsFunc) {
        this._keywordsFunc = keywordsFunc;
    }

    public void SetPinyinFunc(Function<T, String> pinyinFunc) {
        this._pinyinFunc = pinyinFunc;
    }

    public void SetPinyinSplitChar(char splitChar) {
        this._splitChar = splitChar;
    }

    public List<T> Find(String keywords) throws Exception {
        if (this._keywordsFunc == null) {
            throw new Exception("\u8bf7\u5148\u4f7f\u7528SetKeywordsFunc\u65b9\u6cd5\u3002");
        }
        if ((keywords = keywords.toUpperCase().trim()) == null || keywords.equals("")) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        boolean hasPinyin = keywords.matches("^.*?[A-Z]+.*$");
        if (!hasPinyin) {
            for (T item : this._list) {
                String keyword = this._keywordsFunc.apply(item);
                if (!keyword.contains(keywords)) continue;
                result.add(item);
            }
            return result;
        }
        List<String> pykeys = this.SplitKeywords(keywords);
        int minLength = Integer.MAX_VALUE;
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        for (String pykey : pykeys) {
            String[] keys = pykey.split(Character.valueOf('\u0000').toString());
            if (minLength > keys.length) {
                minLength = keys.length;
            }
            this.MergeKeywords(keys, 0, "", list);
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        for (T item : this._list) {
            String keyword = this._keywordsFunc.apply(item);
            if (keyword.length() < minLength) continue;
            String fpy = "";
            String[] pylist = this._pinyinFunc == null ? PinyinDict.GetPinyinList(keyword, 0) : this._pinyinFunc.apply(item).split(Character.valueOf(this._splitChar).toString());
            int j = 0;
            while (j < pylist.length) {
                pylist[j] = pylist[j].toUpperCase();
                fpy = String.valueOf(fpy) + pylist[j].charAt(0);
                ++j;
            }
            if (!search.Find(fpy, keyword, pylist)) continue;
            result.add(item);
        }
        return result;
    }

    public List<T> FindWithSpace(String keywords) throws Exception {
        if (this._keywordsFunc == null) {
            throw new Exception("\u8bf7\u5148\u4f7f\u7528SetKeywordsFunc\u65b9\u6cd5\u3002");
        }
        if ((keywords = keywords.toUpperCase().trim()) == null || keywords.equals("")) {
            return null;
        }
        if (!keywords.contains(" ")) {
            return this.Find(keywords);
        }
        ArrayList<TwoTuple<String, String[]>> list = new ArrayList<TwoTuple<String, String[]>>();
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int minLength = 0;
        String[] keys = keywords.split(" ");
        int keysCount = keys.length;
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            List<String> pykeys = this.SplitKeywords(key);
            int min = Integer.MAX_VALUE;
            for (String pykey : pykeys) {
                String[] keys2 = pykey.split(Character.valueOf('\u0000').toString());
                if (min > keys2.length) {
                    min = keys2.length;
                }
                this.MergeKeywords(keys2, 0, "", list, i, indexs);
            }
            minLength += min;
            ++i;
        }
        BasePinyinMatch.PinyinSearch search = new BasePinyinMatch.PinyinSearch(this);
        search.SetKeywords2(list);
        search.SetIndexs(indexs);
        ArrayList<T> result = new ArrayList<T>();
        for (T item : this._list) {
            String keyword = this._keywordsFunc.apply(item);
            if (keyword.length() < minLength) continue;
            String fpy = "";
            String[] pylist = this._pinyinFunc == null ? PinyinDict.GetPinyinList(keyword, 0) : this._pinyinFunc.apply(item).split(Character.valueOf(this._splitChar).toString());
            int j = 0;
            while (j < pylist.length) {
                pylist[j] = pylist[j].toUpperCase();
                fpy = String.valueOf(fpy) + pylist[j].charAt(0);
                ++j;
            }
            if (!search.Find2(fpy, keyword, pylist, keysCount)) continue;
            result.add(item);
        }
        return result;
    }
}

