/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.util.ArrayList;
import java.util.List;
import toolgood.words.internals.BaseMatch;
import toolgood.words.internals.TrieNode3;

public class StringMatch
extends BaseMatch {
    public String FindFirst(String text) {
        TrieNode3 ptr = null;
        int i = 0;
        while (i < text.length()) {
            int length;
            int s;
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                String result;
                if (ptr.HasWildcard && (result = this.FindFirst(text, i + 1, ptr.WildcardNode)) != null) {
                    return result;
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End && (s = i - (length = this._keywordLength[tn.Results.get(0)]) + 1) >= 0) {
                return text.substring(s, i + 1);
            }
            ptr = tn;
            ++i;
        }
        return null;
    }

    private String FindFirst(String text, int index, TrieNode3 ptr) {
        int i = index;
        while (i < text.length()) {
            int length;
            int s;
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                String result;
                if (ptr.HasWildcard && (result = this.FindFirst(text, i + 1, ptr.WildcardNode)) != null) {
                    return result;
                }
                return null;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End && (s = i - (length = this._keywordLength[tn.Results.get(0)]) + 1) >= 0) {
                return text.substring(s, i + 1);
            }
            ptr = tn;
            ++i;
        }
        return null;
    }

    public List<String> FindAll(String text) {
        TrieNode3 ptr = null;
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < text.length()) {
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.FindAll(text, i + 1, ptr.WildcardNode, result);
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End) {
                for (Integer item : tn.Results) {
                    int length = this._keywordLength[item];
                    int s = i - length + 1;
                    if (s < 0) continue;
                    String key = text.substring(s, i + 1);
                    result.add(key);
                }
            }
            ptr = tn;
            ++i;
        }
        return result;
    }

    private void FindAll(String text, int index, TrieNode3 ptr, List<String> result) {
        int i = index;
        while (i < text.length()) {
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.FindAll(text, i + 1, ptr.WildcardNode, result);
                }
                return;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End) {
                for (Integer item : tn.Results) {
                    int length = this._keywordLength[item];
                    int s = i - length + 1;
                    if (s < 0) continue;
                    String key = text.substring(s, i + 1);
                    result.add(key);
                }
            }
            ptr = tn;
            ++i;
        }
    }

    public boolean ContainsAny(String text) {
        TrieNode3 ptr = null;
        int i = 0;
        while (i < text.length()) {
            int length;
            int s;
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                boolean result;
                if (ptr.HasWildcard && (result = this.ContainsAny(text, i + 1, ptr.WildcardNode))) {
                    return true;
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End && (s = i - (length = this._keywordLength[tn.Results.get(0)]) + 1) >= 0) {
                return true;
            }
            ptr = tn;
            ++i;
        }
        return false;
    }

    private boolean ContainsAny(String text, int index, TrieNode3 ptr) {
        int i = index;
        while (i < text.length()) {
            int length;
            int s;
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    return this.ContainsAny(text, i + 1, ptr.WildcardNode);
                }
                return false;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End && (s = i - (length = this._keywordLength[tn.Results.get(0)]) + 1) >= 0) {
                return true;
            }
            ptr = tn;
            ++i;
        }
        return false;
    }

    public String Replace(String text) {
        return this.Replace(text, '*');
    }

    public String Replace(String text, char replaceChar) {
        StringBuilder result = new StringBuilder(text);
        TrieNode3 ptr = null;
        int i = 0;
        while (i < text.length()) {
            int maxLength;
            int start;
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.Replace(text, i + 1, ptr.WildcardNode, replaceChar, result);
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End && (start = i + 1 - (maxLength = this._keywordLength[tn.Results.get(0)])) >= 0) {
                int j = start;
                while (j <= i) {
                    result.setCharAt(j, replaceChar);
                    ++j;
                }
            }
            ptr = tn;
            ++i;
        }
        return result.toString();
    }

    private void Replace(String text, int index, TrieNode3 ptr, char replaceChar, StringBuilder result) {
        int i = index;
        while (i < text.length()) {
            int maxLength;
            int start;
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.Replace(text, i + 1, ptr.WildcardNode, replaceChar, result);
                }
                return;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End && (start = i + 1 - (maxLength = this._keywordLength[tn.Results.get(0)])) >= 0) {
                int j = start;
                while (j <= i) {
                    result.setCharAt(j, replaceChar);
                    ++j;
                }
            }
            ptr = tn;
            ++i;
        }
    }
}

