/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import toolgood.words.WordsSearchResult;
import toolgood.words.internals.BaseSearch;
import toolgood.words.internals.TrieNode2;

public class WordsSearch
extends BaseSearch {
    public String[] _others;

    public WordsSearchResult FindFirst(String text) {
        TrieNode2 ptr = null;
        int i = 0;
        while (i < text.length()) {
            Iterator<Integer> iterator;
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End && (iterator = tn.Results.iterator()).hasNext()) {
                Integer index = iterator.next();
                String key = this._keywords[index];
                return new WordsSearchResult(key, i + 1 - key.length(), i, index);
            }
            ptr = tn;
            ++i;
        }
        return null;
    }

    public List<WordsSearchResult> FindAll(String text) {
        TrieNode2 ptr = null;
        ArrayList<WordsSearchResult> list = new ArrayList<WordsSearchResult>();
        int i = 0;
        while (i < text.length()) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                for (Integer index : tn.Results) {
                    String key = this._keywords[index];
                    WordsSearchResult item = new WordsSearchResult(key, i + 1 - key.length(), i, index);
                    list.add(item);
                }
            }
            ptr = tn;
            ++i;
        }
        return list;
    }

    public boolean ContainsAny(String text) {
        TrieNode2 ptr = null;
        int i = 0;
        while (i < text.length()) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                return true;
            }
            ptr = tn;
            ++i;
        }
        return false;
    }

    public String Replace(String text) {
        return this.Replace(text, '*');
    }

    public String Replace(String text, char replaceChar) {
        StringBuilder result = new StringBuilder(text);
        TrieNode2 ptr = null;
        int i = 0;
        while (i < text.length()) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                int start;
                int maxLength = this._keywords[tn.Results.get(0)].length();
                int j = start = i + 1 - maxLength;
                while (j <= i) {
                    result.setCharAt(j, replaceChar);
                    ++j;
                }
            }
            ptr = tn;
            ++i;
        }
        return result.toString();
    }
}

