/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import toolgood.words.internals.TrieNode;
import toolgood.words.internals.TrieNode3;

public class BaseMatch {
    protected TrieNode3[] _first;
    protected int[] _keywordLength;
    protected int[] _keywordIndex;
    protected String[] _matchKeywords;

    protected List<TrieNode> BuildFirstLayerTrieNode(List<String> keywords) {
        int start;
        TrieNode root = new TrieNode();
        Hashtable allNodeLayers = new Hashtable();
        int i = 0;
        while (i < keywords.size()) {
            String p = keywords.get(i);
            TrieNode nd = root;
            start = 0;
            while (p.charAt(start) == '\u0000') {
                ++start;
            }
            int j = start;
            while (j < p.length()) {
                nd = nd.Add(Character.valueOf(p.charAt(j)));
                if (nd.Layer == 0) {
                    nd.Layer = j + 1 - start;
                    if (!allNodeLayers.containsKey(nd.Layer)) {
                        ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                        nodes.add(nd);
                        allNodeLayers.put(nd.Layer, nodes);
                    } else {
                        ((List)allNodeLayers.get(nd.Layer)).add(nd);
                    }
                }
                ++j;
            }
            nd.SetResults(i);
            ++i;
        }
        Character z = Character.valueOf('\u0000');
        int i2 = 0;
        while (i2 < keywords.size()) {
            String p = keywords.get(i2);
            if (p.contains(z.toString())) {
                Object newTrieNodes;
                start = 0;
                while (p.charAt(start) == '\u0000') {
                    ++start;
                }
                Object trieNodes = new ArrayList<TrieNode>();
                trieNodes.add(root);
                int j = start;
                while (j < p.length()) {
                    TrieNode nd;
                    Iterator iterator;
                    newTrieNodes = new ArrayList();
                    Character c = Character.valueOf(p.charAt(j));
                    if (c.charValue() == '\u0000') {
                        iterator = trieNodes.iterator();
                        while (iterator.hasNext()) {
                            nd = (TrieNode)iterator.next();
                            for (Character key : nd.m_values.keySet()) {
                                newTrieNodes.add(nd.m_values.get(key));
                            }
                        }
                    } else {
                        iterator = trieNodes.iterator();
                        while (iterator.hasNext()) {
                            nd = (TrieNode)iterator.next();
                            TrieNode nd2 = nd.Add(c);
                            if (nd2.Layer == 0) {
                                nd2.Layer = j + 1 - start;
                                if (!allNodeLayers.containsKey(nd2.Layer)) {
                                    ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                                    nodes.add(nd2);
                                    allNodeLayers.put(nd2.Layer, nodes);
                                } else {
                                    ((List)allNodeLayers.get(nd2.Layer)).add(nd2);
                                }
                            }
                            newTrieNodes.add(nd2);
                        }
                    }
                    trieNodes = newTrieNodes;
                    ++j;
                }
                newTrieNodes = trieNodes.iterator();
                while (newTrieNodes.hasNext()) {
                    TrieNode nd = (TrieNode)newTrieNodes.next();
                    nd.SetResults(i2);
                }
            }
            ++i2;
        }
        ArrayList<TrieNode> allNode = new ArrayList<TrieNode>();
        allNode.add(root);
        int i3 = 0;
        while (i3 < allNodeLayers.size()) {
            List nodes = (List)allNodeLayers.get(i3 + 1);
            int j = 0;
            while (j < nodes.size()) {
                allNode.add((TrieNode)nodes.get(j));
                ++j;
            }
            ++i3;
        }
        allNodeLayers.clear();
        allNodeLayers = null;
        i3 = 1;
        while (i3 < allNode.size()) {
            TrieNode nd = (TrieNode)allNode.get(i3);
            nd.Index = i3;
            TrieNode r = nd.Parent.Failure;
            char c = nd.Char;
            while (r != null && !r.m_values.containsKey(Character.valueOf(c))) {
                r = r.Failure;
            }
            if (r == null) {
                nd.Failure = root;
            } else {
                nd.Failure = r.m_values.get(Character.valueOf(c));
                for (Integer result : nd.Failure.Results) {
                    nd.SetResults(result);
                }
            }
            ++i3;
        }
        Character zore = Character.valueOf('\u0000');
        int i4 = 1;
        while (i4 < allNode.size()) {
            TrieNode nd = (TrieNode)allNode.get(i4);
            if (nd.Layer != 1) {
                if (nd.m_values.containsKey(zore)) {
                    nd.HasWildcard = true;
                }
                if (nd.Failure.HasWildcard) {
                    nd.HasWildcard = true;
                }
                if (nd.Char == '\u0000') {
                    nd.IsWildcard = true;
                } else if (nd.Parent.IsWildcard) {
                    nd.IsWildcard = true;
                    nd.WildcardLayer = nd.Parent.WildcardLayer + 1;
                    if (nd.Failure != root && nd.Failure.Layer <= nd.WildcardLayer) {
                        nd.Failure = root;
                    }
                }
            }
            ++i4;
        }
        root.Failure = root;
        return allNode;
    }

    protected boolean HasMatch(String keyword) {
        int i = 0;
        while (i < keyword.length()) {
            Character c = Character.valueOf(keyword.charAt(i));
            if (c.charValue() == '.' || c.charValue() == '?' || c.charValue() == '\\' || c.charValue() == '[' || c.charValue() == '(') {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected List<String> MatchKeywordBuild(String keyword) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Hashtable<Integer, List<String>> parameterDict = new Hashtable<Integer, List<String>>();
        this.SeparateParameters(keyword, stringBuilder, parameterDict);
        if (parameterDict.size() == 0) {
            ArrayList<String> al = new ArrayList<String>();
            al.add(stringBuilder.toString());
            return al;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        BaseMatch.KeywordBuild(parameterDict, 0, parameterDict.keySet().size() - 1, "", parameters);
        String keywordFmt = stringBuilder.toString();
        ArrayList<String> list = new ArrayList<String>();
        String z = Character.valueOf('\u0000').toString();
        int i = 0;
        while (i < parameters.size()) {
            String item = (String)parameters.get(i);
            String[] items = item.split(z);
            Object[] ls = new Object[items.length];
            int j = 0;
            while (j < ls.length) {
                ls[j] = items[j];
                ++j;
            }
            String t = String.format(keywordFmt, ls);
            if (!list.contains(t)) {
                list.add(t);
            }
            ++i;
        }
        return list;
    }

    private void SeparateParameters(String keyword, StringBuilder stringBuilder, Map<Integer, List<String>> parameterDict) throws Exception {
        int index = 0;
        int parameterIndex = 0;
        Character zore = Character.valueOf('\u0000');
        while (index < keyword.length()) {
            ArrayList<String> ps;
            ArrayList<String> lt;
            Character c = Character.valueOf(keyword.charAt(index));
            if (c.charValue() == '.') {
                if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                    lt = new ArrayList<String>();
                    lt.add("");
                    lt.add(zore.toString());
                    parameterDict.put(parameterIndex, lt);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 2;
                    continue;
                }
                stringBuilder.append('\u0000');
                ++index;
                continue;
            }
            if (c.charValue() == '\\') {
                if (index + 2 < keyword.length() && keyword.charAt(index + 2) == '?') {
                    lt = new ArrayList();
                    lt.add("");
                    lt.add(Character.valueOf(keyword.charAt(index + 1)).toString());
                    parameterDict.put(parameterIndex, lt);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 3;
                    continue;
                }
                if (index + 1 < keyword.length()) {
                    stringBuilder.append(keyword.charAt(index + 1));
                    index += 2;
                    continue;
                }
                throw new Exception("\u3010{keyword}\u3011\u51fa\u9519\u4e86\uff0c\u6700\u540e\u4e00\u4f4d\u4e3a\\");
            }
            if (c.charValue() == '[') {
                ++index;
                ps = new ArrayList<String>();
                while (index < keyword.length()) {
                    c = Character.valueOf(keyword.charAt(index));
                    if (c.charValue() == ']') break;
                    if (c.charValue() == '\\') {
                        if (index + 1 >= keyword.length()) continue;
                        ps.add(Character.valueOf(keyword.charAt(index + 1)).toString());
                        index += 2;
                        continue;
                    }
                    ps.add(c.toString());
                    ++index;
                }
                if (c.charValue() != ']') {
                    throw new Exception("\u3010{keyword}\u3011\u51fa\u9519\u4e86\uff0c\u6700\u540e\u4e00\u4f4d\u4e0d\u4e3a]");
                }
                if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                    ps.add("");
                    parameterDict.put(parameterIndex, ps);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 2;
                    continue;
                }
                parameterDict.put(parameterIndex, ps);
                stringBuilder.append("%" + parameterIndex + "$s");
                ++parameterIndex;
                ++index;
                continue;
            }
            if (c.charValue() == '(') {
                ++index;
                ps = new ArrayList();
                String words = "";
                while (index < keyword.length()) {
                    c = Character.valueOf(keyword.charAt(index));
                    if (c.charValue() == ')') break;
                    if (c.charValue() == '|') {
                        ps.add(words);
                        words = "";
                        ++index;
                        continue;
                    }
                    if (c.charValue() == '\\') {
                        if (index + 1 >= keyword.length()) continue;
                        words = String.valueOf(words) + keyword.charAt(index + 1);
                        index += 2;
                        continue;
                    }
                    words = String.valueOf(words) + c;
                    ++index;
                }
                ps.add(words);
                if (c.charValue() != ')') {
                    throw new Exception("\u3010{keyword}\u3011\u51fa\u9519\u4e86\uff0c\u6700\u540e\u4e00\u4f4d\u4e0d\u4e3a)");
                }
                if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                    ps.add("");
                    parameterDict.put(parameterIndex, ps);
                    stringBuilder.append("%" + parameterIndex + "$s");
                    ++parameterIndex;
                    index += 2;
                    continue;
                }
                parameterDict.put(parameterIndex, ps);
                stringBuilder.append("%" + parameterIndex + "$s");
                ++parameterIndex;
                ++index;
                continue;
            }
            if (index + 1 < keyword.length() && keyword.charAt(index + 1) == '?') {
                lt = new ArrayList();
                lt.add("");
                lt.add(c.toString());
                parameterDict.put(parameterIndex, lt);
                stringBuilder.append("%" + parameterIndex + "$s");
                ++parameterIndex;
                index += 2;
                continue;
            }
            if (c.charValue() == '{') {
                stringBuilder.append("{{");
            } else if (c.charValue() == '}') {
                stringBuilder.append("}}");
            } else {
                stringBuilder.append(c);
            }
            ++index;
        }
    }

    private static void KeywordBuild(Map<Integer, List<String>> parameterDict, int index, int end, String keyword, List<String> result) {
        Character span = Character.valueOf('\u0001');
        List<String> list = parameterDict.get(index);
        if (index == end) {
            int i = 0;
            while (i < list.size()) {
                String item = list.get(i);
                result.add((String.valueOf(keyword) + span + item).substring(1));
                ++i;
            }
        } else {
            int i = 0;
            while (i < list.size()) {
                String item = list.get(i);
                BaseMatch.KeywordBuild(parameterDict, index + 1, end, String.valueOf(keyword) + span + item, result);
                ++i;
            }
        }
    }

    public void SetKeywords(List<String> keywords) throws Exception {
        this._matchKeywords = keywords.toArray(new String[0]);
        ArrayList<String> newKeyword = new ArrayList<String>();
        ArrayList<Integer> newKeywordLength = new ArrayList<Integer>();
        ArrayList<Integer> newKeywordIndex = new ArrayList<Integer>();
        Integer index = 0;
        for (String keyword : keywords) {
            if (!this.HasMatch(keyword)) {
                newKeyword.add(keyword);
                newKeywordLength.add(keyword.length());
                newKeywordIndex.add(index);
            } else {
                List<String> list = this.MatchKeywordBuild(keyword);
                for (String item : list) {
                    newKeyword.add(item);
                    newKeywordLength.add(item.length());
                    newKeywordIndex.add(index);
                }
            }
            index = index + 1;
        }
        this._keywordLength = new int[newKeywordLength.size()];
        int i = 0;
        while (i < this._keywordLength.length) {
            this._keywordLength[i] = (Integer)newKeywordLength.get(i);
            ++i;
        }
        this._keywordIndex = new int[newKeywordIndex.size()];
        int j = 0;
        while (j < this._keywordIndex.length) {
            this._keywordIndex[j] = (Integer)newKeywordIndex.get(j);
            ++j;
        }
        this.SetKeywords2(newKeyword);
    }

    protected void SetKeywords2(List<String> keywords) {
        List<TrieNode> allNode = this.BuildFirstLayerTrieNode(keywords);
        TrieNode root = allNode.get(0);
        ArrayList<TrieNode3> allNode2 = new ArrayList<TrieNode3>();
        int i = 0;
        while (i < allNode.size()) {
            allNode2.add(new TrieNode3());
            ++i;
        }
        i = 0;
        while (i < allNode2.size()) {
            TrieNode oldNode = allNode.get(i);
            TrieNode3 newNode = (TrieNode3)allNode2.get(i);
            for (Character key : oldNode.m_values.keySet()) {
                int index = oldNode.m_values.get((Object)key).Index;
                if (key.charValue() == '\u0000') {
                    newNode.HasWildcard = true;
                    newNode.WildcardNode = (TrieNode3)allNode2.get(index);
                    continue;
                }
                newNode.Add(key.charValue(), (TrieNode3)allNode2.get(index));
            }
            for (Integer item : oldNode.Results) {
                if (oldNode.IsWildcard) {
                    if (keywords.get(item).length() <= oldNode.WildcardLayer) continue;
                    newNode.SetResults(item);
                    continue;
                }
                newNode.SetResults(item);
            }
            TrieNode failure = oldNode.Failure;
            while (failure != root) {
                if (oldNode.IsWildcard && failure.Layer <= oldNode.WildcardLayer) break;
                for (Character key : failure.m_values.keySet()) {
                    int index = failure.m_values.get((Object)key).Index;
                    if (key.charValue() == '\u0000') {
                        newNode.HasWildcard = true;
                        if (newNode.WildcardNode != null) continue;
                        newNode.WildcardNode = (TrieNode3)allNode2.get(index);
                        continue;
                    }
                    if (newNode.HasKey(key.charValue())) continue;
                    newNode.Add(key.charValue(), (TrieNode3)allNode2.get(index));
                }
                for (Integer item : failure.Results) {
                    if (oldNode.IsWildcard) {
                        if (keywords.get(item).length() <= oldNode.WildcardLayer) continue;
                        newNode.SetResults(item);
                        continue;
                    }
                    newNode.SetResults(item);
                }
                failure = failure.Failure;
            }
            ++i;
        }
        allNode.clear();
        allNode = null;
        root = null;
        TrieNode3[] first = new TrieNode3[65536];
        for (Character key : ((TrieNode3)allNode2.get((int)0)).m_values.keySet()) {
            first[key.charValue()] = ((TrieNode3)allNode2.get((int)0)).m_values.get(key);
        }
        this._first = first;
    }
}

