/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import toolgood.words.WordsSearch;
import toolgood.words.WordsSearchResult;
import toolgood.words.internals.BaseSearch;
import toolgood.words.internals.PinyinDict;
import toolgood.words.internals.TrieNode2;
import toolgood.words.internals.TwoTuple;

public class BasePinyinMatch {
    private static WordsSearch _wordsSearch;

    protected void MergeKeywords(String[] keys, int id, String keyword, List<TwoTuple<String, String[]>> list) throws NumberFormatException, IOException {
        if (id >= keys.length) {
            TwoTuple<String, String[]> tuple = new TwoTuple<String, String[]>(keyword, keys);
            list.add(tuple);
            return;
        }
        String key = keys[id];
        if (key.charAt(0) >= '\u3400' && key.charAt(0) <= '\u9fd5') {
            List<String> all = PinyinDict.GetAllPinyin(Character.valueOf(key.charAt(0)), 0);
            HashSet<Character> fpy = new HashSet<Character>();
            for (String string : all) {
                fpy.add(Character.valueOf(string.charAt(0)));
            }
            for (Character c : fpy) {
                this.MergeKeywords(keys, id + 1, String.valueOf(keyword) + c, list);
            }
        } else {
            this.MergeKeywords(keys, id + 1, String.valueOf(keyword) + key.charAt(0), list);
        }
    }

    protected void MergeKeywords(String[] keys, int id, String keyword, List<TwoTuple<String, String[]>> list, int index, List<Integer> indexs) throws NumberFormatException, IOException {
        if (id >= keys.length) {
            TwoTuple<String, String[]> tuple = new TwoTuple<String, String[]>(keyword, keys);
            list.add(tuple);
            indexs.add(index);
            return;
        }
        String key = keys[id];
        if (key.charAt(0) >= '\u3400' && key.charAt(0) <= '\u9fd5') {
            List<String> all = PinyinDict.GetAllPinyin(Character.valueOf(key.charAt(0)), 0);
            HashSet<Character> fpy = new HashSet<Character>();
            for (String string : all) {
                fpy.add(Character.valueOf(string.charAt(0)));
            }
            for (Character c : fpy) {
                this.MergeKeywords(keys, id + 1, String.valueOf(keyword) + c, list, index, indexs);
            }
        } else {
            this.MergeKeywords(keys, id + 1, String.valueOf(keyword) + key.charAt(0), list, index, indexs);
        }
    }

    protected List<String> SplitKeywords(String key) throws NumberFormatException, IOException {
        this.InitPinyinSearch();
        ArrayList<TextNode> textNodes = new ArrayList<TextNode>();
        int i = 0;
        while (i <= key.length()) {
            textNodes.add(new TextNode());
            ++i;
        }
        ((TextNode)textNodes.get((int)(textNodes.size() - 1))).End = true;
        i = 0;
        while (i < key.length()) {
            TextLine line = new TextLine();
            line.Next = (TextNode)textNodes.get(i + 1);
            line.Words = Character.valueOf(key.charAt(i)).toString();
            ((TextNode)textNodes.get((int)i)).Children.add(line);
            ++i;
        }
        List<WordsSearchResult> all = _wordsSearch.FindAll(key);
        for (WordsSearchResult searchResult : all) {
            TextLine line = new TextLine();
            line.Next = (TextNode)textNodes.get(searchResult.End + 1);
            line.Words = searchResult.Keyword;
            ((TextNode)textNodes.get((int)searchResult.Start)).Children.add(line);
        }
        ArrayList<String> list = new ArrayList<String>();
        this.BuildKsywords((TextNode)textNodes.get(0), 0, "", list);
        return list;
    }

    private void BuildKsywords(TextNode textNode, int id, String keywords, List<String> list) {
        if (textNode.End) {
            String k = keywords.substring(1);
            if (!list.contains(k)) {
                list.add(k);
            }
            return;
        }
        for (TextLine item : textNode.Children) {
            this.BuildKsywords(item.Next, id + 1, String.valueOf(keywords) + '\u0000' + item.Words, list);
        }
    }

    private void InitPinyinSearch() throws NumberFormatException, IOException {
        if (_wordsSearch == null) {
            ArrayList<String> allPinyins = new ArrayList<String>();
            String[] pys = PinyinDict.getPyShow();
            int i = 1;
            while (i < pys.length) {
                String py = pys[i].toUpperCase();
                int j = 1;
                while (j <= py.length()) {
                    String key = py.substring(0, j);
                    if (!allPinyins.contains(key)) {
                        allPinyins.add(key);
                    }
                    ++j;
                }
                i += 2;
            }
            WordsSearch wordsSearch = new WordsSearch();
            wordsSearch.SetKeywords(allPinyins);
            _wordsSearch = wordsSearch;
        }
    }

    public class PinyinSearch
    extends BaseSearch {
        String[][] _keywordPinyins;
        int[] _indexs;

        public void SetIndexs(int[] indexs) {
            this._indexs = indexs;
        }

        public void SetIndexs(List<Integer> indexs) {
            this._indexs = new int[indexs.size()];
            int i = 0;
            while (i < indexs.size()) {
                this._indexs[i] = indexs.get(i);
                ++i;
            }
        }

        public void SetKeywords2(List<TwoTuple<String, String[]>> keywords) {
            this._keywords = new String[keywords.size()];
            this._keywordPinyins = new String[keywords.size()][];
            int i = 0;
            while (i < keywords.size()) {
                this._keywords[i] = (String)keywords.get((int)i).Item1;
                this._keywordPinyins[i] = (String[])keywords.get((int)i).Item2;
                ++i;
            }
            this.SetKeywords();
        }

        public boolean Find(String text, String hz, String[] pinyins) {
            TrieNode2 ptr = null;
            int i = 0;
            while (i < text.length()) {
                Character t = Character.valueOf(text.charAt(i));
                TrieNode2 tn = ptr == null ? this._first[t.charValue()] : (!ptr.HasKey(t.charValue()) ? this._first[t.charValue()] : ptr.GetValue(t.charValue()));
                if (tn != null && tn.End) {
                    for (int result : tn.Results) {
                        String keyword = this._keywords[result];
                        int start = i + 1 - keyword.length();
                        boolean isok = true;
                        String[] keywordPinyins = this._keywordPinyins[result];
                        int j = 0;
                        while (j < keyword.length()) {
                            int idx = start + j;
                            String py = keywordPinyins[j];
                            if (py.length() == 1 && py.charAt(0) >= '\u3400' && py.charAt(0) <= '\u9fd5') {
                                if (hz.charAt(idx) != py.charAt(0)) {
                                    isok = false;
                                    break;
                                }
                            } else if (!pinyins[idx].startsWith(py)) {
                                isok = false;
                                break;
                            }
                            ++j;
                        }
                        if (!isok) continue;
                        return true;
                    }
                }
                ptr = tn;
                ++i;
            }
            return false;
        }

        public boolean Find2(String text, String hz, String[] pinyins, int keysCount) {
            int findCount = 0;
            int lastWordsIndex = -1;
            TrieNode2 ptr = null;
            int i = 0;
            while (i < text.length()) {
                Character t = Character.valueOf(text.charAt(i));
                TrieNode2 tn = ptr == null ? this._first[t.charValue()] : (!ptr.HasKey(t.charValue()) ? this._first[t.charValue()] : ptr.GetValue(t.charValue()));
                if (tn != null && tn.End) {
                    for (Integer result : tn.Results) {
                        String keyword;
                        int start;
                        int index = this._indexs[result];
                        if (index != findCount || lastWordsIndex >= (start = i + 1 - (keyword = this._keywords[result]).length())) continue;
                        boolean isok = true;
                        String[] keywordPinyins = this._keywordPinyins[result];
                        int j = 0;
                        while (j < keyword.length()) {
                            int idx = start + j;
                            String py = keywordPinyins[j];
                            if (py.length() == 1 && py.charAt(0) >= '\u3400' && py.charAt(0) <= '\u9fd5') {
                                if (hz.charAt(idx) != py.charAt(0)) {
                                    isok = false;
                                    break;
                                }
                            } else if (!pinyins[idx].startsWith(py)) {
                                isok = false;
                                break;
                            }
                            ++j;
                        }
                        if (!isok) continue;
                        lastWordsIndex = i;
                        if (++findCount != keysCount) break;
                        return true;
                    }
                }
                ptr = tn;
                ++i;
            }
            return false;
        }
    }

    class TextLine {
        public String Words;
        public TextNode Next;

        TextLine() {
        }
    }

    class TextNode {
        public boolean End;
        public List<TextLine> Children = new ArrayList<TextLine>();

        TextNode() {
        }
    }
}

