/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import toolgood.words.NumHelper;
import toolgood.words.internals.IntDictionary;
import toolgood.words.internals.TrieNode;
import toolgood.words.internals.TrieNode2Ex;

public class BaseSearchEx {
    protected int[] _dict;
    protected int[] _first;
    protected int[] _min;
    protected int[] _max;
    protected IntDictionary[] _nextIndex;
    protected int[] _end;
    protected int[] _resultIndex;
    protected String[] _keywords;

    public void Save(String filePath) throws IOException {
        File fi = new File(filePath);
        FileOutputStream fs = new FileOutputStream(fi);
        this.Save(fs);
        fs.close();
    }

    protected void Save(FileOutputStream bw) throws IOException {
        bw.write(NumHelper.serialize(this._keywords.length));
        Object[] objectArray = this._keywords;
        int n = this._keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            byte[] bytes = item.getBytes("utf-8");
            bw.write(NumHelper.serialize(bytes.length));
            bw.write(bytes);
            ++n2;
        }
        bw.write(NumHelper.serialize(this._dict.length));
        objectArray = this._dict;
        n = this._dict.length;
        n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._first.length));
        objectArray = this._first;
        n = this._first.length;
        n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._min.length));
        objectArray = this._min;
        n = this._min.length;
        n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._max.length));
        objectArray = this._max;
        n = this._max.length;
        n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._end.length));
        objectArray = this._end;
        n = this._end.length;
        n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._resultIndex.length));
        objectArray = this._resultIndex;
        n = this._resultIndex.length;
        n2 = 0;
        while (n2 < n) {
            String item = objectArray[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._nextIndex.length));
        int i = 0;
        while (i < this._nextIndex.length) {
            int[] keys = this._nextIndex[i].getKeys();
            bw.write(NumHelper.serialize(keys.length));
            int[] nArray = keys;
            int n3 = keys.length;
            int n4 = 0;
            while (n4 < n3) {
                int item = nArray[n4];
                bw.write(NumHelper.serialize(item));
                ++n4;
            }
            int[] values = this._nextIndex[i].getValues();
            bw.write(NumHelper.serialize(values.length));
            int[] nArray2 = values;
            int n5 = values.length;
            n3 = 0;
            while (n3 < n5) {
                int item = nArray2[n3];
                bw.write(NumHelper.serialize(item));
                ++n3;
            }
            ++i;
        }
    }

    public void Load(String filePath) throws FileNotFoundException, IOException {
        File fi = new File(filePath);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fi));
        this.Load(in);
        ((InputStream)in).close();
    }

    public void Load(InputStream br) throws IOException {
        int length = NumHelper.read(br);
        this._keywords = new String[length];
        int i = 0;
        while (i < length) {
            int l = NumHelper.read(br);
            byte[] bytes = new byte[l];
            br.read(bytes, 0, l);
            this._keywords[i] = new String(bytes, "utf-8");
            ++i;
        }
        length = NumHelper.read(br);
        this._dict = new int[length];
        i = 0;
        while (i < length) {
            this._dict[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._first = new int[length];
        i = 0;
        while (i < length) {
            this._first[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._min = new int[length];
        i = 0;
        while (i < length) {
            this._min[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._max = new int[length];
        i = 0;
        while (i < length) {
            this._max[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._end = new int[length];
        i = 0;
        while (i < length) {
            this._end[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._resultIndex = new int[length];
        i = 0;
        while (i < length) {
            this._resultIndex[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._nextIndex = new IntDictionary[length];
        i = 0;
        while (i < length) {
            int l2 = NumHelper.read(br);
            int[] keys = new int[l2];
            int j = 0;
            while (j < keys.length) {
                keys[j] = NumHelper.read(br);
                ++j;
            }
            l2 = NumHelper.read(br);
            int[] values = new int[l2];
            int j2 = 0;
            while (j2 < values.length) {
                values[j2] = NumHelper.read(br);
                ++j2;
            }
            this._nextIndex[i] = new IntDictionary();
            this._nextIndex[i].SetDictionary(keys, values);
            ++i;
        }
    }

    public void SetKeywords(List<String> keywords) {
        this._keywords = keywords.toArray(new String[0]);
        this.SetKeywords();
    }

    private void SetKeywords() {
        int j;
        TrieNode nd;
        TrieNode root = new TrieNode();
        Hashtable allNodeLayers = new Hashtable();
        int i = 0;
        while (i < this._keywords.length) {
            String p = this._keywords[i];
            nd = root;
            j = 0;
            while (j < p.length()) {
                nd = nd.Add(Character.valueOf(p.charAt(j)));
                if (nd.Layer == 0) {
                    nd.Layer = j + 1;
                    if (!allNodeLayers.containsKey(nd.Layer)) {
                        ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                        nodes.add(nd);
                        allNodeLayers.put(nd.Layer, nodes);
                    } else {
                        ((List)allNodeLayers.get(nd.Layer)).add(nd);
                    }
                }
                ++j;
            }
            nd.SetResults(i);
            ++i;
        }
        ArrayList<TrieNode> allNode = new ArrayList<TrieNode>();
        allNode.add(root);
        int i2 = 0;
        while (i2 < allNodeLayers.size()) {
            List nodes = (List)allNodeLayers.get(i2 + 1);
            j = 0;
            while (j < nodes.size()) {
                allNode.add((TrieNode)nodes.get(j));
                ++j;
            }
            ++i2;
        }
        allNodeLayers.clear();
        allNodeLayers = null;
        i2 = 1;
        while (i2 < allNode.size()) {
            nd = (TrieNode)allNode.get(i2);
            nd.Index = i2;
            TrieNode r = nd.Parent.Failure;
            Character c = Character.valueOf(nd.Char);
            while (r != null && !r.m_values.containsKey(c)) {
                r = r.Failure;
            }
            if (r == null) {
                nd.Failure = root;
            } else {
                nd.Failure = r.m_values.get(c);
                for (Integer result : nd.Failure.Results) {
                    nd.SetResults(result);
                }
            }
            ++i2;
        }
        root.Failure = root;
        StringBuilder stringBuilder = new StringBuilder();
        int i3 = 1;
        while (i3 < allNode.size()) {
            stringBuilder.append(((TrieNode)allNode.get((int)i3)).Char);
            ++i3;
        }
        this.CreateDict(stringBuilder.toString());
        stringBuilder = null;
        ArrayList<TrieNode2Ex> allNode2 = new ArrayList<TrieNode2Ex>();
        int i4 = 0;
        while (i4 < allNode.size()) {
            TrieNode2Ex nd2 = new TrieNode2Ex();
            nd2.Index = i4++;
            allNode2.add(nd2);
        }
        i4 = 0;
        while (i4 < allNode2.size()) {
            TrieNode nd3;
            TrieNode oldNode = (TrieNode)allNode.get(i4);
            TrieNode2Ex newNode = (TrieNode2Ex)allNode2.get(i4);
            for (Character key : oldNode.m_values.keySet()) {
                nd3 = oldNode.m_values.get(key);
                newNode.Add(this._dict[key.charValue()], (TrieNode2Ex)allNode2.get(nd3.Index));
            }
            oldNode.Results.forEach(item -> newNode.SetResults((int)item));
            oldNode = oldNode.Failure;
            while (oldNode != root) {
                for (Character key : oldNode.m_values.keySet()) {
                    if (newNode.HasKey(this._dict[key.charValue()])) continue;
                    nd3 = oldNode.m_values.get(key);
                    newNode.Add(this._dict[key.charValue()], (TrieNode2Ex)allNode2.get(nd3.Index));
                }
                oldNode.Results.forEach(item -> newNode.SetResults((int)item));
                oldNode = oldNode.Failure;
            }
            ++i4;
        }
        allNode.clear();
        allNode = null;
        root = null;
        ArrayList<Integer> min = new ArrayList<Integer>();
        ArrayList<Integer> max = new ArrayList<Integer>();
        ArrayList nextIndexs = new ArrayList();
        ArrayList<Integer> end = new ArrayList<Integer>();
        end.add(0);
        ArrayList<Integer> resultIndex = new ArrayList<Integer>();
        int i5 = 0;
        while (i5 < allNode2.size()) {
            HashMap<Integer, Integer> dict = new HashMap<Integer, Integer>();
            TrieNode2Ex node = (TrieNode2Ex)allNode2.get(i5);
            min.add(node.minflag);
            max.add(node.maxflag);
            if (i5 > 0) {
                for (Integer key : node.m_values.keySet()) {
                    dict.put(key, node.m_values.get((Object)key).Index);
                }
            }
            int j2 = 0;
            while (j2 < node.Results.size()) {
                resultIndex.add(node.Results.get(j2));
                ++j2;
            }
            end.add(resultIndex.size());
            nextIndexs.add(dict);
            ++i5;
        }
        int[] first = new int[65536];
        for (Integer key : ((TrieNode2Ex)allNode2.get((int)0)).m_values.keySet()) {
            TrieNode2Ex nd4 = ((TrieNode2Ex)allNode2.get((int)0)).m_values.get(key);
            first[key.intValue()] = nd4.Index;
        }
        this._first = first;
        this._min = new int[min.size()];
        this._max = new int[min.size()];
        int i6 = 0;
        while (i6 < min.size()) {
            this._min[i6] = (Integer)min.get(i6);
            this._max[i6] = (Integer)max.get(i6);
            ++i6;
        }
        this._nextIndex = new IntDictionary[nextIndexs.size()];
        i6 = 0;
        while (i6 < nextIndexs.size()) {
            IntDictionary dictionary = new IntDictionary();
            dictionary.SetDictionary((Map)nextIndexs.get(i6));
            this._nextIndex[i6] = dictionary;
            ++i6;
        }
        this._end = new int[end.size()];
        i6 = 0;
        while (i6 < end.size()) {
            this._end[i6] = (Integer)end.get(i6);
            ++i6;
        }
        this._resultIndex = new int[resultIndex.size()];
        i6 = 0;
        while (i6 < resultIndex.size()) {
            this._resultIndex[i6] = (Integer)resultIndex.get(i6);
            ++i6;
        }
        allNode2.clear();
        allNode2 = null;
    }

    private int CreateDict(String keywords) {
        Hashtable<Character, Integer> dictionary = new Hashtable<Character, Integer>();
        int i = 0;
        while (i < keywords.length()) {
            Character item = Character.valueOf(keywords.charAt(i));
            if (dictionary.containsKey(item)) {
                dictionary.put(item, (Integer)dictionary.get(item) + 1);
            } else {
                dictionary.put(item, 1);
            }
            ++i;
        }
        Map dictionary2 = dictionary.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<Character> list2 = new ArrayList<Character>();
        for (Character item : dictionary2.keySet()) {
            list2.add(item);
        }
        this._dict = new int[65536];
        int i2 = 0;
        while (i2 < list2.size()) {
            this._dict[((Character)list2.get((int)i2)).charValue()] = i2 + 1;
            ++i2;
        }
        return dictionary.size();
    }
}

