/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import toolgood.words.NumHelper;
import toolgood.words.internals.TrieNode;
import toolgood.words.internals.TrieNodeEx;

public abstract class BaseSearchEx2 {
    protected String[] _keywords;
    protected int[][] _guides;
    protected int[] _key;
    protected int[] _next;
    protected int[] _check;
    protected int[] _dict;

    public void Save(String filePath) throws IOException {
        File fi = new File(filePath);
        FileOutputStream fs = new FileOutputStream(fi);
        this.Save(fs);
        fs.close();
    }

    protected void Save(FileOutputStream bw) throws IOException {
        bw.write(NumHelper.serialize(this._keywords.length));
        Object object = this._keywords;
        int n = this._keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String item = object[n2];
            byte[] bytes = item.getBytes("utf-8");
            bw.write(NumHelper.serialize(bytes.length));
            bw.write(bytes);
            ++n2;
        }
        bw.write(NumHelper.serialize(this._guides.length));
        object = this._guides;
        n = this._guides.length;
        n2 = 0;
        while (n2 < n) {
            String guide = object[n2];
            bw.write(NumHelper.serialize(((String)guide).length));
            String string = guide;
            int n3 = ((String)string).length;
            int n4 = 0;
            while (n4 < n3) {
                String item = string[n4];
                bw.write(NumHelper.serialize((int)item));
                ++n4;
            }
            ++n2;
        }
        bw.write(NumHelper.serialize(this._key.length));
        object = this._key;
        n = this._key.length;
        n2 = 0;
        while (n2 < n) {
            String item = object[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._next.length));
        object = this._next;
        n = this._next.length;
        n2 = 0;
        while (n2 < n) {
            String item = object[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._check.length));
        object = this._check;
        n = this._check.length;
        n2 = 0;
        while (n2 < n) {
            String item = object[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
        bw.write(NumHelper.serialize(this._dict.length));
        object = this._dict;
        n = this._dict.length;
        n2 = 0;
        while (n2 < n) {
            String item = object[n2];
            bw.write(NumHelper.serialize((int)item));
            ++n2;
        }
    }

    public void Load(String filePath) throws FileNotFoundException, IOException {
        File fi = new File(filePath);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fi));
        this.Load(in);
        ((InputStream)in).close();
    }

    public void Load(InputStream br) throws IOException {
        int length = NumHelper.read(br);
        this._keywords = new String[length];
        int i = 0;
        while (i < length) {
            int l = NumHelper.read(br);
            byte[] bytes = new byte[l];
            br.read(bytes, 0, l);
            this._keywords[i] = new String(bytes, "utf-8");
            ++i;
        }
        length = NumHelper.read(br);
        this._guides = new int[length][];
        i = 0;
        while (i < length) {
            int length2 = NumHelper.read(br);
            this._guides[i] = new int[length2];
            int j = 0;
            while (j < length2) {
                this._guides[i][j] = NumHelper.read(br);
                ++j;
            }
            ++i;
        }
        length = NumHelper.read(br);
        this._key = new int[length];
        i = 0;
        while (i < length) {
            this._key[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._next = new int[length];
        i = 0;
        while (i < length) {
            this._next[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._check = new int[length];
        i = 0;
        while (i < length) {
            this._check[i] = NumHelper.read(br);
            ++i;
        }
        length = NumHelper.read(br);
        this._dict = new int[length];
        i = 0;
        while (i < length) {
            this._dict[i] = NumHelper.read(br);
            ++i;
        }
    }

    public void SetKeywords(List<String> keywords) {
        this._keywords = keywords.toArray(new String[0]);
        this.SetKeywords();
    }

    private void SetKeywords() {
        int j;
        TrieNode nd;
        TrieNode root = new TrieNode();
        Hashtable allNodeLayers = new Hashtable();
        int i = 0;
        while (i < this._keywords.length) {
            String p = this._keywords[i];
            nd = root;
            j = 0;
            while (j < p.length()) {
                nd = nd.Add(Character.valueOf(p.charAt(j)));
                if (nd.Layer == 0) {
                    nd.Layer = j + 1;
                    if (!allNodeLayers.containsKey(nd.Layer)) {
                        ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                        nodes.add(nd);
                        allNodeLayers.put(nd.Layer, nodes);
                    } else {
                        ((List)allNodeLayers.get(nd.Layer)).add(nd);
                    }
                }
                ++j;
            }
            nd.SetResults(i);
            ++i;
        }
        ArrayList<TrieNode> allNode = new ArrayList<TrieNode>();
        allNode.add(root);
        int i2 = 0;
        while (i2 < allNodeLayers.size()) {
            List nodes = (List)allNodeLayers.get(i2 + 1);
            j = 0;
            while (j < nodes.size()) {
                allNode.add((TrieNode)nodes.get(j));
                ++j;
            }
            ++i2;
        }
        allNodeLayers.clear();
        allNodeLayers = null;
        i2 = 1;
        while (i2 < allNode.size()) {
            nd = (TrieNode)allNode.get(i2);
            nd.Index = i2;
            TrieNode r = nd.Parent.Failure;
            Character c = Character.valueOf(nd.Char);
            while (r != null && !r.m_values.containsKey(c)) {
                r = r.Failure;
            }
            if (r == null) {
                nd.Failure = root;
            } else {
                nd.Failure = r.m_values.get(c);
                for (Integer result : nd.Failure.Results) {
                    nd.SetResults(result);
                }
            }
            ++i2;
        }
        root.Failure = root;
        StringBuilder stringBuilder = new StringBuilder();
        int i3 = 1;
        while (i3 < allNode.size()) {
            stringBuilder.append(((TrieNode)allNode.get((int)i3)).Char);
            ++i3;
        }
        Integer length = this.CreateDict(stringBuilder.toString());
        stringBuilder = null;
        ArrayList<TrieNodeEx> allNode2 = new ArrayList<TrieNodeEx>();
        int i4 = 0;
        while (i4 < allNode.size()) {
            TrieNodeEx nd2 = new TrieNodeEx();
            nd2.Index = i4;
            allNode2.add(nd2);
            ++i4;
        }
        i4 = 0;
        while (i4 < allNode2.size()) {
            TrieNode nd3;
            TrieNode oldNode = (TrieNode)allNode.get(i4);
            TrieNodeEx newNode = (TrieNodeEx)allNode2.get(i4);
            newNode.Char = this._dict[oldNode.Char];
            for (Character key : oldNode.m_values.keySet()) {
                nd3 = oldNode.m_values.get(key);
                newNode.Add(this._dict[key.charValue()], (TrieNodeEx)allNode2.get(nd3.Index));
            }
            oldNode.Results.forEach(item -> newNode.SetResults((Integer)item));
            oldNode = oldNode.Failure;
            while (oldNode != root) {
                for (Character key : oldNode.m_values.keySet()) {
                    if (newNode.HasKey(this._dict[key.charValue()])) continue;
                    nd3 = oldNode.m_values.get(key);
                    newNode.Add(this._dict[key.charValue()], (TrieNodeEx)allNode2.get(nd3.Index));
                }
                oldNode.Results.forEach(item -> newNode.SetResults((Integer)item));
                oldNode = oldNode.Failure;
            }
            ++i4;
        }
        allNode.clear();
        allNode = null;
        root = null;
        this.build(allNode2, length);
    }

    private void build(List<TrieNodeEx> nodes, int length) {
        Integer[] has = new Integer[0xFFFFFF];
        boolean[] seats = new boolean[0xFFFFFF];
        boolean[] seats2 = new boolean[0xFFFFFF];
        Integer start = 1;
        Integer oneStart = 1;
        int i = 0;
        while (i < nodes.size()) {
            TrieNodeEx node = nodes.get(i);
            node.Rank(oneStart, start, seats, seats2, has);
            ++i;
        }
        Integer maxCount = has.length - 1;
        while (has[maxCount] == null) {
            maxCount = maxCount - 1;
        }
        length = maxCount + length + 1;
        this._key = new int[length];
        this._next = new int[length];
        this._check = new int[length];
        ArrayList<Integer[]> guides = new ArrayList<Integer[]>();
        guides.add(new Integer[]{0});
        int i2 = 0;
        while (i2 < length) {
            if (has[i2] != null) {
                TrieNodeEx item = nodes.get(has[i2]);
                this._key[i2] = item.Char;
                this._next[i2] = item.Next;
                if (item.End) {
                    this._check[i2] = guides.size();
                    Integer[] result = item.Results.toArray(new Integer[0]);
                    guides.add(result);
                }
            }
            ++i2;
        }
        this._guides = new int[guides.size()][];
        i2 = 0;
        while (i2 < guides.size()) {
            Integer[] array = (Integer[])guides.get(i2);
            this._guides[i2] = new int[array.length];
            int j = 0;
            while (j < array.length) {
                this._guides[i2][j] = array[j];
                ++j;
            }
            ++i2;
        }
    }

    private int CreateDict(String keywords) {
        Hashtable<Character, Integer> dictionary = new Hashtable<Character, Integer>();
        int i = 0;
        while (i < keywords.length()) {
            Character item = Character.valueOf(keywords.charAt(i));
            if (dictionary.containsKey(item)) {
                dictionary.put(item, (Integer)dictionary.get(item) + 1);
            } else {
                dictionary.put(item, 1);
            }
            ++i;
        }
        Map dictionary2 = dictionary.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<Character> list2 = new ArrayList<Character>();
        for (Character item : dictionary2.keySet()) {
            list2.add(item);
        }
        this._dict = new int[65536];
        int i2 = 0;
        while (i2 < list2.size()) {
            this._dict[((Character)list2.get((int)i2)).charValue()] = i2 + 1;
            ++i2;
        }
        return dictionary.size();
    }
}

