/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolgood.words.WordsSearch;
import toolgood.words.WordsSearchResult;

public class PinyinDict {
    private static Map<String, Integer[]> _pyName;
    private static String[] _pyShow;
    private static Integer[] _pyIndex;
    private static Integer[] _pyData;
    private static Integer[] _wordPyIndex;
    private static Integer[] _wordPy;
    private static WordsSearch _search;
    private static final Object lockObj;

    static {
        lockObj = new Object();
    }

    public static String[] getPyShow() throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        return _pyShow;
    }

    public static String[] GetPinyinList(String text, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        PinyinDict.InitPyWords();
        String[] list = new String[text.length()];
        List<WordsSearchResult> pos = _search.FindAll(text);
        Integer pindex = -1;
        for (WordsSearchResult p : pos) {
            if (p.Start <= pindex) continue;
            int i = 0;
            while (i < p.Keyword.length()) {
                list[i + p.Start] = _pyShow[_wordPy[i + _wordPyIndex[p.Index]] + tone];
                ++i;
            }
            pindex = p.End;
        }
        int i = 0;
        while (i < text.length()) {
            Character c;
            if (list[i] == null && (c = Character.valueOf(text.charAt(i))).charValue() >= '\u3400' && c.charValue() <= '\u9fd5') {
                int index = c.charValue() - 13312;
                int start = _pyIndex[index];
                int end = _pyIndex[index + 1];
                if (end > start) {
                    list[i] = _pyShow[_pyData[start] + tone];
                }
            }
            ++i;
        }
        return list;
    }

    public static String GetPinyin(String text, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        String[] list = PinyinDict.GetPinyinList(text, tone);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            String s = list[i];
            if (s != null) {
                sb.append(list[i]);
            } else {
                sb.append(text.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String GetFirstPinyin(String text, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        String[] list = PinyinDict.GetPinyinList(text, tone);
        StringBuilder sb = new StringBuilder(text);
        int i = 0;
        while (i < list.length) {
            String c = list[i];
            if (c != null) {
                sb.setCharAt(i, c.charAt(0));
            }
            ++i;
        }
        return sb.toString();
    }

    public static List<String> GetAllPinyin(Character c, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        if (c.charValue() >= '\u3400' && c.charValue() <= '\u9fd5') {
            int index = c.charValue() - 13312;
            ArrayList<String> list = new ArrayList<String>();
            int start = _pyIndex[index];
            int end = _pyIndex[index + 1];
            if (end > start) {
                int i = start;
                while (i < end) {
                    String py = _pyShow[_pyData[i] + tone];
                    if (!list.contains(py)) {
                        list.add(py);
                    }
                    ++i;
                }
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public static String GetPinyinFast(Character c, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        if (c.charValue() >= '\u3400' && c.charValue() <= '\u9fd5') {
            int index = c.charValue() - 13312;
            int start = _pyIndex[index];
            int end = _pyIndex[index + 1];
            if (end > start) {
                return _pyShow[_pyData[start] + tone];
            }
        }
        return c.toString();
    }

    public static List<String> GetPinyinForName(String name, int tone) throws NumberFormatException, IOException {
        String[] pys;
        String xing;
        PinyinDict.InitPyName();
        PinyinDict.InitPyIndex();
        ArrayList<String> list = new ArrayList<String>();
        if (name.length() > 1 && _pyName.containsKey(xing = name.substring(0, 2))) {
            Integer[] indexs;
            Integer[] integerArray = indexs = _pyName.get(xing);
            int n = indexs.length;
            int n2 = 0;
            while (n2 < n) {
                Integer index = integerArray[n2];
                list.add(_pyShow[index + tone]);
                ++n2;
            }
            if (name.length() > 2) {
                String[] pys2;
                String ming = name.substring(2);
                String[] stringArray = pys2 = PinyinDict.GetPinyinList(ming, tone);
                int n3 = pys2.length;
                n = 0;
                while (n < n3) {
                    String py = stringArray[n];
                    list.add(py);
                    ++n;
                }
            }
            return list;
        }
        xing = name.substring(0, 1);
        if (_pyName.containsKey(xing)) {
            Integer[] indexs;
            Integer[] integerArray = indexs = _pyName.get(xing);
            int n = indexs.length;
            int py = 0;
            while (py < n) {
                Integer index = integerArray[py];
                list.add(_pyShow[index + tone]);
                ++py;
            }
            if (name.length() > 1) {
                String[] pys3;
                String ming = name.substring(1);
                String[] stringArray = pys3 = PinyinDict.GetPinyinList(ming, tone);
                int n4 = pys3.length;
                n = 0;
                while (n < n4) {
                    String py2 = stringArray[n];
                    list.add(py2);
                    ++n;
                }
            }
            return list;
        }
        String[] stringArray = pys = PinyinDict.GetPinyinList(name, tone);
        int n = pys.length;
        int n5 = 0;
        while (n5 < n) {
            String py = stringArray[n5];
            list.add(py);
            ++n5;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitPyIndex() throws NumberFormatException, IOException {
        if (_pyIndex == null) {
            Object object = lockObj;
            synchronized (object) {
                if (_pyIndex == null) {
                    String resourceName = "pyIndex.txt";
                    InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(u1, "UTF-8"));
                    String tStr = "";
                    ArrayList<Integer> pyIndex = new ArrayList<Integer>();
                    pyIndex.add(0);
                    ArrayList<Integer> pyData = new ArrayList<Integer>();
                    while ((tStr = br.readLine()) != null) {
                        if (_pyShow == null) {
                            String[] ss = tStr.split(",");
                            _pyShow = ss;
                            continue;
                        }
                        if (tStr != "0") {
                            String[] stringArray = tStr.split(",");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String idx = stringArray[n2];
                                int in = Integer.valueOf(idx, 16);
                                pyData.add(in);
                                ++n2;
                            }
                        }
                        pyIndex.add(pyData.size());
                    }
                    br.close();
                    Integer[] pd = new Integer[pyData.size()];
                    _pyData = pyData.toArray(pd);
                    Integer[] pi = new Integer[pyIndex.size()];
                    _pyIndex = pyIndex.toArray(pi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitPyName() throws NumberFormatException, IOException {
        if (_pyName == null) {
            Object object = lockObj;
            synchronized (object) {
                if (_pyName == null) {
                    String resourceName = "pyName.txt";
                    InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(u1, "UTF-8"));
                    HashMap<String, Integer[]> pyName = new HashMap<String, Integer[]>();
                    String tStr = "";
                    while ((tStr = br.readLine()) != null) {
                        String[] sp = tStr.split(",");
                        ArrayList<Integer> index = new ArrayList<Integer>();
                        int i = 1;
                        while (i < sp.length) {
                            String idx = sp[i];
                            int in = Integer.valueOf(idx, 16);
                            index.add(in);
                            ++i;
                        }
                        Integer[] temp = new Integer[index.size()];
                        pyName.put(sp[0], index.toArray(temp));
                    }
                    br.close();
                    _pyName = pyName;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitPyWords() throws NumberFormatException, IOException {
        if (_search == null) {
            Object object = lockObj;
            synchronized (object) {
                if (_search == null) {
                    String resourceName = "pyWords.txt";
                    InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(u1, "UTF-8"));
                    ArrayList<String> keywords = new ArrayList<String>();
                    ArrayList<Integer> wordPyIndex = new ArrayList<Integer>();
                    ArrayList<Integer> wordPy = new ArrayList<Integer>();
                    String tStr = "";
                    while ((tStr = br.readLine()) != null) {
                        String[] sp = tStr.split(",");
                        keywords.add(sp[0]);
                        wordPyIndex.add(wordPy.size());
                        int i = 1;
                        while (i < sp.length) {
                            String idx = sp[i];
                            int in = Integer.valueOf(idx, 16);
                            wordPy.add(in);
                            ++i;
                        }
                    }
                    br.close();
                    WordsSearch search = new WordsSearch();
                    search.SetKeywords(keywords);
                    Integer[] wp = new Integer[wordPy.size()];
                    _wordPy = wordPy.toArray(wp);
                    Integer[] wpi = new Integer[wordPyIndex.size()];
                    _wordPyIndex = wordPyIndex.toArray(wpi);
                    _search = search;
                }
            }
        }
    }
}

