/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TrieNodeEx {
    public Integer Char;
    public boolean End;
    public Integer Index;
    public List<Integer> Results;
    public Map<Integer, TrieNodeEx> m_values;
    private Integer minflag = Integer.MAX_VALUE;
    private Integer maxflag = 0;
    public int Next;

    public TrieNodeEx() {
        this.m_values = new Hashtable<Integer, TrieNodeEx>();
        this.Results = new ArrayList<Integer>();
    }

    public void Add(int c, TrieNodeEx node3) {
        if (this.minflag > c) {
            this.minflag = c;
        }
        if (this.maxflag < c) {
            this.maxflag = c;
        }
        this.m_values.put(c, node3);
    }

    public void SetResults(Integer text) {
        if (!this.End) {
            this.End = true;
        }
        if (!this.Results.contains(text)) {
            this.Results.add(text);
        }
    }

    public boolean HasKey(Integer c) {
        if (this.minflag <= c && this.maxflag >= c) {
            return this.m_values.containsKey((int)c);
        }
        return false;
    }

    public void Rank(Integer oneStart, Integer start, boolean[] seats, boolean[] seats2, Integer[] has) {
        if (this.maxflag == 0) {
            return;
        }
        if (this.minflag == this.maxflag) {
            this.RankOne(oneStart, seats, has);
            return;
        }
        ArrayList keys = new ArrayList();
        this.m_values.forEach((k, v) -> keys.add(Integer.valueOf(k)));
        Integer length = keys.size() - 1;
        int[] moves = new int[keys.size() - 1];
        int i = 1;
        while (i < keys.size()) {
            moves[i - 1] = this.maxflag - (Integer)keys.get(i);
            ++i;
        }
        while (has[start] != null) {
            start = start + 1;
        }
        Integer s = start < this.minflag ? this.minflag : start;
        int i2 = s;
        while (i2 < s + (this.maxflag - this.minflag)) {
            if (has[i2] != null) {
                int j = 0;
                while (j < length) {
                    Integer p = i2 + moves[j];
                    if (!seats2[p]) {
                        seats2[p.intValue()] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        Integer max = 0;
        int i3 = s + (this.maxflag - this.minflag);
        while (i3 < has.length) {
            if (has[i3] == null) {
                Integer next;
                if (!seats2[i3] && !seats[next = Integer.valueOf(i3 - this.maxflag)]) {
                    this.SetSeats(next, seats, has);
                    max = i3;
                    break;
                }
            } else {
                int j = 0;
                while (j < length) {
                    Integer p = i3 + moves[j];
                    if (!seats2[p]) {
                        seats2[p.intValue()] = true;
                    }
                    ++j;
                }
            }
            ++i3;
        }
        start = start + keys.size() / 2;
        int p = start;
        while (p < max + this.maxflag - start + 1) {
            if (seats2[p]) {
                seats2[p] = false;
            }
            ++p;
        }
    }

    private void RankOne(Integer start, boolean[] seats, Integer[] has) {
        Integer s;
        while (has[start] != null) {
            start = start + 1;
        }
        Integer i = s = start < this.minflag ? this.minflag : start;
        while (i < has.length) {
            Integer next;
            if (has[i] == null && !seats[next = Integer.valueOf(i - this.minflag)]) {
                this.SetSeats(next, seats, has);
                break;
            }
            i = i + 1;
        }
        start = start + 1;
    }

    private void SetSeats(Integer next, boolean[] seats, Integer[] has) {
        this.Next = next;
        seats[next.intValue()] = true;
        this.m_values.forEach((key, value) -> {
            int position = next + key;
            integerArray[position] = value.Index;
        });
    }
}

