/*==============================================================*/
/*   sql_20230719 ZhengJia 集中报名范围表添加字段                  */
/*==============================================================*/
alter table ENROLL_SCOPE add ENROLLEDNUM NUMBER(10);
comment on column ENROLL_SCOPE.ENROLLEDNUM is '已报名人数~';
alter table ENROLL_SCOPE add FINISHED NUMBER(2);
comment on column ENROLL_SCOPE.FINISHED is '完成状态~ 0:未完成 1:已完成';


/*==============================================================*/
/*   sql_20230620 ZhengJia    公共受众关联关系表                   */
/*==============================================================*/
create table COMMON_BUSIAUDI
(
    BUSIAUDI_ID        NUMBER(20) not null
        constraint PK_COMMON_BUSIAUDI primary key,
    BUSINESSTYPE       NUMBER(20) not null,
    BUSINESS_ID        NUMBER(20) not null,
    SCOPETYPE          NUMBER(20) not null,
    SCOPE_ID           NUMBER(20) not null,
    LASTREFRESHENDDATE DATE,
    LASTREFRESHSPENTMS NUMBER(20),
    NEXTREFRESHDATE    DATE,
    CREATOR_ID         NUMBER(20) not null,
    CREATEDATE         DATE       not null,
    DELETED            NUMBER(1),
    DELETEDATE         DATE
);
comment on table COMMON_BUSIAUDI is '业务--公共受众关联关系';
comment on column COMMON_BUSIAUDI.BUSIAUDI_ID is '主键~~';
comment on column COMMON_BUSIAUDI.BUSINESSTYPE is '业务类型~具体见BusinessOrigin类~';
comment on column COMMON_BUSIAUDI.BUSINESS_ID is '业务ID~比如培训班ID、考试ID等~';
comment on column COMMON_BUSIAUDI.SCOPETYPE is '用户范围类型~1：机构（包含子部门）；2：机构（不包含子部门）；3：用户组；4：单个用户~';
comment on column COMMON_BUSIAUDI.SCOPE_ID is '用户范围类型ID';
comment on column COMMON_BUSIAUDI.LASTREFRESHENDDATE is '最近1次刷新完成时间~~';
comment on column COMMON_BUSIAUDI.LASTREFRESHSPENTMS is '最近1次刷新耗时~~';
comment on column COMMON_BUSIAUDI.NEXTREFRESHDATE is '下次刷新开始时间~~';
comment on column COMMON_BUSIAUDI.CREATOR_ID is '创建人~~';
comment on column COMMON_BUSIAUDI.CREATEDATE is '创建日期~~';
comment on column COMMON_BUSIAUDI.DELETED is '删除标记~0未删除1已删除~';
comment on column COMMON_BUSIAUDI.DELETEDATE is '删除日期~';
create index IX_BUSIAUDI_BSTPBSID on COMMON_BUSIAUDI (BUSINESS_ID, BUSINESSTYPE);
create index IX_BUSIAUDI_SCOPEID on COMMON_BUSIAUDI (SCOPE_ID);


/*==============================================================*/
/*   sql_20230613 ZhengJia    展开报名表                          */
/*==============================================================*/
alter table ENROLL_SCOPE_USER add TYPE NUMBER(5);
comment on column ENROLL_SCOPE_USER.TYPE is '报名类型~1:常规报名,2:培训班报名,3:考试报名,4:认证报名~ENROLL.TYPE';
alter table ENROLL_SCOPE_USER add RELATIVE_ID NUMBER(18);
comment on column ENROLL_SCOPE_USER.RELATIVE_ID is '关联id~在非常规报名情况下关联的业务Id（培训班Id/考试Id/认证Id）~';


/*==============================================================*/
/*   sql_20230630 ZhengJia    更新字段数据类型                     */
/*==============================================================*/
alter table COMMON_BUSIAUDI modify BUSINESSTYPE NUMBER(5);


/*==============================================================*/
/*   sql_20230822 ZhengJia    增加业务模板表                      */
/*==============================================================*/
create table COMMON_BUSIPAGETPL
(
    BUSIPAGETPL_ID NUMBER(20) not null
        constraint PK_COMMONBUSIPAGETPL primary key,
    NAME           VARCHAR2(100),
    DOMAIN_ID      NUMBER(20) not null,
    CONTENTS       CLOB,
    COVERPIC       VARCHAR2(500),
    BGPIC          VARCHAR2(500),
    BUSINESS_ID    NUMBER(20) not null,
    BUSINESSTYPE   NUMBER(5)  not null,
    STATUS         NUMBER(2)  not null,
    ORDERNUM       NUMBER(5),
    DELETED        NUMBER(2)  not null,
    DELETEDATE     DATE,
    CREATOR_ID     NUMBER(20) not null,
    CREATEDATE     DATE       not null,
    UPDATER_ID     NUMBER(20),
    UPDATEDATE     DATE
);
comment on table COMMON_BUSIPAGETPL is '用于各个业务页面灵活配置存储模板，如培训班活动灵活配置';
comment on column COMMON_BUSIPAGETPL.BUSIPAGETPL_ID is '主键';
comment on column COMMON_BUSIPAGETPL.NAME is '标题';
comment on column COMMON_BUSIPAGETPL.DOMAIN_ID is '域id';
comment on column COMMON_BUSIPAGETPL.CONTENTS is '模板内容（json）';
comment on column COMMON_BUSIPAGETPL.COVERPIC is '封面图片url';
comment on column COMMON_BUSIPAGETPL.BGPIC is '背景图片url';
comment on column COMMON_BUSIPAGETPL.BUSINESS_ID is '业务id';
comment on column COMMON_BUSIPAGETPL.BUSINESSTYPE is '业务类型，具体见BusinessOrigin';
comment on column COMMON_BUSIPAGETPL.STATUS is '发布状态 0：未发布 1：已发布';
comment on column COMMON_BUSIPAGETPL.ORDERNUM is '排序号';
comment on column COMMON_BUSIPAGETPL.DELETED is '逻辑删除标记~1：已删除，0：未删除~deleted';
comment on column COMMON_BUSIPAGETPL.DELETEDATE is '逻辑删除日期~~';
comment on column COMMON_BUSIPAGETPL.CREATOR_ID is '创建人~~';
comment on column COMMON_BUSIPAGETPL.CREATEDATE is '创建日期~~';
comment on column COMMON_BUSIPAGETPL.UPDATER_ID is '修改人~~';
comment on column COMMON_BUSIPAGETPL.UPDATEDATE is '修改日期~~';
create index IX_BUSIPAGETPL_BSIDTYPE on COMMON_BUSIPAGETPL (BUSINESS_ID, BUSINESSTYPE);


/*==============================================================*/
/*   sql_20230918 ZhengJia    增加公共业务纠错表                   */
/*==============================================================*/
create table COMMON_BUSICORRECT
(
    BUSICORRECT_ID NUMBER(20)          not null
        constraint PK_COMBUSICORRECT primary key,
    DOMAIN_ID      NUMBER(20)          not null,
    BUSINESSTYPE   NUMBER(5)           not null,
    BUSINESS_ID    NUMBER(20)          not null,
    NAME           VARCHAR2(300)       not null,
    CONTENT        VARCHAR2(1000)      not null,
    STATUS         NUMBER(2) default 0 not null,
    OPERATOR_ID    NUMBER(20),
    OPERATEDATE    DATE,
    CREATOR_ID     NUMBER(20)          not null,
    CREATEDATE     DATE                not null,
    DELETED        NUMBER(1) default 0 not null,
    DELETEDATE     DATE
);
comment on table COMMON_BUSICORRECT is '业务--公共纠错表';
comment on column COMMON_BUSICORRECT.BUSICORRECT_ID is '主键~~';
comment on column COMMON_BUSICORRECT.DOMAIN_ID is '域id';
comment on column COMMON_BUSICORRECT.BUSINESSTYPE is '业务类型~具体见BusinessOrigin类~';
comment on column COMMON_BUSICORRECT.BUSINESS_ID is '业务id~比如培训班id、考试id等~';
comment on column COMMON_BUSICORRECT.NAME is '纠错对象名称';
comment on column COMMON_BUSICORRECT.CONTENT is '纠错内容';
comment on column COMMON_BUSICORRECT.STATUS is '处理状态 0:未处理 1:属实 2:失实';
comment on column COMMON_BUSICORRECT.OPERATOR_ID is '上次status变更的处理人';
comment on column COMMON_BUSICORRECT.OPERATEDATE is '上次status变更的日期';
comment on column COMMON_BUSICORRECT.CREATOR_ID is '创建人~~';
comment on column COMMON_BUSICORRECT.CREATEDATE is '创建日期~~';
comment on column COMMON_BUSICORRECT.DELETED is '删除标记~0未删除1已删除~';
comment on column COMMON_BUSICORRECT.DELETEDATE is '删除日期~';
create index IX_BUSICORRECT_BSIDTYPE on COMMON_BUSICORRECT (BUSINESS_ID, BUSINESSTYPE);


/*==============================================================*/
/*   sql_20230919 ZhengJia    增加纠错内容字典                     */
/*==============================================================*/
INSERT INTO COMMON_APPDICTCATEGORY (CATEGORY_ID, CODE, NAME, ISTREE, CREATEDATE, NEEDVALUE, NEEDORDER, PARENT_ID, NEEDCODE, DOMAIN_ID, CREATOR_ID, REMARK) VALUES (530, 'COMMON_BUSICORRECT_CONTENT', '纠错内容', 0, TO_DATE('2023-09-19 15:10:14', 'YYYY-MM-DD HH24:MI:SS'), 1, 1, 0, 1, 9002, 101, null);
INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS) VALUES (1212017902, 9002, '违反法律法规', '违反法律法规', 1, 1, 530, 0, ',1212017902,', TO_DATE('2023-09-19 15:10:14', 'YYYY-MM-DD HH24:MI:SS'), null, 1, null);
INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS) VALUES (2285759726, 9002, '不当信息，不良信息，不实信息', '不当信息，不良信息，不实信息', 2, 2, 530, 0, ',2285759726,', TO_DATE('2023-09-19 15:10:14', 'YYYY-MM-DD HH24:MI:SS'), null, 1, null);
INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS) VALUES (3359501550, 9002, '淫秽色情', '淫秽色情', 3, 3, 530, 0, ',3359501550,', TO_DATE('2023-09-19 15:10:14', 'YYYY-MM-DD HH24:MI:SS'), null, 1, null);
INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS) VALUES (4433243374, 9002, '抄袭', '抄袭', 4, 4, 530, 0, ',4433243374,', TO_DATE('2023-09-19 15:10:14', 'YYYY-MM-DD HH24:MI:SS'), null, 1, null);
INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS) VALUES (5506985198, 9002, '恶意谩骂攻击', '恶意谩骂攻击', 5, 5, 530, 0, ',5506985198,', TO_DATE('2023-09-19 15:10:14', 'YYYY-MM-DD HH24:MI:SS'), null, 1, null);
