/*==============================================================*/
/*   sql_20231102 ldc    增加公共附件表                     			*/
/*==============================================================*/
/*==============================================================*/
/* Table: COMMON_ATTACH                                         */
/*==============================================================*/
create table COMMON_ATTACH 
(
   ATTACH_ID            NUMBER(20)           not null,
   BUSINESS_ID          NUMBER(20)           not null,
   BUSINESSTYPE         NUMBER(8)           not null,
   NAME                 VARCHAR2(300),
   ATTACHPATH           VARCHAR2(200),
   CREATOR_ID           NUMBER(20)           not null,
   CREATEDATE           DATE                 not null,
   DELETED              NUMBER(1)            default 0 not null,
   DELETEDATE           DATE,
   constraint PK_COMMON_ATTACH primary key (ATTACH_ID)
);

comment on table COMMON_ATTACH is
'公共附件表~~';

comment on column COMMON_ATTACH.ATTACH_ID is
'主键ID~';

comment on column COMMON_ATTACH.BUSINESS_ID is
'业务ID~';

comment on column COMMON_ATTACH.BUSINESSTYPE is
'业务类型~具体见BusinessOrigin类';

comment on column COMMON_ATTACH.NAME is
'名称~';

comment on column COMMON_ATTACH.ATTACHPATH is
'路径~';

comment on column COMMON_ATTACH.CREATOR_ID is
'创建者id~';

comment on column COMMON_ATTACH.CREATEDATE is
'创建日期~';

comment on column COMMON_ATTACH.DELETED is
'逻辑删除标记~ 1:已删除 0:未删除';

comment on column COMMON_ATTACH.DELETEDATE is
'逻辑删除日期~';

/*==============================================================*/
/* Index: INX_ATTACH_BUSIIDTYPE                                 */
/*==============================================================*/
create index INX_ATTACH_BUSIIDTYPE on COMMON_ATTACH (
   BUSINESS_ID ASC,
   BUSINESSTYPE ASC
);
