
/*==============================================================*/
/*   sql_20240725a ldc 新增附件类型              */
/*==============================================================*/
alter table COMMON_ATTACH add ATTACHTYPE numeric(8, 0) comment '类型,1:视频~2:音频~4:PDF~8:图片~~';


/*==============================================================*/
/*   sql_20240816 ZhengJia 报名表添加报名成功人数字段                */
/*==============================================================*/
alter table enroll_enroll add ENROLLNUM bigint default 0 not null comment '报名成功的人数';




/*==============================================================*/
/* Table: POINT_BUSINESSEVENT                                         */
/*==============================================================*/

create table POINT_BUSINESSEVENT
(
    BUSEVENT_ID      numeric(20)           not null comment '公共积分事件id~~',
    BUSINESSTYPE        numeric(10) comment '业务类型~~',
    BUSINESS_ID          numeric(20) comment '业务id~~',
    EVENT_ID             numeric(20) comment '公共积分事件id~~',
    NAME                 VARCHAR(100) comment '积分事件名称~~',
    CODE                 VARCHAR(100) comment '积分事件编号~~',
    SCORE                numeric(7,2) comment '积分值~~',
    TYPE                 numeric(2)            default 1 comment '积分事件类型~1：标准类型通过事件计算获得积分,2：自定义类型直接用积分值获得积分~~',
    CYCLICTYPE           numeric(2) comment '积分事件累积周期：0每天，1每周，2每月，3每季度，4每半年，5每年',
    CYCLIC_MAXSCORE      numeric(10)           default 0 comment '单次累积周期，最大可获得积分值。默认0，代表无限制',
    CYCLIC_MAXNUM        numeric(10)           default 0 comment '单次累积周期，最大可获得积分次数。默认0，代表无限制',
    MAXSCORE             numeric(10)           default 0 comment '积分事件最多可获得积分值，默认为0，代表不限制',
    COMMENTS  			 VARCHAR(200) comment '描述~~',
    CREATOR_ID           numeric(20) comment '创建者ID~~',
    CREATEDATE           datetime comment '创建日期~~',
    DELETED              numeric(2) comment '逻辑删除标记~1：已删除，0：未删除~deleted~radio',
    DELETEDATE           datetime comment '逻辑删除日期~~',
    LIMITONCE            numeric(1) comment '每个业务实体只能获得一次~1：限制，0：不限制~',
    PRIMARY KEY (BUSEVENT_ID)
);

alter table POINT_BUSINESSEVENT COMMENT '公共积分事件表~~';

/*==============================================================*/
/* Index: IDX_BUSINESSEVENT_EVENTID                              */
/*==============================================================*/
create index IDX_BUSINESSEVENT_EVENTID on POINT_BUSINESSEVENT (
                                                               EVENT_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSEVENT_BUSID                                 */
/*==============================================================*/
create index IDX_BUSINESSEVENT_BUSID on POINT_BUSINESSEVENT (
                                                             BUSINESSTYPE,BUSINESS_ID ASC
    );



create table POINT_BUSINESSRANK
(
    BUSRANK_ID      numeric(20)           not null comment '积分等级主键ID~~',
    BUSINESSTYPE        numeric(10) comment '业务类型~~',
    BUSINESS_ID          numeric(20) comment '业务id~~',
    RANKING                 numeric(10) comment '级别~1：LV1；2：LV2；3：LV3；...20：LV20~',
    NAME                 VARCHAR(100) comment '名称~~',
    STARTVALUE           numeric(10)           default 0 comment '起始值~包含~',
    ENDVALUE             numeric(10)           default 0 comment '结束值~不包含~',
    PICFILE              VARCHAR(500) comment '等级图片文件地址~封面，存储不包含resource目录',
    CREATOR_ID           numeric(20) comment '创建者ID~~',
    CREATEDATE           datetime comment '创建日期~~',
    DELETED              numeric(2) comment '逻辑删除标记~1：已删除，0：未删除~deleted~radio',
    DELETEDATE           datetime comment '逻辑删除日期~~',
    PRIMARY KEY (BUSRANK_ID)
);


alter table POINT_BUSINESSRANK COMMENT '公共积分等级表~~';


/*==============================================================*/
/* Index: IDX_BUSINESSRANK_BUSID                                  */
/*==============================================================*/
create index IDX_BUSINESSRANK_BUSID on POINT_BUSINESSRANK (
                                                           BUSINESSTYPE,BUSINESS_ID ASC
    );


/*==============================================================*/
/* Table: POINT_BUSINESSUSERSCORE                               */
/*==============================================================*/
create table POINT_BUSINESSUSERSCORE
(
    BUSUSERSCORE_ID      numeric(20)           not null comment '主键ID~~',
    BUSINESSTYPE         numeric(10) comment '关联业务类型,对应BusinessOrigin~~',
    BUSINESS_ID          numeric(20) comment '关联业务ID~~',
    BUSEVENT_ID          numeric(20)           not null comment '公共积分事件id~~',
    USER_ID              numeric(20)           not null comment '学员Id~~',
    GAINDATE             datetime comment '获取时间~~',
    SCORE                numeric(7,2) comment '获得分值~~~',
    COMMENTS             VARCHAR(1000) comment '说明~~',
    POINTBUSINESSTYPE    numeric(10) comment '引发获得积分的关联业务类型,对应BusinessOrigin~~',
    POINTBUSINESS_ID     numeric(20) comment '引发获得积分的业务ID~~',
    PRIMARY KEY (BUSUSERSCORE_ID)
);

alter table POINT_BUSINESSUSERSCORE COMMENT '用户公共积分表~~';


/*==============================================================*/
/* Index: IDX_BUSINESSUSERSCORE_USERID                          */
/*==============================================================*/
create index IDX_BUSINESSUSERSCORE_USERID on POINT_BUSINESSUSERSCORE (
                                                                      USER_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSUSERSCORE_BUSID                           */
/*==============================================================*/
create index IDX_BUSINESSUSERSCORE_BUSID on POINT_BUSINESSUSERSCORE (
                                                                     BUSINESS_ID ASC,
                                                                     BUSINESSTYPE ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSUSERSCORE_EVENTID                         */
/*==============================================================*/
create index IDX_BUSINESSUSERSCORE_EVENTID on POINT_BUSINESSUSERSCORE (
                                                                       BUSEVENT_ID ASC
    );



/*==============================================================*/
/* Table: POINT_BUSINESSUSERINFO                                */
/*==============================================================*/
create table POINT_BUSINESSUSERINFO
(
    BUSUSERINFO_ID       numeric(20)           not null comment '主键ID~~',
    BUSINESSTYPE         numeric(10,0) comment '业务类型~~',
    BUSINESS_ID          numeric(20,0) comment '业务id~~',
    USER_ID              numeric(20)           not null comment '人员ID~~',
    TOTALSCORE           numeric(10,2) comment '积分总分~~',
    BUSRANK_ID           numeric(20) comment '学员所在积分等级ID~~',
    CREATEDATE           datetime                 not null comment '创建日期~~',
    PRIMARY KEY (BUSUSERINFO_ID)
);

alter table POINT_BUSINESSUSERINFO COMMENT '公共积分用户信息表记录用户总积分';



/*==============================================================*/
/* Index: IDX_BUSINESSUSERINFO_BUSID                            */
/*==============================================================*/
create index IDX_BUSINESSUSERINFO_BUSID on POINT_BUSINESSUSERINFO (
                                                                   BUSINESS_ID ASC,
                                                                   BUSINESSTYPE ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSUSERINFO_UID                              */
/*==============================================================*/
create index IDX_BUSINESSUSERINFO_UID on POINT_BUSINESSUSERINFO (
                                                                 USER_ID ASC
    );



/*==============================================================*/
/* Table: POINT_BUSORGRANK                                      */
/*==============================================================*/
create table POINT_BUSORGRANK
(
    BUSORGRANK_ID        numeric(20,0)         not null comment '积分等级主键ID~~',
    ORG_ID               numeric(20,0) comment '机构id~~',
    BUSINESSTYPE         numeric(10,0) comment '业务类型~~',
    BUSINESS_ID          numeric(20,0) comment '业务id~~',
    TOTALSCORE           numeric(15,2) comment '总积分~~',
    AVGSCORE             numeric(10,2) comment '平均积分~~',
    ALLUSERCOUNT         numeric(10) comment '机构总人数~~',
    BUSUSERCOUNT         numeric(10) comment '业务功能参与培训人数~~',
    LASTMODIFYTIME       datetime comment '数据刷新最后时间~~',
    RANKING              numeric(10)           default 0 comment '排名~~',
    PRIMARY KEY (BUSORGRANK_ID)
);

alter table POINT_BUSORGRANK COMMENT '公共积分机构积分排行表~~';


/*==============================================================*/
/* Index: IDX_BUSORGRANK_ORGID                                  */
/*==============================================================*/
create index IDX_BUSORGRANK_ORGID on POINT_BUSORGRANK (
                                                       ORG_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSORGRANK_BUSID                                  */
/*==============================================================*/
create index IDX_BUSORGRANK_BUSID on POINT_BUSORGRANK (
                                                       BUSINESS_ID ASC,
                                                       BUSINESSTYPE ASC
    );



/*==============================================================*/
/* Table: POINT_BUSORGRANKDAY                                   */
/*==============================================================*/
create table POINT_BUSORGRANKDAY
(
    BUSORGRANK_ID        numeric(20,0)         not null comment '积分等级主键ID~~',
    ORG_ID               numeric(20,0) comment '机构id~~',
    BUSINESSTYPE         numeric(10,0) comment '业务类型~~',
    BUSINESS_ID          numeric(20,0) comment '业务id~~',
    TOTALSCORE           numeric(15,2) comment '总积分~~',
    AVGSCORE             numeric(10,2) comment '平均积分~~',
    ALLUSERCOUNT         numeric(10) comment '机构总人数~~',
    BUSUSERCOUNT         numeric(10) comment '业务功能参与培训人数~~',
    LASTMODIFYTIME       datetime comment '数据刷新最后时间~~',
    RANKING              numeric(10)           default 0 comment '排名~~',
    CREATEDATE           datetime comment '数据创建时间~~',
    PRIMARY KEY (BUSORGRANK_ID)

);

alter table POINT_BUSORGRANKDAY COMMENT '公共积分机构当天积分排行表~~';


/*==============================================================*/
/* Index: IDX_BUSORGRANKD_ORGID                                 */
/*==============================================================*/
create index IDX_BUSORGRANKD_ORGID on POINT_BUSORGRANKDAY (
                                                           ORG_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSORGRANKD_BUSID                                 */
/*==============================================================*/
create index IDX_BUSORGRANKD_BUSID on POINT_BUSORGRANKDAY (
                                                           BUSINESS_ID ASC,
                                                           BUSINESSTYPE ASC
    );




/*==============================================================*/
/* Table: POINT_BUSORGRANKBEFORETODAY                           */
/*==============================================================*/
create table POINT_BUSORGRANKBEFORETODAY
(
    BUSORGRANK_ID        numeric(20,0)         not null comment '积分等级主键ID~~',
    ORG_ID               numeric(20,0) comment '机构id~~',
    BUSINESSTYPE         numeric(10,0) comment '业务类型~~',
    BUSINESS_ID          numeric(20,0) comment '业务id~~',
    TOTALSCORE           numeric(15,2) comment '总积分~~',
    AVGSCORE             numeric(10,2) comment '平均积分~~',
    ALLUSERCOUNT         numeric(10) comment '机构总人数~~',
    BUSUSERCOUNT         numeric(10) comment '业务功能参与培训人数~~',
    LASTMODIFYTIME       datetime comment '数据刷新最后时间~~',
    RANKING              numeric(10)           default 0 comment 'comment',
    CREATEDATE           datetime comment '数据创建时间~~',
    PRIMARY KEY (BUSORGRANK_ID)
);


alter table POINT_BUSORGRANKBEFORETODAY COMMENT '公共积分机构当天积分排行前一天数据表~~';


/*==============================================================*/
/* Index: IDX_BUSORGRANKBD_ORGID                                */
/*==============================================================*/
create index IDX_BUSORGRANKBD_ORGID on POINT_BUSORGRANKBEFORETODAY (
                                                                    ORG_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSORGRANKBD_BUSID                                */
/*==============================================================*/
create index IDX_BUSORGRANKBD_BUSID on POINT_BUSORGRANKBEFORETODAY (
                                                                    BUSINESS_ID ASC,
                                                                    BUSINESSTYPE ASC
    );


/*==============================================================*/
/* 20240910 ZhengJia common_busipagetpl表添加字段                 */
/*==============================================================*/
alter table COMMON_BUSIPAGETPL add TYPE bigint null comment '子类型，具体可由前端自定义。1: PC端 2: APP端';


/*==============================================================*/
/*   sql_20241121 liudachang  新增公共互动设置表、公共页面配置表      */
/*==============================================================*/
/*==============================================================*/
/* Table: COMMON_INTERACTSET                                    */
/*==============================================================*/
create table COMMON_INTERACTSET
(
   interactset_id     bigint not null comment '主键id~~',
   business_id        bigint not null comment '业务id~比如培训班id、考试id等~~',
   businesstype       int(8) not null comment '业务类型~具体见BusinessOrigin类~~',
   isComment          tinyint(1) comment '是否开启评论 1:开启 0:不开启~~',
   isTopic            tinyint(1) comment '是否开启话题 1:开启 0:不开启~~',
   creator_id         bigint comment '创建者ID~~',
   createDate         datetime comment '创建日期~~',
   primary key (interactset_id)
);

alter table COMMON_INTERACTSET COMMENT '公共互动表~~';


/*==============================================================*/
/* Index: ix_interactset_bstpbsid                                */
/*==============================================================*/
create index ix_interactset_bstpbsid on COMMON_INTERACT (
   business_id ASC,
   businesstype ASC
);



/*==============================================================*/
/* Table: COMMON_PAGESET                                        */
/*==============================================================*/
create table COMMON_PAGESET
(
   pageset_id         bigint not null comment '主键id~~',
   business_id        bigint not null comment '业务id~比如培训班id、考试id等~~',
   businesstype       int(8) not null comment '业务类型~具体见BusinessOrigin类~~',
   configtype         tinyint(2) comment '配置类型~1：上传制作好的页面包~2：在线页面配置~~',
   templatenum        mediumint(5) comment '固有页面模版号~~',
   pcpath             varchar(200) comment '电脑端活动包路径~~',
   pcuploaddate       datetime comment '电脑端活动包上传时间~~',
   apppath            varchar(200) comment '移动端活动包路径~~',
   appuploaddate      datetime comment '移动端活动包上传时间~~',
   creator_id         bigint comment '创建者ID~~',
   createDate         datetime comment '创建日期~~',
   primary key (pageset_id)
);

alter table COMMON_INTERACT COMMENT '公共页面配置表~~';


/*==============================================================*/
/* Index: ix_pageset_bstpbsid                                 */
/*==============================================================*/
create index ix_pageset_bstpbsid on COMMON_PAGESET (
   business_id ASC,
   businesstype ASC
);

/*==============================================================*/
/* 20250305 ldc新增圈子分类初始化sql                               */
/*==============================================================*/
INSERT INTO LMS_RESOURCECATEGORY (
RESCATEGORY_ID,DOMAIN_ID,ORG_ID,CODE,NAME,GKEY,PARENT_ID,FULLPATH,TYPE,CREATOR_ID,
CREATEDATE,DELETED,ISROOT,DELETEABLE,ISMOBILELESSON)
VALUES (1009,9002,9002,'圈子分类','圈子分类','',-1,',,1009,,','9',101,NOW(),0,1,0,0);
commit;