/*==============================================================*/
/*   sql_20240725a ldc 新增附件类型              */
/*==============================================================*/
alter table COMMON_ATTACH add ATTACHTYPE NUMBER(8);
comment on column COMMON_ATTACH.ATTACHTYPE is '类型,1:视频~2:音频~4:PDF~8:图片~~';


/*==============================================================*/
/*   sql_20240816 ZhengJia 报名表添加报名成功人数字段                */
/*==============================================================*/
alter table ENROLL_ENROLL add ENROLLNUM NUMBER(10) default 0 not null;
comment on column ENROLL_ENROLL.ENROLLNUM is '报名成功的人数';




/*==============================================================*/
/* Table: POINT_BUSINESSEVENT                                         */
/*==============================================================*/


create table POINT_BUSINESSEVENT
(
    BUSEVENT_ID      NUMBER(20)           not null,
    BUSINESSTYPE        NUMBER(10),
    BUSINESS_ID          NUMBER(20),
    EVENT_ID             NUMBER(20),
    NAME                 VARCHAR2(100),
    CODE                 VARCHAR2(100),
    SCORE                NUMBER(7,2),
    TYPE                 NUMBER(2)            default 1,
    CYCLICTYPE           NUMBER(2),
    CYCLIC_MAXSCORE      NUMBER(10)           default 0,
    CYCLIC_MAXNUM        NUMBER(10)           default 0,
    MAXSCORE             NUMBER(10)           default 0,
    COMMENTS  			 VARCHAR2(200),
    CREATOR_ID           NUMBER(20),
    CREATEDATE           DATE,
    DELETED              NUMBER(2),
    DELETEDATE           DATE,
    LIMITONCE            NUMBER(1),
    constraint PK_POINT_BUSEVENT primary key (BUSEVENT_ID)
);

comment on table POINT_BUSINESSEVENT is
'公共积分事件表~~';

comment on column POINT_BUSINESSEVENT.BUSEVENT_ID is
'公共积分事件id~~';

comment on column POINT_BUSINESSEVENT.BUSINESSTYPE is
'业务类型~~';

comment on column POINT_BUSINESSEVENT.BUSINESS_ID is
'业务id~~';

comment on column POINT_BUSINESSEVENT.EVENT_ID is
'系统积分事件Id~~';

comment on column POINT_BUSINESSEVENT.NAME is
'积分事件名称~~';

comment on column POINT_BUSINESSEVENT.NAME is
'积分事件编号~~';

comment on column POINT_BUSINESSEVENT.SCORE is
'积分值~~';

comment on column POINT_BUSINESSEVENT.TYPE is
'积分事件类型~1：标准类型通过事件计算获得积分,2：自定义类型直接用积分值获得积分~~';

comment on column POINT_BUSINESSEVENT.CYCLICTYPE is
'积分事件累积周期：0每天，1每周，2每月，3每季度，4每半年，5每年';

comment on column POINT_BUSINESSEVENT.CYCLIC_MAXSCORE is
'单次累积周期，最大可获得积分值。默认0，代表无限制';

comment on column POINT_BUSINESSEVENT.CYCLIC_MAXNUM is
'单次累积周期，最大可获得积分次数。默认0，代表无限制';

comment on column POINT_BUSINESSEVENT.MAXSCORE is
'积分事件最多可获得积分值，默认为0，代表不限制';

comment on column POINT_BUSINESSEVENT.COMMENTS is
'描述~~';

comment on column POINT_BUSINESSEVENT.CREATOR_ID is
'创建者ID~~';

comment on column POINT_BUSINESSEVENT.CREATEDATE is
'创建日期~~';

comment on column POINT_BUSINESSEVENT.DELETED is
'逻辑删除标记~1：已删除，0：未删除~deleted~radio';

comment on column POINT_BUSINESSEVENT.DELETEDATE is
'逻辑删除日期~~';

comment on column POINT_BUSINESSEVENT.LIMITONCE is
'每个业务实体只能获得一次~1：限制，0：不限制~';

/*==============================================================*/
/* Index: IDX_BUSINESSEVENT_EVENTID                              */
/*==============================================================*/
create index IDX_BUSINESSEVENT_EVENTID on POINT_BUSINESSEVENT (
                                                               EVENT_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSEVENT_BUSID                                 */
/*==============================================================*/
create index IDX_BUSINESSEVENT_BUSID on POINT_BUSINESSEVENT (
                                                             BUSINESSTYPE,BUSINESS_ID ASC
    );





/*==============================================================*/
/* Table: POINT_BUSINESSRANK                                          */
/*==============================================================*/


create table POINT_BUSINESSRANK
(
    BUSRANK_ID      NUMBER(20)           not null,
    BUSINESSTYPE        NUMBER(10),
    BUSINESS_ID          NUMBER(20),
    RANKING                 NUMBER(10),
    NAME                 VARCHAR2(100),
    STARTVALUE           NUMBER(10)           default 0,
    ENDVALUE             NUMBER(10)           default 0,
    PICFILE              VARCHAR2(500),
    CREATOR_ID           NUMBER(20),
    CREATEDATE           DATE,
    DELETED              NUMBER(2),
    DELETEDATE           DATE,
    constraint PK_BUSINESS_POINTRANK primary key (BUSRANK_ID)
);

comment on table POINT_BUSINESSRANK is
'公共积分等级表~~';

comment on column POINT_BUSINESSRANK.BUSRANK_ID is
'积分等级主键ID~~';

comment on column POINT_BUSINESSRANK.BUSINESSTYPE is
'业务类型~~';

comment on column POINT_BUSINESSRANK.BUSINESS_ID is
'业务id~~';

comment on column POINT_BUSINESSRANK.RANKING is
'级别~1：LV1；2：LV2；3：LV3；...20：LV20~';

comment on column POINT_BUSINESSRANK.NAME is
'名称~~';

comment on column POINT_BUSINESSRANK.STARTVALUE is
'起始值~包含~';

comment on column POINT_BUSINESSRANK.ENDVALUE is
'结束值~不包含~';

comment on column POINT_BUSINESSRANK.PICFILE is
'等级图片文件地址~封面，存储不包含resource目录，resource目录后的全路径文件名~tppointrankpic/2021/10/08~目录下，每月生成不同的年月日~~';

comment on column POINT_BUSINESSRANK.CREATOR_ID is
'创建者ID~~';

comment on column POINT_BUSINESSRANK.CREATEDATE is
'创建日期~~';

comment on column POINT_BUSINESSRANK.DELETED is
'逻辑删除标记~1：已删除，0：未删除~deleted~radio';

comment on column POINT_BUSINESSRANK.DELETEDATE is
'逻辑删除日期~~';

/*==============================================================*/
/* Index: IDX_BUSINESSRANK_BUSID                                  */
/*==============================================================*/
create index IDX_BUSINESSRANK_BUSID on POINT_BUSINESSRANK (
                                                           BUSINESSTYPE,BUSINESS_ID ASC
    );







/*==============================================================*/
/* Table: POINT_BUSINESSUSERSCORE                               */
/*==============================================================*/
create table POINT_BUSINESSUSERSCORE
(
    BUSUSERSCORE_ID      NUMBER(20)           not null,
    BUSINESSTYPE         NUMBER(10),
    BUSINESS_ID          NUMBER(20),
    BUSEVENT_ID          NUMBER(20)           not null,
    USER_ID              NUMBER(20)           not null,
    GAINDATE             DATE,
    SCORE                NUMBER(7,2),
    COMMENTS             VARCHAR2(1000),
    POINTBUSINESSTYPE    NUMBER(10),
    POINTBUSINESS_ID     NUMBER(20),
    constraint PK_POINT_BUSINESSUSERSCORE primary key (BUSUSERSCORE_ID)
);

comment on table POINT_BUSINESSUSERSCORE is
'用户公共积分表~~';

comment on column POINT_BUSINESSUSERSCORE.BUSUSERSCORE_ID is
'主键ID~~';

comment on column POINT_BUSINESSUSERSCORE.BUSINESSTYPE is
'关联业务类型,对应BusinessOrigin~~';

comment on column POINT_BUSINESSUSERSCORE.BUSINESS_ID is
'关联业务ID~~';

comment on column POINT_BUSINESSUSERSCORE.BUSEVENT_ID is
'公共积分事件id~~';

comment on column POINT_BUSINESSUSERSCORE.USER_ID is
'学员Id~~';

comment on column POINT_BUSINESSUSERSCORE.GAINDATE is
'获取时间~~';

comment on column POINT_BUSINESSUSERSCORE.SCORE is
'获得分值~~~';

comment on column POINT_BUSINESSUSERSCORE.COMMENTS is
'说明~~';

comment on column POINT_BUSINESSUSERSCORE.POINTBUSINESSTYPE is
'引发获得积分的关联业务类型,对应BusinessOrigin~~';

comment on column POINT_BUSINESSUSERSCORE.POINTBUSINESS_ID is
'引发获得积分的业务ID~~';

/*==============================================================*/
/* Index: IDX_BUSINESSUSERSCORE_USERID                          */
/*==============================================================*/
create index IDX_BUSINESSUSERSCORE_USERID on POINT_BUSINESSUSERSCORE (
                                                                      USER_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSUSERSCORE_BUSID                           */
/*==============================================================*/
create index IDX_BUSINESSUSERSCORE_BUSID on POINT_BUSINESSUSERSCORE (
                                                                     BUSINESS_ID ASC,
                                                                     BUSINESSTYPE ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSUSERSCORE_EVENTID                         */
/*==============================================================*/
create index IDX_BUSINESSUSERSCORE_EVENTID on POINT_BUSINESSUSERSCORE (
                                                                       BUSEVENT_ID ASC
    );




/*==============================================================*/
/* Table: POINT_BUSINESSUSERINFO                                */
/*==============================================================*/
create table POINT_BUSINESSUSERINFO
(
    BUSUSERINFO_ID       NUMBER(20)           not null,
    BUSINESSTYPE         NUMBER(10,0),
    BUSINESS_ID          NUMBER(20,0),
    USER_ID              NUMBER(20)           not null,
    TOTALSCORE           NUMBER(10,2),
    BUSRANK_ID           NUMBER(20),
    CREATEDATE           DATE                 not null,
    constraint PK_POINT_BUSINESSUSERINFO primary key (BUSUSERINFO_ID)
);

comment on table POINT_BUSINESSUSERINFO is
'公共积分用户信息表记录用户总积分';

comment on column POINT_BUSINESSUSERINFO.BUSUSERINFO_ID is
'主键ID~~';

comment on column POINT_BUSINESSUSERINFO.BUSINESSTYPE is
'业务类型~~';

comment on column POINT_BUSINESSUSERINFO.BUSINESS_ID is
'业务id~~';

comment on column POINT_BUSINESSUSERINFO.USER_ID is
'人员ID~~';

comment on column POINT_BUSINESSUSERINFO.TOTALSCORE is
'积分总分~~';

comment on column POINT_BUSINESSUSERINFO.BUSRANK_ID is
'学员所在积分等级ID~~';

comment on column POINT_BUSINESSUSERINFO.CREATEDATE is
'创建日期~~';

/*==============================================================*/
/* Index: IDX_BUSINESSUSERINFO_BUSID                            */
/*==============================================================*/
create index IDX_BUSINESSUSERINFO_BUSID on POINT_BUSINESSUSERINFO (
                                                                   BUSINESS_ID ASC,
                                                                   BUSINESSTYPE ASC
    );

/*==============================================================*/
/* Index: IDX_BUSINESSUSERINFO_UID                              */
/*==============================================================*/
create index IDX_BUSINESSUSERINFO_UID on POINT_BUSINESSUSERINFO (
                                                                 USER_ID ASC
    );





/*==============================================================*/
/* Table: POINT_BUSORGRANK                                      */
/*==============================================================*/
create table POINT_BUSORGRANK
(
    BUSORGRANK_ID        NUMBER(20,0)         not null,
    ORG_ID               NUMBER(20,0),
    BUSINESSTYPE         NUMBER(10,0),
    BUSINESS_ID          NUMBER(20,0),
    TOTALSCORE           NUMBER(15,2),
    AVGSCORE             NUMBER(10,2),
    ALLUSERCOUNT         NUMBER(10),
    BUSUSERCOUNT         NUMBER(10),
    LASTMODIFYTIME       DATE,
    RANKING              NUMBER(10)           default 0,
    constraint PK_POINT_BUSORGRANK primary key (BUSORGRANK_ID)
);

comment on table POINT_BUSORGRANK is
'公共积分机构积分排行表~~';

comment on column POINT_BUSORGRANK.BUSORGRANK_ID is
'积分等级主键ID~~';

comment on column POINT_BUSORGRANK.ORG_ID is
'机构id~~';

comment on column POINT_BUSORGRANK.BUSINESSTYPE is
'业务类型~~';

comment on column POINT_BUSORGRANK.BUSINESS_ID is
'业务id~~';

comment on column POINT_BUSORGRANK.TOTALSCORE is
'总积分~~';

comment on column POINT_BUSORGRANK.AVGSCORE is
'平均积分~~';

comment on column POINT_BUSORGRANK.ALLUSERCOUNT is
'机构总人数~~';

comment on column POINT_BUSORGRANK.BUSUSERCOUNT is
'业务功能参与培训人数~~';

comment on column POINT_BUSORGRANK.LASTMODIFYTIME is
'数据刷新最后时间~~';

comment on column POINT_BUSORGRANK.RANKING is
'排名~~';

/*==============================================================*/
/* Index: IDX_BUSORGRANK_ORGID                                  */
/*==============================================================*/
create index IDX_BUSORGRANK_ORGID on POINT_BUSORGRANK (
                                                       ORG_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSORGRANK_BUSID                                  */
/*==============================================================*/
create index IDX_BUSORGRANK_BUSID on POINT_BUSORGRANK (
                                                       BUSINESS_ID ASC,
                                                       BUSINESSTYPE ASC
    );







/*==============================================================*/
/* Table: POINT_BUSORGRANKDAY                                   */
/*==============================================================*/
create table POINT_BUSORGRANKDAY
(
    BUSORGRANK_ID        NUMBER(20,0)         not null,
    ORG_ID               NUMBER(20,0),
    BUSINESSTYPE         NUMBER(10,0),
    BUSINESS_ID          NUMBER(20,0),
    TOTALSCORE           NUMBER(15,2),
    AVGSCORE             NUMBER(10,2),
    ALLUSERCOUNT         NUMBER(10),
    BUSUSERCOUNT         NUMBER(10),
    LASTMODIFYTIME       DATE,
    RANKING              NUMBER(10)           default 0,
    CREATEDATE           DATE,
    constraint PK_POINT_BUSORGRANKDAY primary key (BUSORGRANK_ID)
);

comment on table POINT_BUSORGRANKDAY is
'公共积分机构当天积分排行表~~';

comment on column POINT_BUSORGRANKDAY.BUSORGRANK_ID is
'积分等级主键ID~~';

comment on column POINT_BUSORGRANKDAY.ORG_ID is
'机构id~~';

comment on column POINT_BUSORGRANKDAY.BUSINESSTYPE is
'业务类型~~';

comment on column POINT_BUSORGRANKDAY.BUSINESS_ID is
'业务id~~';

comment on column POINT_BUSORGRANKDAY.TOTALSCORE is
'总积分~~';

comment on column POINT_BUSORGRANKDAY.AVGSCORE is
'平均积分~~';

comment on column POINT_BUSORGRANKDAY.ALLUSERCOUNT is
'机构总人数~~';

comment on column POINT_BUSORGRANKDAY.BUSUSERCOUNT is
'业务功能参与培训人数~~';

comment on column POINT_BUSORGRANKDAY.LASTMODIFYTIME is
'数据刷新最后时间~~';

comment on column POINT_BUSORGRANKDAY.RANKING is
'排名~~';

comment on column POINT_BUSORGRANKDAY.CREATEDATE is
'数据创建时间~~';

/*==============================================================*/
/* Index: IDX_BUSORGRANKD_ORGID                                 */
/*==============================================================*/
create index IDX_BUSORGRANKD_ORGID on POINT_BUSORGRANKDAY (
                                                           ORG_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSORGRANKD_BUSID                                 */
/*==============================================================*/
create index IDX_BUSORGRANKD_BUSID on POINT_BUSORGRANKDAY (
                                                           BUSINESS_ID ASC,
                                                           BUSINESSTYPE ASC
    );






/*==============================================================*/
/* Table: POINT_BUSORGRANKBEFORETODAY                           */
/*==============================================================*/
create table POINT_BUSORGRANKBEFORETODAY
(
    BUSORGRANK_ID        NUMBER(20,0)         not null,
    ORG_ID               NUMBER(20,0),
    BUSINESSTYPE         NUMBER(10,0),
    BUSINESS_ID          NUMBER(20,0),
    TOTALSCORE           NUMBER(15,2),
    AVGSCORE             NUMBER(10,2),
    ALLUSERCOUNT         NUMBER(10),
    BUSUSERCOUNT         NUMBER(10),
    LASTMODIFYTIME       DATE,
    RANKING              NUMBER(10)           default 0,
    CREATEDATE           DATE,
    constraint PK_POINT_BUSORGRANKBEFORETODAY primary key (BUSORGRANK_ID)
);

comment on table POINT_BUSORGRANKBEFORETODAY is
'公共积分机构当天积分排行前一天数据表~~';

comment on column POINT_BUSORGRANKBEFORETODAY.BUSORGRANK_ID is
'积分等级主键ID~~';

comment on column POINT_BUSORGRANKBEFORETODAY.ORG_ID is
'机构id~~';

comment on column POINT_BUSORGRANKBEFORETODAY.BUSINESSTYPE is
'业务类型~~';

comment on column POINT_BUSORGRANKBEFORETODAY.BUSINESS_ID is
'业务id~~';

comment on column POINT_BUSORGRANKBEFORETODAY.TOTALSCORE is
'总积分~~';

comment on column POINT_BUSORGRANKBEFORETODAY.AVGSCORE is
'平均积分~~';

comment on column POINT_BUSORGRANKBEFORETODAY.ALLUSERCOUNT is
'机构总人数~~';

comment on column POINT_BUSORGRANKBEFORETODAY.BUSUSERCOUNT is
'业务功能参与培训人数~~';

comment on column POINT_BUSORGRANKBEFORETODAY.LASTMODIFYTIME is
'数据刷新最后时间~~';

comment on column POINT_BUSORGRANKBEFORETODAY.RANKING is
'排名~~';

comment on column POINT_BUSORGRANKBEFORETODAY.CREATEDATE is
'数据创建时间~~';

/*==============================================================*/
/* Index: IDX_BUSORGRANKBD_ORGID                                */
/*==============================================================*/
create index IDX_BUSORGRANKBD_ORGID on POINT_BUSORGRANKBEFORETODAY (
                                                                    ORG_ID ASC
    );

/*==============================================================*/
/* Index: IDX_BUSORGRANKBD_BUSID                                */
/*==============================================================*/
create index IDX_BUSORGRANKBD_BUSID on POINT_BUSORGRANKBEFORETODAY (
                                                                    BUSINESS_ID ASC,
                                                                    BUSINESSTYPE ASC
    );


/*==============================================================*/
/* 20240910 ZhengJia common_busipagetpl表添加字段                 */
/*==============================================================*/
alter table COMMON_BUSIPAGETPL add TYPE NUMBER(20);
comment on column COMMON_BUSIPAGETPL.TYPE is '子类型，具体可由前端自定义。1: PC端 2: APP端';



/*==============================================================*/
/*   sql_20241121 liudachang  新增公共互动设置表、公共页面配置表      */
/*==============================================================*/
/*==============================================================*/
/* Table: COMMON_INTERACTSET                                    */
/*==============================================================*/
create table COMMON_INTERACTSET
(
   interactset_id     NUMBER(20)         not null,
   business_id        NUMBER(20)           not null,
   businesstype       NUMBER(8)           not null,
   isComment          NUMBER(1,0),
   isTopic            NUMBER(1,0),
   creator_id         NUMBER(20),
   createDate         DATE,
   constraint PK_COMMON_INTERACTSET primary key (interactset_id)
);

comment on table COMMON_INTERACTSET is
'公共互动设置表~~';

comment on column COMMON_INTERACTSET.interactset_id is
'主键id~~';

comment on column COMMON_INTERACTSET.business_id is
'业务id~比如培训班id、考试id等~~';

comment on column COMMON_INTERACTSET.businesstype is
'业务类型~具体见BusinessOrigin类~~';

comment on column COMMON_INTERACTSET.isComment is
'是否开启评论 1:开启 0:不开启~~';

comment on column COMMON_INTERACTSET.isTopic is
'是否开启话题 1:开启 0:不开启~~';

comment on column COMMON_INTERACTSET.creator_id is
'创建者ID~~';

comment on column COMMON_INTERACTSET.createDate is
'创建日期~~';

/*==============================================================*/
/* Index: ix_interactset_bstpbsid                                */
/*==============================================================*/
create index ix_interactset_bstpbsid on COMMON_INTERACTSET (
   business_id ASC,
   businesstype ASC
);


/*==============================================================*/
/* Table: COMMON_PAGESET                                        */
/*==============================================================*/
create table COMMON_PAGESET
(
   pageset_id         NUMBER(20)         not null,
   business_id        NUMBER(20)           not null,
   businesstype       NUMBER(8)           not null,
   configtype         NUMBER(2),
   templatenum        NUMBER(5),
   pcpath             VARCHAR2(200),
   pcuploaddate       DATE,
   apppath            VARCHAR2(200),
   appuploaddate      DATE,
   creator_id         NUMBER(20),
   createDate         DATE,
   constraint PK_COMMON_PAGESET primary key (pageset_id)
);

comment on table COMMON_PAGESET is
'公共页面配置表~~';

comment on column COMMON_PAGESET.pageset_id is
'主键id~~';

comment on column COMMON_PAGESET.business_id is
'业务id~比如培训班id、考试id等~~';

comment on column COMMON_PAGESET.businesstype is
'业务类型~具体见BusinessOrigin类~~';

comment on column COMMON_PAGESET.configtype is
'配置类型~1：上传制作好的页面包~2：在线页面配置~~';

comment on column COMMON_PAGESET.templatenum is
'固有页面模版号~~';

comment on column COMMON_PAGESET.pcpath is
'电脑端活动包路径~~';

comment on column COMMON_PAGESET.pcuploaddate is
'电脑端活动包上传时间~~';

comment on column COMMON_PAGESET.apppath is
'移动端活动包路径~~';

comment on column COMMON_PAGESET.appuploaddate is
'移动端活动包上传时间~~';

comment on column COMMON_PAGESET.creator_id is
'创建者ID~~';

comment on column COMMON_PAGESET.createDate is
'创建日期~~';

/*==============================================================*/
/* Index: ix_pageset_bstpbsid                                 */
/*==============================================================*/
create index ix_pageset_bstpbsid on COMMON_PAGESET (
   business_id ASC,
   businesstype ASC
);


/*==============================================================*/
/* 20250305 ldc新增圈子分类初始化sql                               */
/*==============================================================*/
INSERT INTO LMS_RESOURCECATEGORY (RESCATEGORY_ID,DOMAIN_ID,ORG_ID,CODE,NAME,GKEY,PARENT_ID,FULLPATH,TYPE,CREATOR_ID,CREATEDATE,DELETED,ISROOT,DELETEABLE,ISMOBILELESSON)
VALUES (1009,9002,9002,'圈子分类','圈子分类','',-1,',,1009,,','9',101,sysdate,0,1,0,0);
commit;
