/*==============================================================*/
/*   sql_20250403 liudachang 新增系统操作日志表                    */
/*==============================================================*/
create table sys_operatelog
(
   operatelog_id      bigint not null comment '日志id',
   business_id        bigint comment '业务ID',
   businesstype       mediumint comment '业务类型',
   operationtype      mediumint comment '操作类型，比如新增修改删除等',
   classname          VARCHAR(200) comment '操作类名称',
   methodname         VARCHAR(200) comment '操作方法名称',
   oldvalue           VARCHAR(4000) comment '旧值的json',
   paramsjson         VARCHAR(4000) comment '新值的参数json',
   descinfo           VARCHAR(4000) comment '完整描述信息',
   ipaddr             VARCHAR(200) comment 'ip地址',
   issuccess          tinyint comment '是否成功：1成功~0失败',
   errorinfo          VARCHAR(2000) comment '失败信息',
   status             tinyint(2) comment '有效状态~1：有效~0：无效，状态为了在管理端列表操作时过滤不想显示的数据',
   creator_id         bigint comment '创建者id',
   createdate         datetime comment '创建时间',
   constraint PK_SYS_OPERATELOG primary key (operatelog_id)
) comment '系统操作日志表';


/*==============================================================*/
/* Index: idx_operatelog_buidbutype                           */
/*==============================================================*/
create index idx_operatelog_buidbutype on sys_operatelog (
   business_id ASC,
   businesstype ASC
);

/*==============================================================*/
/* Index: idx_operatelog_buidbutypeotype                           */
/*==============================================================*/
create index idx_operatelog_buidbutypeotype on sys_operatelog (
   business_id ASC,
   businesstype ASC,
   operationtype ASC
);

/*==============================================================*/
/* Index: idx_operatelog_cnamemname                             */
/*==============================================================*/
create index idx_operatelog_cnamemname on sys_operatelog (
   classname ASC,
   methodname ASC
);


/*==============================================================*/
/* sql_20250422 liudachang 新增系统网页表，用户系统网页表       */
/*==============================================================*/
create table COMMON_WEBPAGE
(
   WEBPAGE_ID           bigint       not null comment '主键ID',
   NAME                 VARCHAR(500) comment '名称',
   BUSINESS_ID          bigint		 comment '业务ID',
   BUSINESSTYPE         mediumint    comment '业务类型，见BusinessOrigin.java',
   PCCONTENT            longtext comment 'PC端内容',
   APPCONTENT           longtext comment '移动端内容',
   CREATOR_ID           bigint comment '创建者id',
   CREATEDATE           datetime  comment '创建日期',
   UPDATER_ID           bigint comment '修改者id',
   UPDATEDATE           datetime comment '最后一次修改日期',
   DELETED              bigint          default 0 comment '逻辑删除标识(1已删除0未删除)',
   DELETEDATE           datetime comment '删除日期',
   constraint PK_COMMON_WEBPAGE primary key (WEBPAGE_ID)
) comment '系统网页表';

/*==============================================================*/
/* Index: INX_WEBPAGE_BIDBTY                                    */
/*==============================================================*/
create index INX_WEBPAGE_BIDBTY on COMMON_WEBPAGE (
   BUSINESS_ID ASC,
   BUSINESSTYPE ASC
);

/*==============================================================*/
/* Table: COMMON_USERWEBPAGE                                    */
/*==============================================================*/
create table COMMON_USERWEBPAGE
(
   USERWEBPAGE_ID       bigint           not null comment '主键ID',
   USER_ID              bigint           comment '用户ID',
   WEBPAGE_ID           bigint          comment '网页ID',
   FIRSTTIME            datetime comment '第一次学习时间',
   LASTTIME             datetime comment '最近一次学习时间',
   VIEWS                mediumint       default 0 comment '浏览数',
   constraint PK_COMMON_USERWEBPAGE primary key (USERWEBPAGE_ID)
) comment '用户系统网页表';


/*==============================================================*/
/* Index: UN_USERWEBPAGE_USIDWPID                               */
/*==============================================================*/
create unique index UN_USERWEBPAGE_USIDWPID on COMMON_USERWEBPAGE (
   USER_ID ASC,
   WEBPAGE_ID ASC
);


/*==============================================================*/
/* sql_20250519 liudachang 新增意见反馈表                          */
/*==============================================================*/
/*==============================================================*/
/* Table: SYS_FEEDBACK                                          */
/*==============================================================*/
create table SYS_FEEDBACK
(
   FEEDBACK_ID          bigint           not null comment '主键Id',
   CONTENTS             VARCHAR(4000) comment '反馈内容',
   PICPATHS             VARCHAR(1000) comment '图片路径，多个用;分隔',
   CREATOR_ID           bigint comment '创建者id',
   CREATEDATE           datetime comment '创建时间',
   STATUS               tinyint default 0 comment '状态,0：未处理，1：已处理',
   HANDLEOPINION        VARCHAR(4000) comment '处理意见',
   HANDLEUSER_ID        bigint comment '处理人ID',
   HANDLEDATE           datetime comment '处理时间',
   constraint PK_SYS_FEEDBACK primary key (FEEDBACK_ID)
) comment '意见反馈表';


/*==============================================================*/
/* Index: IDX_FEEDBACK_HANDLEUSERID                             */
/*==============================================================*/
create index IDX_FEEDBACK_HANDLEUSERID on SYS_FEEDBACK (
   HANDLEUSER_ID ASC
);

/*==============================================================*/
/* Index: IDX_FEEDBACK_CREATORID                                */
/*==============================================================*/
create index IDX_FEEDBACK_CREATORID on SYS_FEEDBACK (
   CREATOR_ID ASC
);

