
/*==============================================================*/
/*   sql_20250403 liudachang 新增系统操作日志表                    */
/*==============================================================*/
create table sys_operatelog
(
   operatelog_id      NUMBER(20)           not null,
   business_id        NUMBER(20),
   businesstype       NUMBER(5),
   operationtype      NUMBER(5),
   classname          VARCHAR2(200),
   methodname         VARCHAR2(200),
   oldvalue           VARCHAR2(4000),
   paramsjson         VARCHAR2(4000),
   descinfo           VARCHAR2(4000),
   ipaddr             VARCHAR2(200),
   issuccess          NUMBER(2),
   errorinfo          VARCHAR2(2000),
   creator_id         NUMBER(20),
   status             NUMBER(2),
   createdate         DATE,
   constraint PK_SYS_OPERATELOG primary key (operatelog_id)
);

comment on table sys_operatelog is
'系统操作日志表';

comment on column sys_operatelog.operatelog_id is
'日志id';

comment on column sys_operatelog.business_id is
'业务ID';

comment on column sys_operatelog.businesstype is
'业务类型';

comment on column sys_operatelog.operationtype is
'操作类型，比如新增修改删除等';

comment on column sys_operatelog.classname is
'操作类名称';

comment on column sys_operatelog.methodname is
'操作方法名称';

comment on column sys_operatelog.oldvalue is
'旧值的json';

comment on column sys_operatelog.paramsjson is
'新值的参数json';

comment on column sys_operatelog.descinfo is
'完整描述信息';

comment on column sys_operatelog.ipaddr is
'ip地址';

comment on column sys_operatelog.issuccess is
'是否成功：1成功~0失败';

comment on column sys_operatelog.errorinfo is
'失败信息';

comment on column sys_operatelog.status is
'有效状态~1：有效~0：无效，状态为了在管理端列表操作时过滤不想显示的数据';

comment on column sys_operatelog.creator_id is
'创建者id';

comment on column sys_operatelog.createdate is
'创建时间';

/*==============================================================*/
/* Index: idx_operatelog_buidbutype                           */
/*==============================================================*/
create index idx_operatelog_buidbutype on sys_operatelog (
   business_id ASC,
   businesstype ASC
);

/*==============================================================*/
/* Index: idx_operatelog_buidbutypeotype                        */
/*==============================================================*/
create index idx_operatelog_buidbutypeotype on sys_operatelog (
   business_id ASC,
   businesstype ASC,
   operationtype ASC
);


/*==============================================================*/
/* Index: idx_operatelog_cnamemname                             */
/*==============================================================*/
create index idx_operatelog_cnamemname on sys_operatelog (
   classname ASC,
   methodname ASC
);


/*==============================================================*/
/* sql_20250422 liudachang 新增系统网页表，用户系统网页表            */
/*==============================================================*/
create table COMMON_WEBPAGE
(
   WEBPAGE_ID           NUMBER(20)           not null,
   NAME                 VARCHAR2(500)        not null,
   BUSINESS_ID          NUMBER(20)           not null,
   BUSINESSTYPE         NUMBER(10)           not null,
   PCCONTENT            CLOB,
   APPCONTENT           CLOB,
   CREATOR_ID           NUMBER(20),
   CREATEDATE           DATE ,
   UPDATER_ID           NUMBER(20),
   UPDATEDATE           DATE,
   DELETED              NUMBER(2,0)          default 0,
   DELETEDATE           DATE,
   constraint PK_COMMON_WEBPAGE primary key (WEBPAGE_ID)
);

comment on table COMMON_WEBPAGE is
'系统网页表';

comment on column COMMON_WEBPAGE.WEBPAGE_ID is
'主键ID';

comment on column COMMON_WEBPAGE.NAME is
'名称';

comment on column COMMON_WEBPAGE.BUSINESS_ID is
'业务ID';

comment on column COMMON_WEBPAGE.BUSINESSTYPE is
'业务类型，见BusinessOrigin.java';

comment on column COMMON_WEBPAGE.PCCONTENT is
'PC端内容';

comment on column COMMON_WEBPAGE.APPCONTENT is
'移动端内容';

comment on column COMMON_WEBPAGE.CREATOR_ID is
'创建者id';

comment on column COMMON_WEBPAGE.CREATEDATE is
'创建日期';

comment on column COMMON_WEBPAGE.UPDATER_ID is
'修改者id';

comment on column COMMON_WEBPAGE.UPDATEDATE is
'最后一次修改日期';

comment on column COMMON_WEBPAGE.DELETED is
'逻辑删除标识(1已删除0未删除)~~';

comment on column COMMON_WEBPAGE.DELETEDATE is
'删除日期~~';

/*==============================================================*/
/* Index: INX_WEBPAGE_BIDBTY                                    */
/*==============================================================*/
create index INX_WEBPAGE_BIDBTY on COMMON_WEBPAGE (
   BUSINESS_ID ASC,
   BUSINESSTYPE ASC
);

/*==============================================================*/
/* Table: COMMON_USERWEBPAGE                                    */
/*==============================================================*/
create table COMMON_USERWEBPAGE
(
   USERWEBPAGE_ID       NUMBER(20)           not null,
   USER_ID              NUMBER(20)           not null,
   WEBPAGE_ID           NUMBER(20)           not null,
   FIRSTTIME            DATE,
   LASTTIME             DATE,
   VIEWS                NUMBER(10)       default 0,
   constraint PK_COMMON_USERWEBPAGE primary key (USERWEBPAGE_ID)
);

comment on table COMMON_USERWEBPAGE is
'用户系统网页表';

comment on column COMMON_USERWEBPAGE.USERWEBPAGE_ID is
'主键ID';

comment on column COMMON_USERWEBPAGE.USER_ID is
'业务ID';

comment on column COMMON_USERWEBPAGE.WEBPAGE_ID is
'网页ID';

comment on column COMMON_USERWEBPAGE.FIRSTTIME is
'第一次学习时间';

comment on column COMMON_USERWEBPAGE.LASTTIME is
'最近一次学习时间';

comment on column COMMON_USERWEBPAGE.VIEWS is
'浏览数';

/*==============================================================*/
/* Index: UN_USERWEBPAGE_USIDWPID                               */
/*==============================================================*/
create unique index UN_USERWEBPAGE_USIDWPID on COMMON_USERWEBPAGE (
   USER_ID ASC,
   WEBPAGE_ID ASC
);



/*==============================================================*/
/* sql_20250519 liudachang 新增意见反馈表                          */
/*==============================================================*/
/*==============================================================*/
/* Table: SYS_FEEDBACK                                          */
/*==============================================================*/
create table SYS_FEEDBACK
(
   FEEDBACK_ID          NUMBER(20)           not null,
   CONTENTS             VARCHAR2(4000),
   PICPATHS             VARCHAR2(1000),
   CREATOR_ID           NUMBER(20),
   CREATEDATE           DATE,
   STATUS               NUMBER(2) default 0,
   HANDLEOPINION        VARCHAR2(4000),
   HANDLEUSER_ID        NUMBER(20),
   HANDLEDATE           DATE,
   constraint PK_SYS_FEEDBACK primary key (FEEDBACK_ID)
);

comment on table SYS_FEEDBACK is
'意见反馈表~~';

comment on column SYS_FEEDBACK.FEEDBACK_ID is
'主键Id';

comment on column SYS_FEEDBACK.CONTENTS is
'反馈内容';

comment on column SYS_FEEDBACK.PICPATHS is
'图片路径，多个用;分隔';

comment on column SYS_FEEDBACK.CREATOR_ID is
'创建者id';

comment on column SYS_FEEDBACK.CREATEDATE is
'创建时间';

comment on column SYS_FEEDBACK.STATUS is
'状态,0：未处理，1：已处理';

comment on column SYS_FEEDBACK.HANDLEOPINION is
'处理意见';

comment on column SYS_FEEDBACK.HANDLEUSER_ID is
'处理人ID';

comment on column SYS_FEEDBACK.HANDLEDATE is
'处理时间';

/*==============================================================*/
/* Index: IDX_FEEDBACK_HANDLEUSERID                             */
/*==============================================================*/
create index IDX_FEEDBACK_HANDLEUSERID on SYS_FEEDBACK (
   HANDLEUSER_ID ASC
);

/*==============================================================*/
/* Index: IDX_FEEDBACK_CREATORID                                */
/*==============================================================*/
create index IDX_FEEDBACK_CREATORID on SYS_FEEDBACK (
   CREATOR_ID ASC
);


