/*==============================================================*/
/*   sql_20230225a wzy    */
/*==============================================================*/
alter table TUSEREXTEND add identitys NUMBER(20);
comment on column TUSEREXTEND.identitys
  is '政治面貌';

CREATE INDEX IX_USERPOSITION_POSITION ON TUSER_POSITION (
      POSITION_ID ASC
);

comment on column TUSER.createway
  is '创建途径~1:管理员页面录入;2:管理员导入;3从其他系统同步过来~';

comment on column TORG.createway
  is '创建途径~1:管理员页面录入;2:管理员导入;3从其他系统同步过来~~';

comment on column TUSER.username
  is '用户名（即登录名）~需要转小写再入库，避免登录区分大小写~';
comment on column TUSER.email
  is '电子邮件~需要转小写再入库，避免登录区分大小写~';

/*==============================================================*/
/*   sql_20230316a wzy    */
/*==============================================================*/

alter table TDOMAIN add filteruserrule varchar2(4000);
comment on column TDOMAIN.filteruserrule
  is '过滤用户规则（存储json格式）';

alter table TDOMAIN add rulesql VARCHAR2(4000);
comment on column TDOMAIN.rulesql
  is '过滤用户规则对应的sql';
  
  
/*==============================================================*/
/*   sql_20230707a ldc新增首页高并发弹窗设置表    */
/*==============================================================*/
 
/*==============================================================*/
/* Table: BASE_HOMEPOPUP                                        */
/*==============================================================*/
create table BASE_HOMEPOPUP  (
   HOMEPOPUP_ID         NUMBER(20)                      not null,
   DOMAIN_ID            NUMBER(20),
   ISEXAMPOPUP          NUMBER(2),
   ISLIVEPOPUP          NUMBER(2),
   PCPICPATH            VARCHAR2(200),
   APPPICPATH           VARCHAR2(200),
   CREATOR_ID           NUMBER(20),
   CREATEDATE           DATE,
   constraint PK_BASE_HOMEPOPUP primary key (HOMEPOPUP_ID)
);

comment on table BASE_HOMEPOPUP is
'首页高并发弹窗设置表~~';

comment on column BASE_HOMEPOPUP.HOMEPOPUP_ID is
'主键ID~~';

comment on column BASE_HOMEPOPUP.DOMAIN_ID is
'域ID~~';

comment on column BASE_HOMEPOPUP.ISEXAMPOPUP is
'考试高并发弹窗是否配置~~';

comment on column BASE_HOMEPOPUP.ISLIVEPOPUP is
'直播高并发弹窗是否配置~~';

comment on column BASE_HOMEPOPUP.PCPICPATH is
'电脑端学员首页背景图~~';

comment on column BASE_HOMEPOPUP.APPPICPATH is
'移动端学员首页背景图~~';

comment on column BASE_HOMEPOPUP.CREATOR_ID is
'创建者id~';

comment on column BASE_HOMEPOPUP.CREATEDATE is
'创建日期~';

/*==============================================================*/
/*   sql_20230825a wzy    */
/*==============================================================*/
-- Add/modify columns
alter table COMMON_APPCONFIG add createdate date;
-- Add comments to the columns
comment on column COMMON_APPCONFIG.createdate
  is '创建日期';

update COMMON_APPCONFIG set createdate=sysdate;
commit;



/*==============================================================*/
/*   sql_20230512 ZhengJia    */
/*==============================================================*/
comment on column TORGTREE.LINKTYPE is '链接关系~0:实机构之间父子关系,1:域管辖范围包含机构关系,父包含子的下级,2:域管辖范围包含机构关系,父不包含子的下级~';

/*==============================================================*/
/*   sql_20230518 ZhengJia  成员组功能  */
/*==============================================================*/
drop table TGROUP;
create table TGROUP
(
    GROUP_ID     NUMBER(20) not null constraint PK_TGROUP primary key,
    DOMAIN_ID    NUMBER(20),
    CODE         VARCHAR2(40),
    NAME         VARCHAR2(100),
    NOTE         VARCHAR2(400),
    WHEREUSED    VARCHAR2(200),
    TYPE         NUMBER(2) default 0 not null,
    SYNCSTATUS   NUMBER(2) default 0 not null,
    SYNCDATE     DATE,
    MATCHRULE    VARCHAR2(4000),
    STATUS       NUMBER(2) default 0 not null,
    DELETED      NUMBER(2) default 0 not null,
    DELETEDATE   DATE,
    CREATOR_ID   NUMBER(20) not null,
    CREATEDATE   DATE       not null,
    UPDATER_ID   NUMBER(20),
    UPDATEDATE   DATE
);
comment on table TGROUP is '用户组';
comment on column TGROUP.GROUP_ID is '用户组ID~~';
comment on column TGROUP.DOMAIN_ID is '所属域~~';
comment on column TGROUP.CODE is '编码~~';
comment on column TGROUP.NAME is '名称~~';
comment on column TGROUP.NOTE is '备注~~';
comment on column TGROUP.WHEREUSED is '用户组被哪个功能使用了, 逗号分割~~';
comment on column TGROUP.TYPE is '类型 0:普通用户组 1:动态用户组~~';
comment on column TGROUP.SYNCSTATUS is '是否已将本组人员同步到TGROUP_USER表 0:否 1:是';
comment on column TGROUP.SYNCDATE is '上次同步时间';
comment on column TGROUP.MATCHRULE is '动态用户组的过滤规则json';
comment on column TGROUP.STATUS is '是否有效 0:无效 1:有效';
comment on column TGROUP.DELETED is '逻辑删除标记~1：已删除，0：未删除~deleted';
comment on column TGROUP.DELETEDATE is '逻辑删除日期~~';
comment on column TGROUP.CREATOR_ID is '创建人~~';
comment on column TGROUP.CREATEDATE is '创建日期~~';
comment on column TGROUP.UPDATER_ID is '修改人~~';
comment on column TGROUP.UPDATEDATE is '修改日期~~';

drop table TUSER_GROUP;
create table TUSER_GROUP
(
    USER_ID    NUMBER(20) not null,
    GROUP_ID   NUMBER(20) not null,
    CREATOR_ID NUMBER(20),
    CREATEDATE DATE,
    ADDTYPE    NUMBER(2),
    constraint PK_TUSER_GROUP primary key (USER_ID, GROUP_ID)
);
comment on table TUSER_GROUP is '用户组-用户关联表';
comment on column TUSER_GROUP.USER_ID is '用户id~~';
comment on column TUSER_GROUP.GROUP_ID is '组id~~';
comment on column TUSER_GROUP.CREATOR_ID is '创建人~~';
comment on column TUSER_GROUP.CREATEDATE is '创建时间~~';
comment on column TUSER_GROUP.ADDTYPE is '添加类型~ 1.更新完tgroup表立即刷新的 2.定时任务刷进来的';
create index IX_UG_GROUP on TUSER_GROUP (GROUP_ID);

create table TGROUP_USERLIST
(
    USER_ID    NUMBER(20) not null,
    GROUP_ID   NUMBER(20) not null,
    ORDERNUM   NUMBER(8),
    CREATOR_ID NUMBER(20),
    CREATEDATE DATE,
    TYPE       NUMBER(2) not null,
    constraint PK_TGROUP_USERLIST primary key (USER_ID, GROUP_ID)
);
comment on table TGROUP_USERLIST is '用户组-名单表(白/黑)';
comment on column TGROUP_USERLIST.USER_ID is '用户id~~';
comment on column TGROUP_USERLIST.GROUP_ID is '组id~~';
comment on column TGROUP_USERLIST.ORDERNUM is '排序号~~';
comment on column TGROUP_USERLIST.CREATOR_ID is '创建人~~';
comment on column TGROUP_USERLIST.CREATEDATE is '创建时间~~';
comment on column TGROUP_USERLIST.TYPE is '名单类型~ 0:白名单 1:黑名单';
create index IX_UGL_GROUP on TGROUP_USERLIST (GROUP_ID);

create table TGROUP_MEMBER
(
    GROUP_ID   NUMBER(20) not null,
    MEMBER_ID  NUMBER(20) not null,
    ORDERNUM   NUMBER(8),
    CREATOR_ID NUMBER(20),
    CREATEDATE DATE,
    MEMBERTYPE NUMBER(2) not null,
    constraint PK_TGROUP_MEMBER primary key (GROUP_ID, MEMBER_ID)
);
comment on table TGROUP_MEMBER is '用户组-管辖范围表';
comment on column TGROUP_MEMBER.GROUP_ID is '组id~~';
comment on column TGROUP_MEMBER.MEMBER_ID is '成员id~~';
comment on column TGROUP_MEMBER.ORDERNUM is '排序号~~';
comment on column TGROUP_MEMBER.CREATOR_ID is '创建人~~';
comment on column TGROUP_MEMBER.CREATEDATE is '创建时间~~';
comment on column TGROUP_MEMBER.MEMBERTYPE is '成员类型~ 0:用户 1:部门(不包含子部门) 2:部门(包含子部门)';















CREATE INDEX IX_ORG_EPIDCREATEWAY ON TORG (
                                           ENTERPRISE_ID ASC,
                                           CREATEWAY ASC
    );


alter table TORG add parent_id NUMBER(20);
alter table TORG add parentcode VARCHAR2(40);
-- Add comments to the columns
comment on column TORG.parent_id
  is '父机构Id';
comment on column TORG.parentcode
  is '父机构编号';


/*==============================================================*/
/*   sql_20230806 wzy    */
/*==============================================================*/

alter table TORGEXPAND add enterprise_id NUMBER(20);
comment on column TORGEXPAND.enterprise_id
  is '企业Id';





/*==============================================================*/
/*   sql_20230813 wzy    */
/*==============================================================*/
alter table TPOSITION add parentcode VARCHAR2(40);
-- Add comments to the columns
comment on column TPOSITION.parentcode
  is '父岗位编号，如果没有父岗位填0';


drop index IDX_BEGINORG;
drop index IDX_ENDORG;
drop index IDX_OE_IDPATH;

CREATE INDEX IDX_ORGEXPAND_BEGINORG ON TORGEXPAND (
                                                   BEGINORG_ID ASC
    );

CREATE INDEX IDX_ORGEXPAND_ENDORG ON TORGEXPAND (
                                                 ENDORG_ID ASC
    );


CREATE INDEX IDX_OE_IDPATH ON TORGEXPAND (
                                          IDPATH ASC
    );

ALTER TABLE TORGEXPAND
DROP PRIMARY KEY CASCADE;

alter table TORGTREE add enterprise_id number(20);
comment on column TORGTREE.enterprise_id
  is '企业Id';


DROP TABLE TORGTREECHANGE CASCADE CONSTRAINTS;

/*==============================================================*/
/* Table: TORGTREECHANGE                                        */
/*==============================================================*/
CREATE TABLE TORGTREECHANGE
(
    ORG_ID               NUMBER(20)           NOT NULL,
    PARENT_ID            NUMBER(20)           NOT NULL,
    ORDERNUM             NUMBER(5),
    LEVELS               NUMBER(2)            NOT NULL,
    CREATEDATE           DATE                 NOT NULL,
    LINKTYPE             NUMBER(2)            NOT NULL,
    CHANGEWAY            NUMBER(1,0)          NOT NULL,
    ENTERPRISE_ID        NUMBER(20,0)         NOT NULL,
    CONSTRAINT PK_TORGTREECHANGE PRIMARY KEY (ORG_ID, PARENT_ID, CHANGEWAY)
);

COMMENT ON COLUMN TORGTREECHANGE.ORG_ID IS
'机构Id';

COMMENT ON COLUMN TORGTREECHANGE.PARENT_ID IS
'父机构Id';

COMMENT ON COLUMN TORGTREECHANGE.ORDERNUM IS
'排序号';

COMMENT ON COLUMN TORGTREECHANGE.LEVELS IS
'当前节点层级，9002根节点算0层';

COMMENT ON COLUMN TORGTREECHANGE.CREATEDATE IS
'创建日期';

COMMENT ON COLUMN TORGTREECHANGE.LINKTYPE IS
'链接关系~0:父子关系,1:域包含实机构~';

COMMENT ON COLUMN TORGTREECHANGE.CHANGEWAY IS
'数据变化情况，1：新增；2：删除；3：修改';

COMMENT ON COLUMN TORGTREECHANGE.ENTERPRISE_ID IS
'企业Id';

/*==============================================================*/
/* Index: IX_ORGTREECHANGE_PARENTID                             */
/*==============================================================*/
CREATE INDEX IX_ORGTREECHANGE_PARENTID ON TORGTREECHANGE (
    PARENT_ID ASC
);


update torgtree set levels =0 where org_id=9002;
commit;
update torgtree set torgtree.levels = (
    select otp.levels + 1 from torgtree otp
    where torgtree.parent_id=otp.org_id and otp.linktype=0 and otp.levels is not null)
where exists(select 1 from torgtree otp
             where torgtree.parent_id=otp.org_id and otp.levels is not null) and torgtree.levels is null;
commit;
/*==============================================================*/
/*   sql_20230920 wzy    */
/*==============================================================*/
drop index UNI_IDX_ORG_CODE;

/*==============================================================*/
/*   sql_20231004 wzy    改变主键，因为域增加了可以选择其他节点做为子域，会导致管辖范围和选择的子域重复问题*/
/*==============================================================*/
alter table TORGTREE
    drop constraint PK_TORGTREE cascade;
drop index PK_TORGTREE;
alter table TORGTREE
    add constraint PK_TORGTREE primary key (ORG_ID, PARENT_ID, LINKTYPE);

/*==============================================================*/
/*   sql_20231006 增加区分机构变化 wzy    */
/*==============================================================*/
alter table TORGTREECHANGE add createway NUMBER(2) default 1 not null;
comment on column TORGTREECHANGE.createway
  is '数据来源，1：普通增删变化，2：选择域添加、删除';


/*==============================================================*/
/*   sql_20231010 字典数据表增加字段 zhk   */
/*==============================================================*/
alter table COMMON_APPDICT add creator_id NUMBER(20);
-- Add comments to the columns
comment on column COMMON_APPDICT.creator_id
  is '创建人ID~~';

/*==============================================================*/
/*  sql_20231020 wzy 因为给域分配管理员是按照createdate排序了，因此createdate不允许为空  */
/*==============================================================*/
UPDATE trole  set createdate=sysdate WHERE createdate is NULL;

alter table TUSER modify name VARCHAR2(100);

/*==============================================================*/
/*  sql_20231207 wzy 华夏编号达到50  */
/*==============================================================*/
alter table TORG modify orgcode VARCHAR2(100);


