/*==============================================================*/
/*  sql_20240721 zhangdexin 全局异常记录   */
/*==============================================================*/
drop table sys_syserrorlog cascade constraints;

/*==============================================================*/
/* Table: sys_syserrorlog                                       */
/*==============================================================*/
create table sys_syserrorlog
(
   syserrorlog_id       NUMBER(20)           not null,
   title                VARCHAR2(600),
   stackTrace           CLOB,
   appName              VARCHAR2(200),
   serverUuid           VARCHAR2(40),
   serverInfo           VARCHAR2(200),
   clientInfo           VARCHAR2(200),
   createdate           DATE                 not null,
   constraint PK_SYS_SYSERRORLOG primary key (syserrorlog_id)
);

comment on table sys_syserrorlog is
'系统错误日志表';

comment on column sys_syserrorlog.syserrorlog_id is
'日志id';

comment on column sys_syserrorlog.title is
'日志简要信息ex.getMessage()';

comment on column sys_syserrorlog.stackTrace is
'调用堆栈';

comment on column sys_syserrorlog.appName is
'所属应用spring.application.name';

comment on column sys_syserrorlog.serverUuid is
'服务实例唯一id（每次启动后唯一）';

comment on column sys_syserrorlog.serverInfo is
'报错服务器信息（可能是ip等）';

comment on column sys_syserrorlog.clientInfo is
'客户端信息（可能为空-非浏览器调用）（存入ip等）';

comment on column sys_syserrorlog.createdate is
'时间戳~~';

/*==============================================================*/
/* Index: idx_syslog_appname                                    */
/*==============================================================*/
create index idx_syslog_appname on sys_syserrorlog (
   appName ASC
);

/*==============================================================*/
/* Index: idx_syslog_date                                       */
/*==============================================================*/
create index idx_syslog_date on sys_syserrorlog (
   createdate ASC
);

/*==============================================================*/
/*   sql_20240809 liudachang 新增系统导入导出信息表          */
/*==============================================================*/
create table SYS_IMPEXPINFO
(
   SYSIEI_ID            NUMBER(20)           not null,
   BUSINESS_ID          NUMBER(20),
   BUSINESSTYPE         NUMBER(8),
   EXETYPE              NUMBER(2),
   STATUS               NUMBER(2),
   IMPORTTOTALNUM       NUMBER(8),
   IMPORTSUCCESSNUM     NUMBER(8),
   IMPORTERRORNUM       NUMBER(8),
   FILEPATH             VARCHAR2(200),
   CREATEDATE           DATE,
   COMPLETEDATE         DATE,
   ERRORINFO            VARCHAR2(500),
   constraint PK_SYS_IMPEXPINFO primary key (SYSIEI_ID)
);

comment on table SYS_IMPEXPINFO is
'导入导出信息表~~';

comment on column SYS_IMPEXPINFO.SYSIEI_ID is
'主键Id~~';

comment on column SYS_IMPEXPINFO.BUSINESS_ID is
'业务ID~~';

comment on column SYS_IMPEXPINFO.BUSINESSTYPE is
'业务类型~~';

comment on column SYS_IMPEXPINFO.EXETYPE is
'执行类型，1：导出，2：导入~~';

comment on column SYS_IMPEXPINFO.STATUS is
'状态，0：进行中，1：已完成，2：操作失败~~';

comment on column SYS_IMPEXPINFO.IMPORTTOTALNUM is
'导入总数~~';

comment on column SYS_IMPEXPINFO.IMPORTSUCCESSNUM is
'导入成功数~~';

comment on column SYS_IMPEXPINFO.IMPORTERRORNUM is
'导入错误数~~';

comment on column SYS_IMPEXPINFO.FILEPATH is
'文件路径，导入导出完成时才有值~~';

comment on column SYS_IMPEXPINFO.CREATEDATE is
'创建时间~~';

comment on column SYS_IMPEXPINFO.COMPLETEDATE is
'完成时间~~';

comment on column SYS_IMPEXPINFO.ERRORINFO is
'导入导出失败错误信息~~';


/*==============================================================*/
/*   sql_20240816 wzy           */
/*==============================================================*/
alter table TRESOURCE modify code VARCHAR2(200);

/*==============================================================*/
/*   sql_20240822 zhangdexin           */
/*==============================================================*/
delete from common_appconfig where configkey = 'Syserrorlog_insert';
commit;
insert into common_appconfig (configkey, configtitle, configname, type, display, coment)
  values('Syserrorlog_insert', '错误日志入库', '错误日志入库', 100, 2, '默认不入库，开关打开后入库');
commit;

update common_appconfig set type = 200, display = 1, configvalue = '0' where configkey = 'Syserrorlog_insert';
commit;

update common_appconfig set type = 200 where configkey = 'GATEWAY_RBAC';
commit;


/*==============================================================*/
/*   sql_20240901 zhangkai 新增文件上传限制字典                     */
/*==============================================================*/
INSERT INTO COMMON_APPDICTCATEGORY (CATEGORY_ID, CODE, NAME, ISTREE, CREATEDATE, NEEDVALUE, NEEDORDER, PARENT_ID, NEEDCODE, DOMAIN_ID, CREATOR_ID, REMARK)
VALUES (211, 'FILEUPLOAD_PERMISSION', '文件上传类型限制', 1, sysdate, 1, 1, 0, 1, 9002, 101, '文件上传类型限制');

INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS, CREATOR_ID)
SELECT  (max(appdict_id) + 1) AS id, 9002, 'FILEUPLOAD_103', '文档上传', null, 1, 211, 0, ',211,,'||(max(appdict_id) + 1)||',',
        sysdate, null, 1, '.pdf,.png,.jpg,.gif,.ico,.jpeg', 101
FROM  COMMON_APPDICT;
commit;


/*==============================================================*/
/*   sql_20240912a zhk  修改字典名称编号字段长度		*/
/*==============================================================*/
alter table COMMON_APPDICT  modify CODE varchar2(500);

alter table COMMON_APPDICT  modify NAME varchar2(500);


/*==============================================================*/
/*   sql_20240918 ldc 新增前端版本号配置                     */
/*==============================================================*/
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_PC', 'PC端发布版本号', 'PC端发布版本号', 300, 2, 'PC端发布版本号', sysdate);
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_APP', 'APP端发布版本号', 'APP端发布版本号', 300, 2, 'APP端发布版本号', sysdate);
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_WeChat', 'WeChat端发布版本号', 'WeChat端发布版本号', 300, 2, 'WeChat端发布版本号', sysdate);
commit;



/*==============================================================*/
/*   sql_20240924 wzy           */
/*==============================================================*/
alter table TORG add shortfullname varchar2(500);
comment on column TORG.shortfullname
  is '机构短全路径名，示例：北京分行-人力资源部';


/*==============================================================*/
/* sql_20241012 liudachang 新增系统编号规则配置表                   */
/*==============================================================*/
create table SYS_SYSCODE
(
   SYSCODE_ID           NUMBER(20)           not null,
   DOMAIN_ID            NUMBER(20)           not null,
   BUSINESSTYPE         NUMBER(8),
   NAME                 VARCHAR2(100),
   CODERULE             VARCHAR2(200),
   MAXNUM               NUMBER(8),
   UPDATER_ID           NUMBER(20),
   UPDATEDATE           DATE,
   constraint PK_SYS_SYSCODE primary key (SYSCODE_ID)
);

comment on table SYS_SYSCODE is
'系统编号规则配置表~~';

comment on column SYS_SYSCODE.SYSCODE_ID is
'主键Id~~';

comment on column SYS_SYSCODE.DOMAIN_ID is
'域ID';

comment on column SYS_SYSCODE.BUSINESSTYPE is
'业务类型~~';

comment on column SYS_SYSCODE.NAME is
'编号类型显示名称~~';

comment on column SYS_SYSCODE.CODERULE is
'编号规则~~';

comment on column SYS_SYSCODE.MAXNUM is
'当前最大使用数~~';

comment on column SYS_SYSCODE.UPDATER_ID is
'最后更新者ID~~';

comment on column SYS_SYSCODE.UPDATEDATE is
'最后修改日期~~';

/*==============================================================*/
/*   sql_20241012 liudachang    编号规则配置类型注册初始化          */
/*==============================================================*/
delete from common_appdictcategory where category_id = 3801;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID, remark)
values (3801, '编号规则配置', '编号规则配置模板关键字', 1, 1, 1, 1, sysdate, 0, 9002, 101, '1');
commit;


/*==============================================================*/
/*   sql_20241012 liudachang   新增字典表中的编号规则配置关键字 */
/*==============================================================*/
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1000, 9002, '年', '{{YYYY}}', '1', 1, 3801, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '月', '{{MM}}', '2', 2, 3801, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '日', '{{DD}}', '3', 3, 3801, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '3位序列号', '{{3SN}}', '4', 4, 3801, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '4位序列号', '{{4SN}}', '5', 5, 3801, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '5位序列号', '{{5SN}}', '6', 6, 3801, sysdate, 1 from common_appdict;
commit;

/*==============================================================*/
/*   sql_20241012 liudachang   初始化课程、培训班的编号规则配置      */
/*==============================================================*/
insert into sys_syscode(syscode_id, domain_id, businesstype, name, coderule, maxnum, updater_id, updatedate)
values (-10001, 9002, 1, '课程编号', 'LE-{{YYYY}}-{{MM}}-{{DD}}-{{5SN}}', 0, 101, SYSDATE);
insert into sys_syscode(syscode_id, domain_id, businesstype, name, coderule, maxnum, updater_id, updatedate)
values (-10002, 9002, 2200, '培训班编号', 'TC-{{YYYY}}-{{MM}}-{{DD}}-{{3SN}}', 0, 101, SYSDATE);
commit;

/*==============================================================*/
/* sql_20241012 liudachang 重新设置模板业务类型                   */
/*==============================================================*/
delete from common_appdictcategory where category_id = 318;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID)
values (318, '模板业务类型', '模板业务类型', 1, 1, 1, 1, sysdate, 0, 9002, 101);
commit;

/*==============================================================*/
/* sql_20241012 liudachang 3101、3102的父类型挂载到模板业务类型 */
/*==============================================================*/
update common_appdictcategory set parent_id = 318 where category_id in (3101, 3102);
commit;


/*==============================================================*/
/* sql_20241021 liudachang 新增系统追踪日志表                      */
/*==============================================================*/
create table SYS_TRACELOG
(
   TRACELOG_ID          NUMBER(20)           not null,
   LOGTITLE             VARCHAR2(500),
   LOGCONTENT           VARCHAR2(500),
   SERVICENAME          VARCHAR2(200),
   LOGLEVEL             NUMBER(5),
   CREATEDATE           DATE,
   constraint PK_SYS_TRACELOG primary key (TRACELOG_ID)
);

comment on table SYS_TRACELOG is
'系统追踪日志表~~';

comment on column SYS_TRACELOG.TRACELOG_ID is
'主键Id~~';

comment on column SYS_TRACELOG.LOGTITLE is
'主题~~';

comment on column SYS_TRACELOG.LOGCONTENT is
'内容~~';

comment on column SYS_TRACELOG.SERVICENAME is
'服务名称~~';

comment on column SYS_TRACELOG.LOGLEVEL is
'级别~~';

comment on column SYS_TRACELOG.CREATEDATE is
'创建时间~~';


/*==============================================================*/
/*   sql_20241021 liudachang    系统追踪日志级别类型注册初始化  */
/*==============================================================*/
delete from common_appdictcategory where category_id = 3900;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID, remark)
values (3900, '系统追踪日志级别', '系统追踪日志级别类型', 1, 1, 1, 1, sysdate, 0, 9002, 101, '1');
commit;


/*==============================================================*/
/*   sql_20241021 liudachang   新增系统追踪日志级别类型关键字   */
/*==============================================================*/
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1000, 9002, 'ERROR', 'ERROR', '4', 4, 3900, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, 'WARN', 'WARN', '3', 3, 3900, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, 'INFO', 'INFO', '2', 2, 3900, sysdate, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, 'DEBUG', 'DEBUG', '1', 1, 3900, sysdate, 1 from common_appdict;
commit;


/*==============================================================*/
/*   sql_20241021 liudachang   初始化系统追踪日志级别配置            */
/*==============================================================*/
update common_appconfig set type = 400
where configkey = 'Syserrorlog_insert';
commit;


delete from common_appconfig where configkey = 'Systracelog_level';
commit;
insert into common_appconfig (configkey, configtitle, configname, configvalue, type, display, coment, createdate)
  values('Systracelog_level', '系统追踪日志级别配置', '系统追踪日志级别配置(仅可填写1、2、3、4这几个数字)', '2', 400, 2,
        '填写不同日志级别，记录对应的日志信息，级别依次为【从高到低】：4(ERROR) > 3(WARN) > 2(INFO) > 1(DEBUG)', sysdate);
commit;

/*==============================================================*/
/*   sql_20241031 liudachang    域数据迁移类型注册初始化        */
/*==============================================================*/
delete from common_appdictcategory where category_id = 4000;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID, remark)
values (4000, '域数据迁移表配置', '域数据迁移表配置', 1, 1, 1, 1, SYSDATE, 0, 9002, 101, '1');
commit;

/*==============================================================*/
/*   sql_20241106 zhk    MQ消息清理后保留多少天的数据注册初始化        */
/*==============================================================*/
insert into common_appconfig (configkey, configtitle, configname, configvalue, type, display, coment, createdate)
values('MESSAGEQLOG_RESERVE_DAYS', 'MQ消息清理后保留多少天的数据', 'MQ消息清理后保留多少天的数据', '90', 400, 2,
       'MQ消息清理后保留多少天的数据', sysdate);
commit;

/*==============================================================*/
/*   sql_20241125 ldc 新增课程学时计算配置项                        */
/*==============================================================*/
delete from common_appconfig where configkey = 'IS_NOVIDEOLESSON_CLASSHOUR';
delete from common_appconfig where configkey = 'PER_15MLESSON_CLASSHOUR';
delete from common_appconfig where configkey = 'NOVIDEOLESSON_MAXCLASSHOUR';
delete from common_appconfig where configkey = 'PER_15MLESSON_CLASSHOUR_UP';
delete from common_appconfig where configkey = 'IS_AUTO_LESSONCLASSHOUR';



insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('NOVIDEOLESSON_MAXCLASSHOUR', '课程中不包含纯视音频课件，最大获得学时数', '课程中不包含纯视音频课件，最大获得学时数',
       1,102, 2, '纯视音频课件指课件是单一视频文件或单一音频文件', sysdate);

insert into common_appconfig (configkey, configtitle, configname, configvalue, type, display, coment, createdate)
values('IS_NOVIDEOLESSON_CLASSHOUR', '非纯视音频课件是否参与学时计算', '非纯视音频课件是否参与学时计算',
       '0', 102, 1, '非纯视音频课件指文档、图片、H5等类型课件<br/>纯视音频课件指课件是单一视频文件或单一音频文件', sysdate);

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('PER_15MLESSON_CLASSHOUR', '每15分钟课程时长兑换学时数量', '每15分钟课程时长兑换学时数量',
       '0.25',102, 2, '示例：2分钟按照0.25学时计算；16分钟按照0.5学时计算', sysdate);

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('PER_15MLESSON_CLASSHOUR_UP', '每15分钟课程时长兑换学时数量余数计算方法，1：向上取整，0：向下取整', '每15分钟课程时长兑换学时数量余数计算方法',
       '1',102, 1, '启用：向上取整，示例：2分钟按照0.25学时计算；16分钟按照0.5学时计算<br/>停用：向下取整，示例：2分钟按照0学时计算；16分钟按照0.25学时计算', sysdate);

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('IS_AUTO_LESSONCLASSHOUR', '是否自动计算课程学时，1：启用，0：停用', '是否自动计算课程学时',
       '1',102, 1, '启用：课程根据课件时间系统自动计算课程学时，课程学时不允许修改<br/>停用：课程学时系统不自动计算，管理员可以手工填写', sysdate);
commit;




/*==============================================================*/
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*==============================================================*/
