/*==============================================================*/
/*  sql_20240721 zhangdexin 全局异常记录   */
/*==============================================================*/
drop table if exists sys_syserrorlog;

/*==============================================================*/
/* Table: sys_syserrorlog                                       */
/*==============================================================*/
create table sys_syserrorlog
(
   syserrorlog_id       bigint not null comment '日志id',
   title                varchar(600) comment '日志简要信息ex.getMessage()',
   stackTrace           text comment '调用堆栈',
   appName              varchar(200) comment '所属应用spring.application.name',
   serverUuid           varchar(40) comment '服务实例唯一id（每次启动后唯一）',
   serverInfo           varchar(200) comment '报错服务器信息（可能是ip等）',
   clientInfo           varchar(200) comment '客户端信息（可能为空-非浏览器调用）（存入ip等）',
   createdate           datetime not null comment '时间戳~~',
   primary key (syserrorlog_id)
);

alter table sys_syserrorlog comment '系统错误日志表';

/*==============================================================*/
/* Index: idx_syslog_appname                                    */
/*==============================================================*/
create index idx_syslog_appname on sys_syserrorlog
(
   appName
);

/*==============================================================*/
/* Index: idx_syslog_date                                       */
/*==============================================================*/
create index idx_syslog_date on sys_syserrorlog
(
   createdate
);


/*==============================================================*/
/*   sql_20240809 liudachang 新增系统导入导出信息表          */
/*==============================================================*/
CREATE TABLE SYS_IMPEXPINFO (
  SYSIEI_ID numeric(20,0) NOT NULL comment '主键id~~',
  BUSINESS_ID numeric(20,0) comment '业务id~~',
  BUSINESSTYPE numeric(8,0) comment '业务类型~~',
  EXETYPE numeric(2, 0) comment '执行类型，1：导出，2：导入~~',
  STATUS numeric(2,0) comment '状态，0：进行中，1：已完成，2：操作失败~~',
  IMPORTTOTALNUM numeric(8,0) comment '导入总数~~',
  IMPORTSUCCESSNUM numeric(8,0) comment '导入成功数~~',
  IMPORTERRORNUM numeric(8,0) comment '导入错误数~~',
  FILEPATH VARCHAR(200) comment '文件路径，导入导出完成时才有值~~',
  CREATEDATE datetime NOT NULL comment '创建时间~~',
  COMPLETEDATE datetime comment '完成时间~~',
  ERRORINFO VARCHAR(500) comment '导入导出失败错误信息~~',
  primary key (SYSIEI_ID)
);

alter table SYS_IMPEXPINFO COMMENT '导入导出信息表~~';

/*==============================================================*/
/*   sql_20240816 wzy           */
/*==============================================================*/
ALTER TABLE TRESOURCE
    MODIFY COLUMN code varchar(200) ;


/*==============================================================*/
/*   sql_20240822 zhangdexin           */
/*==============================================================*/
delete from common_appconfig where configkey = 'Syserrorlog_insert';
commit;
insert into common_appconfig (configkey, configtitle, configname, type, display, coment)
  values('Syserrorlog_insert', '错误日志入库', '错误日志入库', 100, 2, '默认不入库，开关打开后入库');
commit;

update common_appconfig set type = 200, display = 1, configvalue = '0' where configkey = 'Syserrorlog_insert';
commit;

update common_appconfig set type = 200 where configkey = 'GATEWAY_RBAC';
commit;


/*==============================================================*/
/*   sql_20240901 zhangkai 新增文件上传限制字典                     */
/*==============================================================*/
INSERT INTO COMMON_APPDICTCATEGORY (CATEGORY_ID, CODE, NAME, ISTREE, CREATEDATE, NEEDVALUE, NEEDORDER, PARENT_ID, NEEDCODE, DOMAIN_ID, CREATOR_ID, REMARK)
VALUES (211, 'FILEUPLOAD_PERMISSION', '文件上传类型限制', 1, now(), 1, 1, 0, 1, 9002, 101, '文件上传类型限制');


INSERT INTO COMMON_APPDICT (APPDICT_ID, DOMAIN_ID, CODE, NAME, VAL, ORDERNUM, CATEGORY_ID, PARENT_ID, FULLPATH, CREATEDATE, CREATEWAY, ISVALID, COMMENTS, CREATOR_ID)
SELECT  (max(appdict_id) + 1) AS id, 9002, 'FILEUPLOAD_103', '文档上传', null, 1, 211, 0, CONCAT(CONCAT(',211,,', (max(appdict_id) + 1)), ','),
        now(), null, 1, '.pdf,.png,.jpg,.gif,.ico,.jpeg', 101
FROM  COMMON_APPDICT;
commit;

/*==============================================================*/
/*   sql_20240912a zhk  修改字典名称编号字段长度		*/
/*==============================================================*/
alter table COMMON_APPDICT modify CODE varchar(500);

alter table COMMON_APPDICT modify NAME varchar(500);


/*==============================================================*/
/*   sql_20240918 ldc 新增前端版本号配置                     */
/*==============================================================*/
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_PC', 'PC端发布版本号', 'PC端发布版本号', 300, 2, 'PC端发布版本号'， sysdate);
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_APP', 'APP端发布版本号', 'APP端发布版本号', 300, 2, 'APP端发布版本号'， sysdate);
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_WeChat', 'WeChat端发布版本号', 'WeChat端发布版本号', 300, 2, 'WeChat端发布版本号'， sysdate);
commit;

/*==============================================================*/
/*   sql_20240918 ldc 新增前端版本号配置                     */
/*==============================================================*/
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_PC', 'PC端发布版本号', 'PC端发布版本号', 300, 2, 'PC端发布版本号', CURRENT_TIMESTAMP);
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_APP', 'APP端发布版本号', 'APP端发布版本号', 300, 2, 'APP端发布版本号', CURRENT_TIMESTAMP);
insert into common_appconfig (configkey, configtitle, configname, type, display, coment, createdate)
  values('Key_ForeendVersion_WeChat', 'WeChat端发布版本号', 'WeChat端发布版本号', 300, 2, 'WeChat端发布版本号', CURRENT_TIMESTAMP);
commit;


/*==============================================================*/
/*   sql_20240924 wzy           */
/*==============================================================*/
ALTER TABLE torg
    ADD COLUMN SHORTFULLNAME varchar(500) NULL COMMENT '机构短全路径名，示例：北京分行-人力资源部' ;

    CREATE TABLE SYS_IMPEXPINFO (
      SYSIEI_ID numeric(20,0) NOT NULL comment '主键id~~',
      BUSINESS_ID numeric(20,0) comment '业务id~~',
      BUSINESSTYPE numeric(8,0) comment '业务类型~~',
      EXETYPE numeric(2, 0) comment '执行类型，1：导出，2：导入~~',
      STATUS numeric(2,0) comment '状态，0：进行中，1：已完成，2：操作失败~~',
      IMPORTTOTALNUM numeric(8,0) comment '导入总数~~',
      IMPORTSUCCESSNUM numeric(8,0) comment '导入成功数~~',
      IMPORTERRORNUM numeric(8,0) comment '导入错误数~~',
      FILEPATH VARCHAR(200) comment '文件路径，导入导出完成时才有值~~',
      CREATEDATE datetime NOT NULL comment '创建时间~~',
      COMPLETEDATE datetime comment '完成时间~~',
      ERRORINFO VARCHAR(500) comment '导入导出失败错误信息~~',
      primary key (SYSIEI_ID)
    );

/*==============================================================*/
/* sql_20241012 liudachang 新增系统编号规则配置表                                         */
/*==============================================================*/
create table SYS_SYSCODE
(
   SYSCODE_ID           numeric(20,0) not null comment '主键Id~~',
   DOMAIN_ID            numeric(20,0) not null comment '域ID',
   BUSINESSTYPE         numeric(8,0) comment '业务类型~~',
   NAME                 VARCHAR(100) comment '编号类型显示名称~~',
   CODERULE             VARCHAR(200) comment '编号规则~~',
   MAXNUM               numeric(8,0) comment '当前最大使用数~~',
   UPDATER_ID           numeric(20,0) comment '最后更新者ID~~',
   UPDATEDATE           datetime comment '最后修改日期~~',
   primary key (SYSCODE_ID)
);

alter table SYS_SYSCODE COMMENT '系统编号规则配置表~~';



/*==============================================================*/
/*   sql_20241012 liudachang    编号规则配置类型注册初始化          */
/*==============================================================*/
delete from common_appdictcategory where category_id = 3801;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID, remark)
values (3801, '编号规则配置', '编号规则配置模板关键字', 1, 1, 1, 1, CURRENT_TIMESTAMP, 0, 9002, 101, '1');
commit;


/*==============================================================*/
/*   sql_20241012 liudachang   新增字典表中的编号规则配置关键字 */
/*==============================================================*/
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1000, 9002, '年', '{{YYYY}}', '1', 1, 3801, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '月', '{{MM}}', '2', 2, 3801, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '日', '{{DD}}', '3', 3, 3801, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '3位序列号', '{{3SN}}', '4', 4, 3801, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '4位序列号', '{{4SN}}', '5', 5, 3801, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, '5位序列号', '{{5SN}}', '6', 6, 3801, CURRENT_TIMESTAMP, 1 from common_appdict;
commit;

/*==============================================================*/
/*   sql_20241012 liudachang   初始化课程、培训班的编号规则配置      */
/*==============================================================*/
insert into sys_syscode(syscode_id, domain_id, businesstype, name, coderule, maxnum, updater_id, updatedate)
values (-10001, 9002, 1, '课程编号', 'LE-{{YYYY}}-{{MM}}-{{DD}}-{{5SN}}', 0, 101, CURRENT_TIMESTAMP);
insert into sys_syscode(syscode_id, domain_id, businesstype, name, coderule, maxnum, updater_id, updatedate)
values (-10002, 9002, 2200, '培训班编号', 'TC-{{YYYY}}-{{MM}}-{{DD}}-{{3SN}}', 0, 101, CURRENT_TIMESTAMP);
commit;

/*==============================================================*/
/* sql_20241012 liudachang 重新设置模板业务类型                   */
/*==============================================================*/
delete from common_appdictcategory where category_id = 318;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID)
values (318, '模板业务类型', '模板业务类型', 1, 1, 1, 1, CURRENT_TIMESTAMP, 0, 9002, 101);
commit;

/*==============================================================*/
/* sql_20241012 liudachang 3101、3102的父类型挂载到模板业务类型 */
/*==============================================================*/
update common_appdictcategory set parent_id = 318 where category_id in (3101, 3102);
commit;

/*==============================================================*/
/* sql_20241021 liudachang 新增系统追踪日志表                      */
/*==============================================================*/
create table SYS_TRACELOG
(
   TRACELOG_ID          numeric(20) not null comment '主键Id~~',
   LOGTITLE             VARCHAR(500) comment '主题~~',
   LOGCONTENT           VARCHAR(500) comment '内容~~',
   SERVICENAME          VARCHAR(200) comment '服务名称~~',
   LOGLEVEL             numeric(5) comment '级别~~',
   CREATEDATE           datetime comment '创建时间~~',
   primary key (TRACELOG_ID)
);

alter table SYS_TRACELOG COMMENT '系统追踪日志表~~';


/*==============================================================*/
/*   sql_20241021 liudachang    系统追踪日志级别类型注册初始化  */
/*==============================================================*/
delete from common_appdictcategory where category_id = 3900;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID, remark)
values (3900, '系统追踪日志级别', '系统追踪日志级别类型', 1, 1, 1, 1, CURRENT_TIMESTAMP, 0, 9002, 101, '1');
commit;


/*==============================================================*/
/*   sql_20241021 liudachang   新增系统追踪日志级别类型关键字   */
/*==============================================================*/
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1000, 9002, 'ERROR', 'ERROR', '1', 1, 3900, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, 'WARN', 'WARN', '2', 2, 3900, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, 'INFO', 'INFO', '3', 3, 3900, CURRENT_TIMESTAMP, 1 from common_appdict;
insert into common_appdict(appdict_id, domain_id, code, name, val, ordernum, category_id, createdate, isvalid)
select max(appdict_id) + 1, 9002, 'DEBUG', 'DEBUG', '4', 4, 3900, CURRENT_TIMESTAMP, 1 from common_appdict;
commit;

/*==============================================================*/
/*   sql_20241021 liudachang   初始化系统追踪日志级别配置            */
/*==============================================================*/
update common_appconfig set type = 400
where configkey = 'Syserrorlog_insert';
commit;


delete from common_appconfig where configkey = 'Systracelog_level';
commit;
insert into common_appconfig (configkey, configtitle, configname, configvalue, type, display, coment, createdate)
  values('Systracelog_level', '系统追踪日志级别配置', '系统追踪日志级别配置(仅可填写1、2、3、4这几个数字)', '2', 400, 2,
        '填写不同日志级别，记录对应的日志信息，级别依次为【从高到低】：4(ERROR) > 3(WARN) > 2(INFO) > 1(DEBUG)', CURRENT_TIMESTAMP);
commit;


/*==============================================================*/
/*   sql_20241031 liudachang    域数据迁移类型注册初始化        */
/*==============================================================*/
delete from common_appdictcategory where category_id = 4000;
insert into common_appdictcategory(category_id, code, name, istree, needvalue, needorder, needcode, createdate,parent_id, DOMAIN_ID,CREATOR_ID, remark)
values (4000, '域数据迁移表配置', '域数据迁移表配置', 1, 1, 1, 1, CURRENT_TIMESTAMP, 0, 9002, 101, '1');
commit;

/*==============================================================*/
/*   sql_20241106 zhk    MQ消息清理后保留多少天的数据注册初始化        */
/*==============================================================*/
insert into common_appconfig (configkey, configtitle, configname, configvalue, type, display, coment, createdate)
values('MESSAGEQLOG_RESERVE_DAYS', 'MQ消息清理后保留多少天的数据', 'MQ消息清理后保留多少天的数据', '90', 400, 2,
       'MQ消息清理后保留多少天的数据', CURRENT_TIMESTAMP);
commit;


/*==============================================================*/
/*   sql_20241125 ldc 新增课程学时计算配置项                        */
/*==============================================================*/

delete from common_appconfig where configkey = 'IS_NOVIDEOLESSON_CLASSHOUR';
delete from common_appconfig where configkey = 'PER_15MLESSON_CLASSHOUR';
delete from common_appconfig where configkey = 'NOVIDEOLESSON_MAXCLASSHOUR';
delete from common_appconfig where configkey = 'PER_15MLESSON_CLASSHOUR_UP';
delete from common_appconfig where configkey = 'IS_AUTO_LESSONCLASSHOUR';

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('NOVIDEOLESSON_MAXCLASSHOUR', '课程中不包含纯视音频课件，最大获得学时数', '课程中不包含纯视音频课件，最大获得学时数',
       1,102, 2, '纯视音频课件指课件是单一视频文件或单一音频文件', CURRENT_TIMESTAMP);

insert into common_appconfig (configkey, configtitle, configname, configvalue, type, display, coment, createdate)
values('IS_NOVIDEOLESSON_CLASSHOUR', '非纯视音频课件是否参与学时计算', '非纯视音频课件是否参与学时计算',
       '0', 102, 1, '非纯视音频课件指文档、图片、H5等类型课件<br/>纯视音频课件指课件是单一视频文件或单一音频文件', CURRENT_TIMESTAMP);

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('PER_15MLESSON_CLASSHOUR', '每15分钟课程时长兑换学时数量', '每15分钟课程时长兑换学时数量',
       '0.25',102, 2, '示例：2分钟按照0.25学时计算；16分钟按照0.5学时计算', CURRENT_TIMESTAMP);

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('PER_15MLESSON_CLASSHOUR_UP', '每15分钟课程时长兑换学时数量余数计算方法，1：向上取整，0：向下取整', '每15分钟课程时长兑换学时数量余数计算方法',
       '1',102, 1, '启用：向上取整，示例：2分钟按照0.25学时计算；16分钟按照0.5学时计算<br/>停用：向下取整，示例：2分钟按照0学时计算；16分钟按照0.25学时计算', CURRENT_TIMESTAMP);

insert into common_appconfig (configkey, configtitle, configname, configvalue,type, display, coment, createdate)
values('IS_AUTO_LESSONCLASSHOUR', '是否自动计算课程学时，1：启用，0：停用', '是否自动计算课程学时',
       '1',102, 1, '启用：课程根据课件时间系统自动计算课程学时，课程学时不允许修改<br/>停用：课程学时系统不自动计算，管理员可以手工填写', CURRENT_TIMESTAMP);
commit;

/*==============================================================*/
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*   core不要再写 sql 都移到rescom服务中写                    */
/*==============================================================*/