package com.peak.common.util;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.lang.reflect.Method;

/**
 * aop处理util
 * @author weizhenyong
 * @date 2024/4/8 12:11
 */
public class AOPUtil {
    /**
     * 设置Spel环境
     * @param joinPoint
     * @return org.springframework.expression.spel.support.StandardEvaluationContext
     * @author weizhenyong
     * @date 2024/4/8 10:45
     */
    public static StandardEvaluationContext getContextVariables(JoinPoint joinPoint) {
        // 设置Spel环境
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        //获取到方法签名，进而获得方法
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        //获得类原始方法参数名称
        DefaultParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        String[] parametersName = parameterNameDiscoverer.getParameterNames(targetMethod);
        //获得类原始方法参数值
        Object[] args = joinPoint.getArgs();
        //方法无参数
        if (args == null || args.length <= 0) {
            return standardEvaluationContext;
        }
        // 填充表达式上下文环境
        for (int i = 0; i < args.length; i++) {
            standardEvaluationContext.setVariable(parametersName[i], args[i]);
        }
        return standardEvaluationContext;
    }

    /**
     * 通过key获得spel 定义的参数值
     * @param context 参数容器
     * @param key     参数key
     * @param clazz 需要返回的类型
     * @return T 参数值
     * @author weizhenyong
     * @date 2024/4/8 10:49
     */
    public static  <T> T  getSpelValue(StandardEvaluationContext context, String key,  Class<T> clazz) {
        ExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(key);
        return exp.getValue(context, clazz);

    }
}
