package com.peak.common.util;

import com.peak.prd.config.AppPathConfig;

public class AppPathUtil {
	
	private static String resourceLocalPath = null;

	private static String tempLocalPath = null;
	/**
	 * localPath表示本地路径，即获取共享资源目录的本地路径<br />
	 * 所有上传，都应该使用本方法，而不要使用getRealPath之类<br />
	 * 实际部署中，程序目录可能和资源目录分离
	 * @return 形如"d:\xxx\resource 或 /data/resource等"
	 */
	public static String getResourceLocalPath() {
		if (resourceLocalPath != null) return resourceLocalPath;
		
		AppPathConfig config = SpringUtil.getBean(AppPathConfig.class);
		resourceLocalPath = config.getResourceLocalpath();
		return resourceLocalPath;
	}


	/**
	 *  获取临时存储目录
	 * @return 临时存储目录
	 * @author wzy
	 * @date 2023/3/10 10:39
	 */
	public static String getTempLocalPath() {
		if (!StringUtil.isNullorEmptyStr(tempLocalPath)) {
			return tempLocalPath;
		}
		AppPathConfig config = SpringUtil.getBean(AppPathConfig.class);
		tempLocalPath = config.getTempLocalpath();
		return tempLocalPath;
	}

}
