package com.peak.common.util;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import org.apache.commons.codec.binary.Base64;
public class Base64Util {
	/**
     * 使用Base64加密字符串
     * @return 加密之后的字符串
     * @exception Exception
     */
    public static String encode(byte[] data){
        Base64 base64 = new Base64();
        String encodedData = base64.encodeAsString(data);
        return encodedData;
    }
    /**
     * 使用Base64解密
     * @return 解密之后的字符串
     * @exception Exception
     */
    public static byte[] decode(String data){
        Base64 base64 = new Base64();
        byte[] decodedData = base64.decodeBase64(data);
        return decodedData;
    }
    
    /**
	 * <p>校验base64字符串是否为图片</p>
	 * @param base64codefile			base64文件字符串
	 * @return
	 */
	public static boolean base64IsImage(String base64codefile) {
		try {
			if(base64codefile.indexOf(",") > -1) { 
				base64codefile = base64codefile.substring(base64codefile.indexOf(",") + 1);
			}
			
			BufferedImage bugImg = ImageIO.read(new ByteArrayInputStream(Base64Util.decode(base64codefile)));
			if(bugImg == null) {
				return false;
			}
		} catch (Exception e) {
			return false;
		}
		return true;
	}

    /**
     * 获得base64图片大小
     * @param base64Image
     * @return long
     * @author ldc
     * @date 2024/9/27 10:13
    */
    public static long getBase64ImageSize(String base64Image) {
        byte[] imageBytes = decode(base64Image);
        return imageBytes.length / 1024;
    }
	
	/**
     * 图片转Base64字符串
     * @param imageFileName
     * @return
     */
    public static String convertImagePathToBase64(String imageFileName) {
        ByteArrayOutputStream baos = null;
        try {
            //获取图片类型
            String suffix = imageFileName.substring(imageFileName.lastIndexOf(".") + 1);
            //构建文件
            File imageFile = new File(imageFileName);
            //通过ImageIO把文件读取成BufferedImage对象
            BufferedImage bufferedImage = ImageIO.read(imageFile);
            //构建字节数组输出流
            baos = new ByteArrayOutputStream();
            //写入流
            ImageIO.write(bufferedImage, suffix, baos);
            //通过字节数组流获取字节数组
            byte[] bytes = baos.toByteArray();
            //获取JDK8里的编码器Base64.Encoder转为base64字符
            return "data:image/"+suffix+";base64," + java.util.Base64.getEncoder().encodeToString(bytes);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (baos != null) {
                    baos.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}