package com.peak.common.util;/**
 * 功能描述:
 *
 * @author zhk
 * @version 1.0
 * @since 1.0   - 2023/8/28
 */

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;

/**
 * <p> BrowserUtil</p >
 * <p> com.peak.common.util</p > 
 * <p> 2023/8/28 17:26 </p >
 * @author zhk
 */
public class BrowserUtil {
    public static String getFileNameToClient(String fileNameToClient, HttpServletRequest request) throws UnsupportedEncodingException {
        String agent = request.getHeader("USER-AGENT");
        if (null != agent && -1 != agent.indexOf("MSIE")){
            fileNameToClient = URLEncoder.encode(fileNameToClient , "UTF-8");
			/*if (agent.indexOf("MSIE 8") >= 0) {
				fileNameToClient = URLEncoder.encode(fileNameToClient , "UTF8");
			}
			else {
				fileNameToClient = URLEncoder.encode(fileNameToClient , "UTF8");
			}*/
        }
        else if (null != agent && -1 != agent.indexOf("Windows NT")){
            fileNameToClient = URLEncoder.encode(fileNameToClient , "UTF-8");
        }
        else if (null != agent && -1 != agent.indexOf("Mozilla")){
            fileNameToClient = new String(fileNameToClient.getBytes("UTF-8"), "ISO8859-1");
        }

        return fileNameToClient;
    }

    public static void downloadFile(File writefile, String contentType, String fileNameToClient, HttpServletRequest request, HttpServletResponse response) throws Exception {
        InputStream instream = null;

        try {
            instream = new FileInputStream(writefile);
            downloadFile(instream, contentType, fileNameToClient, request, response);
        }
        finally {
            if (instream != null) {
                instream.close(); // 必须
            }
        }
    }

    public static void downloadFile(InputStream instream, String contentType, String fileNameToClient, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.addHeader("Content-Disposition","attachment;filename=\"" + BrowserUtil.getFileNameToClient(fileNameToClient, request) + "\"");
        response.setContentType(contentType);
        OutputStream outp = null;

        try {
            outp = response.getOutputStream();
            byte[] b = new byte[1024 * 10];
            int i = 0;
            while((i = instream.read(b)) > 0){
                outp.write(b, 0, i);
            }
            outp.flush();
        }
        finally {
            if (outp != null) {
                outp.close();
            }
        }
    }

}
