package com.peak.common.util;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Random;

/**
 * 验证码
 * 
 * @author zhangdexin
 *
 */
public class CheckcodeUtil {
	
	/**
     * 生成验证码，返回浏览器
     * @param checkcode
     * @param response
     * @throws Exception
     */
    public static void getCheckcodeImg(String checkcode, HttpServletResponse response) throws Exception {
        if (checkcode == null || checkcode.isEmpty()) {
        	return;
        }

        // 根据验证码生成图片
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0);
        response.setContentType("image/jpeg");

        String[] fonts = new String[] { "Times New Roman", "Arial" };
        int width = 100, height = 30; // image width/height
        int fontSize = 18 + Math.round((new Random().nextFloat()) * 6);
        int xPos = 6 + Math.round((new Random().nextFloat()) * 20);
        int yPos = 16 + Math.round((new Random().nextFloat()) * 10);
        BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
        Graphics g = image.getGraphics();
        Random random = new Random();
//        g.setColor(getRandColor(200, 250));
        g.setColor(Color.WHITE); // 背景色
        g.fillRect(0, 0, width, height);
        g.setColor(getRandColor(160, 200));

        // 干扰线
        for (int i = 0; i < 100; i++) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }

        // 验证码字符内容
        for (int i = 0; i < checkcode.length(); i++) {
            int fontX = (new Random()).nextInt(fonts.length - 1); // 随机字体
            g.setFont(new Font(fonts[fontX], Font.PLAIN, fontSize));
//            g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
            g.setColor(Color.BLACK);
            g.drawString(checkcode.charAt(i) + "", 20 * i + xPos, yPos);
        }

        // 椭圆反色
        g.setXORMode(Color.WHITE);
//                g.setColor(new Color(10, 10, 10));
        g.setColor(Color.BLACK);
        for (int i = 0; i< 3; i++) {
            int posX = (int)(Math.random() * 100) - 20;
            int posY = (int)(Math.random() * 25);
            g.fillArc(posX, posY, 30, 15, 0, 360);
        }

        g.dispose();
        ImageIO.write(image, "JPEG", response.getOutputStream());
    }
    
	/**
	 * 生成验证码，返回浏览器 --- 废弃了，图形太简单
	 * @param checkcode
	 * @param response
	 * @throws Exception
	 */
	private static void getCheckcodeImg_del(String checkcode, HttpServletResponse response) throws Exception {
		if (checkcode == null || checkcode.isEmpty()) return;
		
		// 根据验证码生成图片
		response.setHeader("Pragma", "No-cache");
		response.setHeader("Cache-Control", "no-cache");
		response.setDateHeader("Expires", 0);
		response.setContentType("image/jpeg");

		String[] fonts = new String[] { "Times New Roman", "Arial" };
		int width = 100, height = 30; // image width/height
		int fontSize = 18 + Math.round((new Random().nextFloat()) * 6);
		int xPos = 6 + Math.round((new Random().nextFloat()) * 20);
		int yPos = 16 + Math.round((new Random().nextFloat()) * 10);
		BufferedImage image = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics g = image.getGraphics();
		Random random = new Random();
		g.setColor(getRandColor(200, 250));
		g.fillRect(0, 0, width, height);
		g.setColor(getRandColor(160, 200));
		for (int i = 0; i < 100; i++) {
			int x = random.nextInt(width);
			int y = random.nextInt(height);
			int xl = random.nextInt(12);
			int yl = random.nextInt(12);
			g.drawLine(x, y, x + xl, y + yl);
		}
		for (int i = 0; i < checkcode.length(); i++) {
			int fontX = (new Random()).nextInt(fonts.length - 1);
			g.setFont(new Font(fonts[fontX], Font.PLAIN, fontSize));
			g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
			g.drawString(checkcode.charAt(i) + "", 20 * i + xPos, yPos);
		}
		// write session
		// session.setAttribute("_check_code_", sRand.toLowerCase());
		g.dispose();
		ImageIO.write(image, "JPEG", response.getOutputStream());
	}

	protected static Color getRandColor(int fc, int bc) {
		Random random = new Random();
		if (fc > 255)
			fc = 255;
		if (bc > 255)
			bc = 255;
		int r = fc + random.nextInt(bc - fc);
		int g = fc + random.nextInt(bc - fc);
		int b = fc + random.nextInt(bc - fc);
		return new Color(r, g, b);
	}
	
	/**
	 * 放1个新的验证码进redis
	 * @param checkcodeRedisKey redisKey
	 * @param seconds 生命期（秒）
	 * @return 新验证码
	 */
	public static String createCheckcodeInRedis(String checkcodeRedisKey, int seconds) {
		Random random = new Random();
//		int MAX = 9999;
//		int MIN = 1000;
//		int randNumber = random.nextInt(MAX - MIN) + MIN;
		
		String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
	    String sRand = "";    
	    for (int i = 0; i < 4; i++) {
	        String rand;
			int charsIndex = (new Random()).nextInt(chars.length());
			if (charsIndex < chars.length() / 2)
				rand = String.valueOf(random.nextInt(10)); 
			else
				rand = "" + chars.charAt(charsIndex);
			sRand += rand;   
	    }    
	    
	    SpringUtil.getBean(RedisService.class).set(checkcodeRedisKey, sRand, seconds); // 验证码有效期
		
		return sRand;
	}
	
	/**
	 * 验证码是否匹配
	 * @param checkcodeRedisKey redis中的验证码
	 * @param checkcodeByUser 用户输入的验证码
	 * @return
	 */
	public static boolean isMatchCheckcode(String checkcodeRedisKey, String checkcodeByUser) {
		if (checkcodeByUser == null || checkcodeByUser.isEmpty()) return false;
		
		String checkcodeInRedis  = SpringUtil.getBean(RedisService.class).get(checkcodeRedisKey);
		if (checkcodeInRedis == null) return false; // redis中没有验证码（过期了），算作不匹配
		
		return checkcodeInRedis.equalsIgnoreCase(checkcodeByUser);
	}
}
