/*
 * Copyright [2011] [C.H Li http://code.google.com/p/idocbox-common/]
 * Licensed to the Chunhui Li(C.H Li) under one or more contributor license agreements.  
 * See the NOTICE file distributed with this work for additional information 
 * regarding copyright ownership.
 *
 * C.H Li licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.peak.common.util;

import com.peak.security.rsa.RSAService;

/**
 * 用户在浏览器输入的密码，加密后，传到服务器
 */
public class ClientPwdUtil {
	
	private static final RSAService rsaService = RSAService.getInstance();
	/**
	 * 将客户端加密传输过来的内容解密
	 * @param clientEncryptPwd 客户端加密后的密码
	 * @return 解密的密码，如果解密失败返回null
	 * @author wzy
	 * @date 2023/3/1 13:25
	 */
	public static String decryptClientPwd(String clientEncryptPwd) {
		if (clientEncryptPwd == null || clientEncryptPwd.isEmpty()) return clientEncryptPwd;
		
		try {
			return rsaService.decrypt(clientEncryptPwd);
		}
		catch (Exception ex) {
			ex.printStackTrace();
			return null;
		}
	}


}

