package com.peak.common.util;/**
 * 功能描述:
 *
 * @author zhk
 * @version 1.0
 * @since 1.0   - 2023/8/28
 */

import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/**
 * <p> CommonUtil</p >
 * <p> com.peak.common.util</p > 
 * <p> 2023/8/28 17:38 </p >
 * @author zhk
 */
public class CommonUtil {
    /** 当前进程id */
    public static String getPid() {
        try {
            String jvmName = ManagementFactory.getRuntimeMXBean().getName();
            return jvmName.split("@")[0];
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static boolean isEmpty(Object o) throws IllegalArgumentException {
        if (o == null)
            return true;

        if (o instanceof String) {
            if (((String) o).length() == 0) {
                return true;
            }
        } else if (o instanceof Collection) {
            if (((Collection) o).isEmpty()) {
                return true;
            }
        } else if (o.getClass().isArray()) {
            if (Array.getLength(o) == 0) {
                return true;
            }
        } else if (o instanceof Map) {
            if (((Map) o).isEmpty()) {
                return true;
            }
        } else {
            return false;
            // throw new
            // IllegalArgumentException("Illegal argument type,must be : Map,Collection,Array,String. but was:"+o.getClass());
        }

        return false;
    }

    public static String getRandomStr(int length) {
        String ALPHA1 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_";
        String ALPHA2 = ALPHA1 + "0123456789";
        int rand = (int)Math.floor(Math.random() * ALPHA1.length());
        String str = ALPHA1.substring(rand, rand + 1);
        for (int i = 0; i < length - 1; ++i) {
            rand = (int)Math.floor(Math.random() * ALPHA2.length());
            str += ALPHA2.substring(rand, rand + 1);
        }
        return str;
    }

    /**
     * 坐标A1/A2/B1/B2/C1...
     * AA1/AB1/AC1..
     * @return
     */
    public static String getCoord(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0)
            return null;
        String prefix;
        if (colIndex < 26)
            prefix = "";
        else
            prefix = (char)('A' + (colIndex / 26) - 1) + "";
        char c = (char)('A' + colIndex % 26);
        return prefix + c + (rowIndex + 1);
    }

    /** 格式化路径（尾部带斜杠）*/
    public static String formatByEndSlash(String str) {
        if (str == null || str.isEmpty())
            return str;
        str = str.replaceAll("\\\\", "/");
        if (str.endsWith("/"))
            return str;
        return str += "/";
    }

    public static void main(String[] args) {



    }

//	function getRandomInt(min, max) {
//		  return Math.floor(Math.random() * (max - min + 1)) + min;
//		}
//
//	function random_str(length) {
//		  var ALPHABET = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
//		  ALPHABET += 'abcdefghijklmnopqrstuvwxyz';
//		  ALPHABET += '0123456789-_';
//		  var str = '';
//		  for (var i = 0; i < length; ++i) {
//		    var rand = Math.floor(Math.random() * ALPHABET.length);
//		    str += ALPHABET.substring(rand, rand + 1);
//		  }
//		  return str;
//		}

//	public static long getDelta(Date dstart, Date dend) {
//		return dend.getTime() - dstart.getTime();
//	}
}
