package com.peak.common.util;

import com.peak.prd.config.DialectConfig;

/**
 * 工具类用于针对不同的数据库函数名称差异的统一管理，主要是为了在sql表达式访问静态方法时可以减少长长的类名称编写
 * 访问静态方法的表达式为: @DBFunction@method(args)
 * 
 * 示例使用: 
 * <pre>
 * SELECT <include refid="Pic.columns" />
 *			FROM BASE_PIC pic
 *			order by ${@DBFunction@dbRandom()}
 * </pre>
 * @author weizhenyong
 *
 */
public class DBFunction {
	/**
	 * 获得数据库随机函数,使用示例：${@DBFunction@random()}
	 * @return
	 */
	public static String  random()
	{
		//oracle 随机函数作为默认值
		String random = " dbms_random.value ";
		//DB2数据库
		if (isDb2() || isMysql()) {
			random = " RAND() ";
		} else if (isSqlserver()) {
			random = " newid() ";
		} else if(isGauss()  || isPostgresql()) {
			random = " random() ";
		}
		return random;
	}
	/**
	 * 获得列变行函数，使用示例：${@DBFunction@columnsToRow(columnName)}
	 * @return
	 */
	public static String  columnsToRow(String columnName)
	{
		String rtn = "TO_CHAR(WM_CONCAT("+ columnName + "))";//oracle列变行函数
		if (isDb2()) {//DB2数据库
			rtn = "LISTAGG("+ columnName + ",',')";
		} 
		return rtn;
	}

	/**
	 * 数据库方言：oracle
	 * @return
	 */
	static Boolean _oracle = null;
	public static boolean  isOracle() 
	{
		if (_oracle == null) {
			_oracle = SpringUtil.getBean(DialectConfig.class).isOracle();
		}
		return _oracle.booleanValue();
	}
	
	/**
	 * 数据库方言：db2
	 * @return
	 */
	static Boolean _db2 = null;
	public static boolean  isDb2() 
	{
		if (_db2 == null) {
			_db2 = SpringUtil.getBean(DialectConfig.class).isDb2();
		}
		return _db2.booleanValue();
	}
	
	/**
	 * 数据库方言：mysql
	 * @return
	 */
	static Boolean _mysql = null;
	public static boolean  isMysql() 
	{
		if (_mysql == null) {
			_mysql = SpringUtil.getBean(DialectConfig.class).isMysql();
		}
		return _mysql.booleanValue();
	}
	
	/**
	 * 数据库方言：sqlserver
	 * @return
	 */
	static Boolean _sqlserver = null;
	public static boolean  isSqlserver() 
	{
		if (_sqlserver == null) {
			_sqlserver = SpringUtil.getBean(DialectConfig.class).isSqlserver();
		}
		return _sqlserver.booleanValue();
	}


	private static Boolean _gauss = null;
	/**
	 * 是否gauss数据库
	 * @return true：是；false：否
	 * @author wzy
	 * @date 2023/10/25 9:44
	 */
	public static boolean  isGauss()
	{
		if (_gauss == null) {
			_gauss = SpringUtil.getBean(DialectConfig.class).isGauss();
		}
		return _gauss.booleanValue();
	}

	private static Boolean _postgresql = null;

	/**
	 * 是否isPostgresql数据库
	 * @return boolean
	 * @author weizhenyong
	 * @date 2025/2/25 17:20
	 */
	public static boolean  isPostgresql()
	{
		if (_postgresql == null) {
			_postgresql = SpringUtil.getBean(DialectConfig.class).isPostgresql();
		}
		return _postgresql.booleanValue();
	}
	
	/**
	 * 获得数据库判空函数,使用示例：${@DBFunction@checkNull()}
	 * @author weizhenyong
	 * @return
	 */
	public static String  checkNull()
	{
		String checkNull = " nvl";//oracle 随机函数作为默认值
		if (isMysql()) {//mysql数据库
			checkNull = " IFNULL";
		} else if (isSqlserver()) {
			checkNull = " ISNULL";
		} else if (isPostgresql()) {
			checkNull = " COALESCE ";
		}
		return checkNull;
	}
	/**
	 * 获得数据库当前时间函数,使用示例：${@DBFunction@currentTime()}
	 * @author weizhenyong
	 * @return
	 */
	public static String  currentTime()
	{
		String currentTime = " sysdate ";//oracle 随机函数作为默认值
		if (isMysql()) {
			currentTime = " CURRENT_TIMESTAMP ";
		} else if (isSqlserver()) {
			currentTime = " GETDATE() ";
		} else if (isPostgresql()) {
			currentTime = " NOW() ";
		}
		return currentTime;
	}


	/**
	 * 获得多个数中的最大值函数,使用示例：${@DBFunction@greatest()}
 	 * @return java.lang.String
	 * @author wzy
	 * @date 2022/8/23 11:50
	 */
	public static String  greatest()
	{
		String greatest = " greatest ";//oracle 最大值作为默认值
		if (isSqlserver()) {
			greatest = " dbo.greatest ";
		}
		return greatest;
	}

}
