package com.peak.common.util;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * 数据鉴权工具类
 * @author zhangdexin
 *
 */
public class DataAuthUtil {
	public final static String AUTHED_DATA = "__authed__data";
	
	/**
	 * 只能在spring boot http请求中调用
	 * @param clazz
	 * @return
	 */
	public static <T> T getData(Class<T> clazz) {
		return getData(0, clazz);
	}
	
	/**
	 * 只能在spring boot http请求中调用
	 * @param clazz
	 * @return
	 */
	public static <T> T getData(int index, Class<T> clazz) {
		HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
		Object[] array = (Object[])request.getAttribute(AUTHED_DATA);
		if (array == null || array.length == 0) {
			return null;
		}
		
		return (T)array[index];
	}
}
